#pragma once

/*
 * Reserved:                          0x0000
 * Tagged props:                      0x0001..0x7FFF
 *  \_ MAPI-defined props:            0x0001..0x3FFF
 *      \_ Envelope props:            0x0001..0x0BFF
 *      \_ Recipient props:           0x0C00..0x0DFF
 *      \_ Non-transmittable props:   0x0E00..0x0FFF (non-transmittable)
 *      \_ Message content props:     0x1000..0x2FFF
 *      \_ Others:                    0x3000..0x3FFF
 *          \_ Common props:          0x3000..0x32FF
 *          \_ Form props:            0x3300..0x33FF
 *          \_ Message store:         0x3400..0x35FF
 *          \_ Container (folder/AB): 0x3600..0x36FF
 *          \_ Attachment:            0x3700..0x38FF
 *          \_ Address book:          0x3900..0x39FF
 *          \_ Mail user:             0x3A00..0x3BFF
 *          \_ Distribution list:     0x3C00..0x3CFF
 *          \_ Profsect:              0x3D00..0x3DFF
 *          \_ Status object:         0x3E00..0x3EFF
 *          \_ Display table:         0x3F00..0x3FFF
 *  \_ Transport-specific props:      0x4000..0x5FFF
 *      \_ Envelope props:            0x4000..0x57FF
 *      \_ Recipient props:           0x5800..0x5FFF
 *  \_ Client-specific props:         0x6000..0x65FF (non-transmittable)
 *  \_ Provider-specific props:       0x6600..0x67FF (non-transmittable)
 *      \_ Secure profile props:      0x67F0..0x67FF
 *  \_ Message class-specific props:  0x6800..0x7FFF
 *      \_ Content props:             0x6800..0x7BFF
 *      \_ Non-transmittable:         0x7C00..0x7FFF (non-transmittable)
 * Mapping range for named props:     0x8000..0xFFFE
 * Reserved:                          0xFFFF
 *
 * There are some more reserved ranges, but we need not bother with it.
 * NSP does not have named properties, so...
 *
 *  More properties!                  0x8000..0xFFFE
 */
namespace {
enum {
	PR_NULL = PROP_TAG(PT_NULL, 0x0000), /* PidTagNull */
	PR_EMS_TEMPLATE_BLOB = PROP_TAG(PT_BINARY, 0x0001), /* PidTagTemplateData */
	// PR_ACKNOWLEDGEMENT_MODE = PROP_TAG(PT_LONG, 0x0001), /* PidTagAcknowledgementMode */
	// PR_ALTERNATE_RECIPIENT_ALLOWED = PROP_TAG(PT_BINARY, 0x0002), /* PidTagAlternateRecipientAllowed */
	// PR_AUTHORIZING_USERS = PROP_TAG(PT_BINARY, 0x0003), /* PidTagAuthorizingUsers Canonical Property */
	// PR_AUTO_FORWARD_COMMENT = PROP_TAG(PT_UNICODE, 0x0004), /* PidTagAutoForwardComment */
	// PR_EMS_SCRIPT_BLOB = PROP_TAG(PT_BINARY, 0x0004), /* PidTagScriptData */
	PR_AUTO_FORWARDED = PROP_TAG(PT_BOOLEAN, 0x0005), /* PidTagAutoForwarded */
	// PR_CONTENT_CONFIDENTIALITY_ALGORITHM_ID = PROP_TAG(PT_BINARY, 0x0006), /* PidTagContentConfidentialityAlgorithmId */
	// PR_CONTENT_CORRELATOR = PROP_TAG(PT_BINARY, 0x0007), /* PidTagContentCorrelator */
	// PR_CONTENT_IDENTIFIER = PROP_TAG(PT_UNICODE, 0x0008), /* PidTagContentIdentifier */
	// PR_CONTENT_LENGTH = PROP_TAG(PT_LONG, 0x0009), /* PidTagContentLength */
	// PR_CONTENT_RETURN_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x000A), /* PidTagContentReturnRequested */
	// PR_CONVERSATION_KEY = PROP_TAG(PT_BINARY, 0x000B), /* PidTagConversationKey */
	// PR_CONVERSION_EITS = PROP_TAG(PT_BINARY, 0x000C), /* PidTagConversionEits */
	// PR_CONVERSION_WITH_LOSS_PROHIBITED = PROP_TAG(PT_BOOLEAN, 0x000D), /* PidTagConversionWithLossProhibited */
	// PR_CONVERTED_EITS = PROP_TAG(PT_BINARY, 0x000E), /* PidTagConvertedEits */
	// PR_DEFERRED_DELIVERY_TIME = PROP_TAG(PT_SYSTIME, 0x000F), /* PidTagDeferredDeliveryTime */
	// PR_DELIVER_TIME = PROP_TAG(PT_SYSTIME, 0x0010), /* PidTagDeliverTime */
	// PR_DISCARD_REASON = PROP_TAG(PT_LONG, 0x0011), PidTagDiscardReason */
	// PR_DISCLOSURE_OF_RECIPIENTS = PROP_TAG(PT_BOOLEAN, 0x0012), /* PidTagDisclosureOfRecipients */
	// PR_DL_EXPANSION_HISTORY = PROP_TAG(PT_BINARY, 0x0013), /* PidTagDistributionListExpansionHistory */
	// PR_DL_EXPANSION_PROHIBITED = PROP_TAG(PT_BOOLEAN, 0x0014), /* PidTagDistributionListExpansionProhibited */
	PR_EXPIRY_TIME = PROP_TAG(PT_SYSTIME, 0x0015), /* PidTagExpiryTime */
	// PR_IMPLICIT_CONVERSION_PROHIBITED = PROP_TAG(PT_BOOLEAN, 0x0016), /* PidTagImplicitConversionProhibited */
	PR_IMPORTANCE = PROP_TAG(PT_LONG, 0x0017), /* PidTagImportance */
	// PR_IPM_ID = PROP_TAG(PT_BINARY, 0x0018),
	// PR_LATEST_DELIVERY_TIME = PROP_TAG(PT_SYSTIME, 0x0019), /* PidTagLatestDeliveryTime */
	PR_MESSAGE_CLASS = PROP_TAG(PT_UNICODE, 0x001A), /* PidTagMessageClass */
	PR_MESSAGE_CLASS_A = PROP_TAG(PT_STRING8, 0x001A),
	// PR_MESSAGE_DELIVERY_ID = PROP_TAG(PT_BINARY, 0x001B), /* PidTagMessageDeliveryId */
	// PR_MESSAGE_SECURITY_LABEL = PROP_TAG(PT_BINARY, 0x001E), /* PidTagMessageSecurityLabel */
	// PR_OBSOLETED_IPMS = PROP_TAG(PT_BINARY, 0x001F), /* PidTagObsoletedMessageIds */
	// PR_ORIGINALLY_INTENDED_RECIPIENT_NAME = PROP_TAG(PT_BINARY, 0x0020), /* PidTagOriginallyIntendedRecipientName */
	// PR_ORIGINAL_EITS = PROP_TAG(PT_BINARY, 0x0021), /* PidTagOriginalEits */
	// PR_ORIGINATOR_CERTIFICATE = PROP_TAG(PT_BINARY, 0x0022), /* PidTagOriginatorCertificate */
	PR_ORIGINATOR_DELIVERY_REPORT_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0023), /* PidTagOriginatorDeliveryReportRequested */
	// PR_ORIGINATOR_RETURN_ADDRESS = PROP_TAG(PT_BINARY, 0x0024), /* PidTagOriginatorReturnAddress */
	PR_PARENT_KEY = PROP_TAG(PT_BINARY, 0x0025), /* PidTagParentKey */
	// PR_PRIORITY = PROP_TAG(PT_LONG, 0x0026), /* PidTagPriority */
	// PR_ORIGIN_CHECK = PROP_TAG(PT_BINARY, 0x0027), /* PidTagOriginCheck */
	// PR_PROOF_OF_SUBMISSION_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0028), /* PidTagProofOfSubmissionRequested */
	PR_READ_RECEIPT_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0029), /* PidTagReadReceiptRequested */
	PR_RECEIPT_TIME = PROP_TAG(PT_SYSTIME, 0x002A), /* PidTagReceiptTime */
	// PR_RECIPIENT_REASSIGNMENT_PROHIBITED = PROP_TAG(PT_BOOLEAN, 0x002B), /* PidTagRecipientReassignmentProhibited */
	// PR_REDIRECTION_HISTORY = PROP_TAG(PT_BINARY, 0x002C), /* PidTagRedirectionHistory */
	// PR_RELATED_IPMS = PROP_TAG(PT_BINARY, 0x002D), /* PidTagRelatedMessageIds */
	// PR_ORIGINAL_SENSITIVITY = PROP_TAG(PT_LONG, 0x002E), /* PidTagOriginalSensitivity */
	// PR_LANGUAGES = PROP_TAG(PT_UNICODE, 0x002F),
	PR_REPLY_TIME = PROP_TAG(PT_SYSTIME, 0x0030), /* PidTagReplyTime */
	// PR_REPORT_TAG = PROP_TAG(PT_BINARY, 0x0031), /* PidTagReportTag */
	PR_REPORT_TIME = PROP_TAG(PT_SYSTIME, 0x0032), /* PidTagReportTime */
	// PR_RETURNED_IPM = PROP_TAG(PT_BOOLEAN, 0x0033), /* PidTagReturnedMessageid */
	// PR_SECURITY = PROP_TAG(PT_LONG, 0x0034),
	// PR_INCOMPLETE_COPY = PROP_TAG(PT_BOOLEAN, 0x0035), /* PidTagIncompleteCopy */
	PR_SENSITIVITY = PROP_TAG(PT_LONG, 0x0036), /* PidTagSensitivity */
	PR_SUBJECT = PROP_TAG(PT_UNICODE, 0x0037), /* PidTagSubject */
	PR_SUBJECT_A = PROP_TAG(PT_STRING8, 0x0037),
	// PR_SUBJECT_IPM = PROP_TAG(PT_BINARY, 0x0038), /* PidTagSubjectMessageId */
	PR_CLIENT_SUBMIT_TIME = PROP_TAG(PT_SYSTIME, 0x0039), /* PidTagClientSubmitTime */
	// PR_REPORT_NAME = PROP_TAG(PT_UNICODE, 0x003A), /* PidTagReportName */
	PR_SENT_REPRESENTING_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x003B), /* PidTagSentRepresentingSearchKey */
	// PR_X400_CONTENT_TYPE = PROP_TAG(PT_BINARY, 0x003C), /* PidTagX400ContentType */
	PR_SUBJECT_PREFIX = PROP_TAG(PT_UNICODE, 0x003D), /* PidTagSubjectPrefix */
	PR_SUBJECT_PREFIX_A = PROP_TAG(PT_STRING8, 0x003D),
	// PR_NON_RECEIPT_REASON = PROP_TAG(PT_LONG, 0x003E), /* PidTagNonReceiptReason */
	PR_RECEIVED_BY_ENTRYID = PROP_TAG(PT_BINARY, 0x003F), /* PidTagReceivedByEntryId */
	PR_RECEIVED_BY_NAME = PROP_TAG(PT_UNICODE, 0x0040), /* PidTagReceivedByName */
	PR_SENT_REPRESENTING_ENTRYID = PROP_TAG(PT_BINARY, 0x0041), /* PidTagSentRepresentingEntryId */
	PR_SENT_REPRESENTING_NAME = PROP_TAG(PT_UNICODE, 0x0042), /* PidTagSentRepresentingName */
	PR_SENT_REPRESENTING_NAME_A = PROP_TAG(PT_STRING8, 0x0042),
	PR_RCVD_REPRESENTING_ENTRYID = PROP_TAG(PT_BINARY, 0x0043), /* PidTagReceivedRepresentingEntryId */
	PR_RCVD_REPRESENTING_NAME = PROP_TAG(PT_UNICODE, 0x0044), /* PidTagReceivedRepresentingName */
	PR_RCVD_REPRESENTING_NAME_A = PROP_TAG(PT_STRING8, 0x0044),
	// PR_REPORT_ENTRYID = PROP_TAG(PT_BINARY, 0x0045), /* PidTagReportEntryId */
	PR_READ_RECEIPT_ENTRYID = PROP_TAG(PT_BINARY, 0x0046), /* PidTagReadReceiptEntryId */
	// PR_MESSAGE_SUBMISSION_ID = PROP_TAG(PT_BINARY, 0x0047), /* PidTagMessageSubmissionId */
	PR_PROVIDER_SUBMIT_TIME = PROP_TAG(PT_SYSTIME, 0x0048), /* PidTagProviderSubmitTime */
	// PR_ORIGINAL_SUBJECT = PROP_TAG(PT_UNICODE, 0x0049), /* PidTagOriginalSubject */
	// PR_DISC_VAL = PROP_TAG(PT_BOOLEAN, 0x004A),
	PR_ORIG_MESSAGE_CLASS = PROP_TAG(PT_UNICODE, 0x004B), /* PidTagOriginalMessageClass */
	PR_ORIG_MESSAGE_CLASS_A = PROP_TAG(PT_STRING8, 0x004B),
	// PR_ORIGINAL_AUTHOR_ENTRYID = PROP_TAG(PT_BINARY, 0x004C), /* PidTagOriginalAuthorEntryId */
	// PR_ORIGINAL_AUTHOR_NAME = PROP_TAG(PT_UNICODE, 0x004D), /* PidTagOriginalAuthorName */
	// PR_ORIGINAL_SUBMIT_TIME = PROP_TAG(PT_SYSTIME, 0x004E), /* PidTagOriginalSubmitTime */
	PR_REPLY_RECIPIENT_ENTRIES = PROP_TAG(PT_BINARY, 0x004F), /* PidTagReplyRecipientEntries */
	PR_REPLY_RECIPIENT_NAMES = PROP_TAG(PT_UNICODE, 0x0050), /* PidTagReplyRecipientNames */
	PR_RECEIVED_BY_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x0051), /* PidTagReceivedBySearchKey */
	PR_RCVD_REPRESENTING_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x0052), /* PidTagReceivedRepresentingSearchKey */
	PR_READ_RECEIPT_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x0053), /* PidTagReadReceiptSearchKey */
	// PR_REPORT_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x0054), /* PidTagReportSearchKey */
	PR_ORIGINAL_DELIVERY_TIME = PROP_TAG(PT_SYSTIME, 0x0055), /* PidTagOriginalDeliveryTime */
	// PR_ORIGINAL_AUTHOR_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x0056), /* PidTagOriginalAuthorSearchKey */
	PR_MESSAGE_TO_ME = PROP_TAG(PT_BOOLEAN, 0x0057), /* PidTagMessageToMe */
	PR_MESSAGE_CC_ME = PROP_TAG(PT_BOOLEAN, 0x0058), /* PidTagMessageCcMe */
	PR_MESSAGE_RECIP_ME = PROP_TAG(PT_BOOLEAN, 0x0059), /* PidTagMessageRecipientMe */
	// PR_ORIGINAL_SENDER_NAME = PROP_TAG(PT_UNICODE, 0x005A), /* PidTagOriginalSenderName */
	// PR_ORIGINAL_SENDER_ENTRYID = PROP_TAG(PT_BINARY, 0x005B), /* PidTagOriginalSenderEntryId */
	// PR_ORIGINAL_SENDER_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x005C), /* PidTagOriginalSenderSearchKey */
	// PR_ORIGINAL_SENT_REPRESENTING_NAME = PROP_TAG(PT_UNICODE, 0x005D), /* PidTagOriginalSentRepresentingName */
	// PR_ORIGINAL_SENT_REPRESENTING_ENTRYID = PROP_TAG(PT_BINARY, 0x005E), /* PidTagOriginalSentRepresentingEntryId */
	// PR_ORIGINAL_SENT_REPRESENTING_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x005F), /* PidTagOriginalSentRepresentingSearchKey */
	PR_START_DATE = PROP_TAG(PT_SYSTIME, 0x0060), /* PidTagStartDate */
	PR_END_DATE = PROP_TAG(PT_SYSTIME, 0x0061), /* PidTagEndDate */
	PR_OWNER_APPT_ID = PROP_TAG(PT_LONG, 0x0062), /* PidTagOwnerAppointmentId */
	PR_RESPONSE_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0063), /* PidTagResponseRequested */
	PR_SENT_REPRESENTING_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0064), /* PidTagSentRepresentingAddressType */
	PR_SENT_REPRESENTING_ADDRTYPE_A = PROP_TAG(PT_STRING8, 0x0064),
	PR_SENT_REPRESENTING_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x0065), /* PidTagSentRepresentingEmailAddress */
	PR_SENT_REPRESENTING_EMAIL_ADDRESS_A = PROP_TAG(PT_STRING8, 0x0065),
	PR_ORIGINAL_SENDER_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0066), /* PidTagOriginalSenderAddressType */
	PR_ORIGINAL_SENDER_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x0067), /* PidTagOriginalSenderEmailAddress */
	PR_ORIGINAL_SENT_REPRESENTING_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0068), /* PidTagOriginalSentRepresentingAddressType */
	PR_ORIGINAL_SENT_REPRESENTING_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x0069), /* PidTagOriginalSentRepresentingEmailAddress */
	PR_CONVERSATION_TOPIC = PROP_TAG(PT_UNICODE, 0x0070), /* PidTagConversationTopic */
	PR_CONVERSATION_TOPIC_A = PROP_TAG(PT_STRING8, 0x0070),
	PR_CONVERSATION_INDEX = PROP_TAG(PT_BINARY, 0x0071), /* PidTagConversationIndex */
	PR_ORIGINAL_DISPLAY_BCC = PROP_TAG(PT_UNICODE, 0x0072), /* PidTagOriginalDisplayBcc */
	PR_ORIGINAL_DISPLAY_CC = PROP_TAG(PT_UNICODE, 0x0073), /* PidTagOriginalDisplayCc */
	PR_ORIGINAL_DISPLAY_TO = PROP_TAG(PT_UNICODE, 0x0074), /* PidTagOriginalDisplayTo */
	PR_RECEIVED_BY_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0075), /* PidTagReceivedByAddressType */
	PR_RECEIVED_BY_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x0076), /* PidTagReceivedByEmailAddress */
	PR_RCVD_REPRESENTING_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0077), /* PidTagReceivedRepresentingAddressType */
	PR_RCVD_REPRESENTING_ADDRTYPE_A = PROP_TAG(PT_STRING8, 0x0077),
	PR_RCVD_REPRESENTING_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x0078), /* PidTagReceivedRepresentingEmailAddress */
	PR_RCVD_REPRESENTING_EMAIL_ADDRESS_A = PROP_TAG(PT_STRING8, 0x0078),
	PR_ORIGINAL_AUTHOR_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0079), /* PidTagOriginalAuthorAddressType */
	PR_ORIGINAL_AUTHOR_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x007A), /* PidTagOriginalAuthorEmailAddress */
	PR_ORIGINALLY_INTENDED_RECIP_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x007B), /* PidTagOriginallyIntendedRecipAddrtype */
	PR_ORIGINALLY_INTENDED_RECIP_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x007C), /* PidTagOriginallyIntendedRecipEmailAddress */
	PR_TRANSPORT_MESSAGE_HEADERS = PROP_TAG(PT_UNICODE, 0x007D), /* PidTagTransportMessageHeaders */
	PR_TRANSPORT_MESSAGE_HEADERS_A = PROP_TAG(PT_STRING8, 0x007D),
	// PR_DELEGATION = PROP_TAG(PT_BINARY, 0x007E),
	PR_TNEF_CORRELATION_KEY = PROP_TAG(PT_BINARY, 0x007F), /* PidTagTnefCorrelationKey */
	// PR_REPORT_DISPOSITION = PROP_TAG(PT_UNICODE, 0x0080), /* PidTagReportDisposition */
	// PR_REPORT_DISPOSITION_MODE = PROP_TAG(PT_UNICODE, 0x0081), /* PidTagReportDispositionMode */
	PR_EMS_AB_ROOM_CAPACITY = PROP_TAG(PT_LONG, 0x0807), /* PidTagAddressBookRoomCapacity */
	// PR_EMS_AB_ROOM_DESCRIPTION = PROP_TAG(PT_UNICODE, 0x0809), /* PidTagAddressBookRoomDescription */
	// PR_CONTENT_INTEGRITY_CHECK = PROP_TAG(PT_BINARY, 0x0C00), /* PidTagContentIntegrityCheck */
	// PR_EXPLICIT_CONVERSION = PROP_TAG(PT_LONG, 0x0C01), /* PidTagExplicitConversion */
	// PR_IPM_RETURN_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0C02), /* PidTagIpmReturnRequested */
	// PR_MESSAGE_TOKEN = PROP_TAG(PT_BINARY, 0x0C03),
	PR_NDR_REASON_CODE = PROP_TAG(PT_LONG, 0x0C04), /* PidTagNonDeliveryReportReasonCode */
	PR_NDR_DIAG_CODE = PROP_TAG(PT_LONG, 0x0C05), /* PidTagNonDeliveryReportDiagCode */
	PR_NON_RECEIPT_NOTIFICATION_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0C06), /* PidTagNonReceiptNotificationRequested */
	// PR_DELIVERY_POINT = PROP_TAG(PT_LONG, 0x0C07), /* PidTagDeliveryPoint */
	// PR_ORIGINATOR_NON_DELIVERY_REPORT_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0C08), /* PidTagOriginatorNonDeliveryReportRequested */
	// PR_ORIGINATOR_REQUESTED_ALTERNATE_RECIPIENT = PROP_TAG(PT_BINARY, 0x0C09), /* PidTagOriginatorRequestedAlternateRecipient */
	// PR_PHYSICAL_DELIVERY_BUREAU_FAX_DELIVERY = PROP_TAG(PT_BOOLEAN, 0x0C0A), /* PidTagPhysicalDeliveryBureauFaxDelivery */
	// PR_PHYSICAL_DELIVERY_MODE = PROP_TAG(PT_LONG, 0x0C0B), /* PidTagPhysicalDeliveryMode */
	// PR_PHYSICAL_DELIVERY_REPORT_REQUEST = PROP_TAG(PT_LONG, 0x0C0C), /* PidTagPhysicalDeliveryReportRequest */
	// PR_PHYSICAL_FORWARDING_ADDRESS = PROP_TAG(PT_BINARY, 0x0C0D), /* PidTagPhysicalForwardingAddress */
	// PR_PHYSICAL_FORWARDING_ADDRESS_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0C0E), /* PidTagPhysicalForwardingAddressRequested */
	// PR_PHYSICAL_FORWARDING_PROHIBITED = PROP_TAG(PT_BOOLEAN, 0x0C0F), /* PidTagPhysicalForwardingProhibited */
	// PR_PHYSICAL_RENDITION_ATTRIBUTES = PROP_TAG(PT_BINARY, 0x0C10), /* PidTagPhysicalRenditionAttributes */
	// PR_PROOF_OF_DELIVERY = PROP_TAG(PT_BINARY, 0x0C11), /* PidTagProofOfDelivery */
	// PR_PROOF_OF_DELIVERY_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0C12), /* PidTagProofOfDeliveryRequested */
	// PR_RECIPIENT_CERTIFICATE = PROP_TAG(PT_BINARY, 0x0C13), /* PidTagRecipientCertificate */
	// PR_RECIPIENT_NUMBER_FOR_ADVICE = PROP_TAG(PT_UNICODE, 0x0C14), /* PidTagRecipientNumberForAdvice */
	PR_RECIPIENT_TYPE = PROP_TAG(PT_LONG, 0x0C15), /* PidTagRecipientType */
	// PR_REGISTERED_MAIL_TYPE = PROP_TAG(PT_LONG, 0x0C16), /* PidTagRegisteredMailType */
	PR_REPLY_REQUESTED = PROP_TAG(PT_BOOLEAN, 0x0C17), /* PidTagReplyRequested */
	// PR_REQUESTED_DELIVERY_METHOD = PROP_TAG(PT_LONG, 0x0C18), /* PidTagRequestedDeliveryMethod */
	PR_SENDER_ENTRYID = PROP_TAG(PT_BINARY, 0x0C19), /* PidTagSenderEntryId */
	PR_SENDER_NAME = PROP_TAG(PT_UNICODE, 0x0C1A), /* PidTagSenderName */
	PR_SENDER_NAME_A = PROP_TAG(PT_STRING8, 0x0C1A),
	PR_SUPPLEMENTARY_INFO = PROP_TAG(PT_UNICODE, 0x0C1B), /* PidTagSupplementaryInfo */
	// PR_TYPE_OF_MTS_USER = PROP_TAG(PT_LONG, 0x0C1C), /* PidTagTypeOfX400User */
	PR_SENDER_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x0C1D), /* PidTagSenderSearchKey */
	PR_SENDER_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x0C1E), /* PidTagSenderAddressType */
	PR_SENDER_ADDRTYPE_A = PROP_TAG(PT_STRING8, 0x0C1E),
	PR_SENDER_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x0C1F), /* PidTagSenderEmailAddress */
	PR_SENDER_EMAIL_ADDRESS_A = PROP_TAG(PT_STRING8, 0x0C1F),
	PR_NDR_STATUS_CODE = PROP_TAG(PT_LONG, 0x0C20), /* PidTagNonDeliveryReportStatusCode */
	PR_DSN_REMOTE_MTA = PROP_TAG(PT_UNICODE, 0x0C21), /* PidTagRemoteMessageTransferAgent */
	// PR_CURRENT_VERSION = PROP_TAG(PT_I8, 0x0E00),
	PR_DELETE_AFTER_SUBMIT = PROP_TAG(PT_BOOLEAN, 0x0E01), /* PidTagDeleteAfterSubmit */
	PR_DISPLAY_BCC = PROP_TAG(PT_UNICODE, 0x0E02), /* PidTagDisplayBcc */
	PR_DISPLAY_BCC_A = PROP_TAG(PT_STRING8, 0x0E02),
	PR_DISPLAY_CC = PROP_TAG(PT_UNICODE, 0x0E03), /* PidTagDisplayCc */
	PR_DISPLAY_CC_A = PROP_TAG(PT_STRING8, 0x0E03),
	PR_DISPLAY_TO = PROP_TAG(PT_UNICODE, 0x0E04), /* PidTagDisplayTo */
	PR_DISPLAY_TO_A = PROP_TAG(PT_STRING8, 0x0E04),
	PR_PARENT_DISPLAY = PROP_TAG(PT_UNICODE, 0x0E05), /* PidTagParentDisplay */
	PR_PARENT_DISPLAY_A = PROP_TAG(PT_STRING8, 0x0E05),
	PR_MESSAGE_DELIVERY_TIME = PROP_TAG(PT_SYSTIME, 0x0E06), /* PidTagMessageDeliveryTime */
	PR_MESSAGE_FLAGS = PROP_TAG(PT_LONG, 0x0E07), /* PidTagMessageFlags */
	PR_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x0E08), /* PidTagMessageSize */
	PR_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x0E08), /* PidTagMessageSizeExtended */
	PR_PARENT_ENTRYID = PROP_TAG(PT_BINARY, 0x0E09), /* PidTagParentEntryId */
	PR_PARENT_SVREID = PROP_TAG(PT_SVREID, 0x0E09),
	PR_SENTMAIL_ENTRYID = PROP_TAG(PT_BINARY, 0x0E0A), /* PidTagSentMailEntryId */
	// PR_CORRELATE = PROP_TAG(PT_BOOLEAN, 0x0E0C), /* PidTagCorrelate */
	// PR_CORRELATE_MTSID = PROP_TAG(PT_BINARY, 0x0E0D), /* PidTagCorrelateMtsid */
	// PR_DISCRETE_VALUES = PROP_TAG(PT_BOOLEAN, 0x0E0E), /* PidTagDiscreteValues */
	PR_RESPONSIBILITY = PROP_TAG(PT_BOOLEAN, 0x0E0F), /* PidTagResponsibility */
	// PR_SPOOLER_STATUS = PROP_TAG(PT_LONG, 0x0E10), /* PidTagSpoolerStatus */
	// PR_TRANSPORT_STATUS = PROP_TAG(PT_LONG, 0x0E11),
	PR_MESSAGE_RECIPIENTS = PROP_TAG(PT_OBJECT, 0x0E12), /* PidTagMessageRecipients */
	PR_MESSAGE_ATTACHMENTS = PROP_TAG(PT_OBJECT, 0x0E13), /* PidTagMessageAttachments */
	// PR_SUBMIT_FLAGS = PROP_TAG(PT_LONG, 0x0E14), /* PidTagSubmitFlags */
	// PR_RECIPIENT_STATUS = PROP_TAG(PT_LONG, 0x0E15), /* PidTagRecipientStatus */
	// PR_TRANSPORT_KEY = PROP_TAG(PT_LONG, 0x0E16), /* PidTagTransportKey */
	PR_MSG_STATUS = PROP_TAG(PT_LONG, 0x0E17), /* PidTagMessageStatus */
	// PR_MESSAGE_DOWNLOAD_TIME = PROP_TAG(PT_LONG, 0x0E18), /* PidTagMessageDownloadTime */
	// PR_CREATION_VERSION = PROP_TAG(PT_I8, 0x0E19),
	// PR_MODIFY_VERSION = PROP_TAG(PT_I8, 0x0E1A),
	PR_HASATTACH = PROP_TAG(PT_BOOLEAN, 0x0E1B), /* PidTagHasAttachments */
	// PR_BODY_CRC = PROP_TAG(PT_LONG, 0x0E1C), /* PidTagBodyCrc */
	PR_NORMALIZED_SUBJECT = PROP_TAG(PT_UNICODE, 0x0E1D), /* PidTagNormalizedSubject */
	PR_NORMALIZED_SUBJECT_A = PROP_TAG(PT_STRING8, 0x0E1D),
	PR_RTF_IN_SYNC = PROP_TAG(PT_BOOLEAN, 0x0E1F), /* PidTagRtfInSync */
	PR_ATTACH_SIZE = PROP_TAG(PT_LONG, 0x0E20), /* PidTagAttachSize */
	PR_ATTACH_NUM = PROP_TAG(PT_LONG, 0x0E21), /* PidTagAttachNumber */
	// PR_PREPROCESS = PROP_TAG(PT_BOOLEAN, 0x0E22), /* PidTagPreprocess */
	PR_INTERNET_ARTICLE_NUMBER = PROP_TAG(PT_LONG, 0x0E23), /* PidTagInternetArticleNumber */
	PidTagMidString = PROP_TAG(PT_UNICODE, 0x0E23),
	// PR_NEWSGROUP_NAME = PROP_TAG(PT_UNICODE, 0x0E24),
	// PR_ORIGINATING_MTA_CERTIFICATE = PROP_TAG(PT_BINARY, 0x0E25), /* PidTagOriginatingMtaCertificate */
	// PR_PROOF_OF_SUBMISSION = PROP_TAG(PT_BINARY, 0x0E26), /* PidTagProofOfSubmission */
	// PR_NT_SECURITY_DESCRIPTOR = PROP_TAG(PT_BINARY, 0x0E27),
	// PR_PRIMARY_SEND_ACCOUNT = PROP_TAG(PT_UNICODE, 0x0E28), /* PidTagPrimarySendAccount */
	// PR_NEXT_SEND_ACCT = PROP_TAG(PT_UNICODE, 0x0E29), /* PidTagNextSendAcct */
	PR_TODO_ITEM_FLAGS = PROP_TAG(PT_LONG, 0x0E2B), /* PidTagToDoItemFlags */
	// PR_SWAPPED_TODO_STORE = PROP_TAG(PT_BINARY, 0x0E2C), /* PidTagSwappedToDoStore */
	// PR_SWAPPED_TODO_DATA = PROP_TAG(PT_BINARY, 0x0E2D), /* PidTagSwappedToDoData */
	// PR_REPL_ITEMID = PROP_TAG(PT_LONG, 0x0E30), /* PidTagReplItemId */
	// PR_REPL_CHANGENUM = PROP_TAG(PT_I8, 0x0E33), /* PidTagReplChangenum */
	// PR_REPL_VERSIONHISTORY = PROP_TAG(PT_BINARY, 0x0E34), /* PidTagReplVersionhistory */
	// PR_REPL_FLAGS = PROP_TAG(PT_LONG, 0x0E38), /* PidTagReplFlags */
	// PR_REPL_COPIEDFROM_VERSIONHISTORY = PROP_TAG(PT_BINARY, 0x0E3C), /* PidTagReplCopiedfromVersionhistory */
	// PR_REPL_COPIEDFROM_ITEMID = PROP_TAG(PT_BINARY, 0x0E3D), /* PidTagReplCopiedfromItemid */
	PR_CREATOR_SID = PROP_TAG(PT_BINARY, 0x0E58),
	PR_LAST_MODIFIER_SID = PROP_TAG(PT_BINARY, 0x0E59),
	PR_CI_SEARCH_ENABLED = PROP_TAG(PT_BOOLEAN, 0x0E5C),
	PR_READ = PROP_TAG(PT_BOOLEAN, 0x0E69), /* PidTagRead */
	PR_NT_SECURITY_DESCRIPTOR_AS_XML = PROP_TAG(PT_UNICODE, 0x0E6A), /* PidTagSecurityDescriptorAsXml */
	PR_TRUST_SENDER = PROP_TAG(PT_LONG, 0x0E79), /* PidTagTrustSender */
	// PidTagExchangeNTSecurityDescriptor = PROP_TAG(PT_BINARY, 0x0E84),
	PR_EXTENDED_RULE_MSG_ACTIONS = PROP_TAG(PT_BINARY, 0x0E99), /* PidTagExtendedRuleMessageActions */
	PR_EXTENDED_RULE_MSG_CONDITION = PROP_TAG(PT_BINARY, 0x0E9A), /* PidTagExtendedRuleMessageCondition */
	PR_EXTENDED_RULE_SIZE_LIMIT = PROP_TAG(PT_LONG, 0x0E9B), /* PidTagExtendedRuleSizeLimit */
	// PR_ASSOCIATED_SHARING_PROVIDER = PROP_TAG(PT_CLSID, 0x0EA0), /* PidTagAssociatedSharingProvider */
	// PR_SEARCH_ATTACHMENTS = PROP_TAG(PT_UNICODE, 0x0EA5), /* PidTagSearchAttachments */
	// PR_SEARCH_RECIP_EMAIL_TO = PROP_TAG(PT_UNICODE, 0x0EA6), /* PidTagSearchRecipientEmailTo */
	// PR_SEARCH_RECIP_EMAIL_CC = PROP_TAG(PT_UNICODE, 0x0EA7), /* PidTagSearchRecipientEmailCc */
	// PR_SEARCH_RECIP_EMAIL_BCC = PROP_TAG(PT_UNICODE, 0x0EA8), /* PidTagSearchRecipientEmailBcc */
	PR_ACCESS = PROP_TAG(PT_LONG, 0x0FF4), /* PidTagAccess */
	PR_ROW_TYPE = PROP_TAG(PT_LONG, 0x0FF5), /* PidTagRowType */
	PR_INSTANCE_KEY = PROP_TAG(PT_BINARY, 0x0FF6), /* PidTagInstanceKey */
	PR_INSTANCE_SVREID = PROP_TAG(PT_SVREID, 0x0FF6),
	PR_ACCESS_LEVEL = PROP_TAG(PT_LONG, 0x0FF7), /* PidTagAccessLevel */
	PR_MAPPING_SIGNATURE = PROP_TAG(PT_BINARY, 0x0FF8), /* PidTagMappingSignature */
	PR_RECORD_KEY = PROP_TAG(PT_BINARY, 0x0FF9), /* PidTagRecordKey */
	PR_STORE_RECORD_KEY = PROP_TAG(PT_BINARY, 0x0FFA), /* PidTagStoreRecordKey */
	PR_STORE_ENTRYID = PROP_TAG(PT_BINARY, 0x0FFB), /* PidTagStoreEntryId */
	// PR_MINI_ICON = PROP_TAG(PT_BINARY, 0x0FFC), /* PidTagMiniIcon */
	// PR_ICON = PROP_TAG(PT_BINARY, 0x0FFD), /* PidTagIcon */
	PR_OBJECT_TYPE = PROP_TAG(PT_LONG, 0x0FFE), /* PidTagObjectType */
	PR_ENTRYID = PROP_TAG(PT_BINARY, 0x0FFF), /* PidTagEntryId */
	PR_BODY = PROP_TAG(PT_UNICODE, 0x1000), /* PidTagBody */
	PR_BODY_A = PROP_TAG(PT_STRING8, 0x1000),
	PR_BODY_W = PROP_TAG(PT_UNICODE, 0x1000),
	PR_REPORT_TEXT = PROP_TAG(PT_UNICODE, 0x1001), /* PidTagReportText */
	// PR_ORIGINATOR_AND_DL_EXPANSION_HISTORY = PROP_TAG(PT_BINARY, 0x1002), /* PidTagOriginatorAndDistributionListExpansionHistory */
	// PR_REPORTING_DL_NAME = PROP_TAG(PT_BINARY, 0x1003), /* PidTagReportingDistributionListName */
	// PR_REPORTING_MTA_CERTIFICATE = PROP_TAG(PT_BINARY, 0x1004), /* PidTagReportingMessageTransferAgentCertificate */
	// PR_RTF_SYNC_BODY_CRC = PROP_TAG(PT_LONG, 0x1006), /* PidTagRtfSyncBodyCrc */
	// PR_RTF_SYNC_BODY_COUNT = PROP_TAG(PT_LONG, 0x1007), /* PidTagRtfSyncBodyCount */
	// PR_RTF_SYNC_BODY_TAG = PROP_TAG(PT_UNICODE, 0x1008), /* PidTagRtfSyncBodyTag */
	PR_RTF_COMPRESSED = PROP_TAG(PT_BINARY, 0x1009), /* PidTagRtfCompressed */
	// PR_RTF_SYNC_PREFIX_COUNT = PROP_TAG(PT_LONG, 0x1010), /* PidTagRtfSyncPrefixCount */
	// PR_RTF_SYNC_TRAILING_COUNT = PROP_TAG(PT_LONG, 0x1011), /* PidTagRtfSyncTrailingCount */
	// PR_ORIGINALLY_INTENDED_RECIP_ENTRYID = PROP_TAG(PT_BINARY, 0x1012), /* PidTagOriginallyIntendedRecipEntryId */
	PR_BODY_HTML = PROP_TAG(PT_UNICODE, 0x1013), /* PidTagBodyHtml */
	PR_BODY_HTML_A = PROP_TAG(PT_STRING8, 0x1013),
	PR_HTML = PROP_TAG(PT_BINARY, 0x1013), /* PidTagHtml */
	PR_BODY_CONTENT_LOCATION = PROP_TAG(PT_UNICODE, 0x1014), /* PidTagBodyContentLocation */
	PR_BODY_CONTENT_LOCATION_A = PROP_TAG(PT_STRING8, 0x1014),
	PR_BODY_CONTENT_ID = PROP_TAG(PT_UNICODE, 0x1015), /* PidTagBodyContentId */
	PR_BODY_CONTENT_ID_A = PROP_TAG(PT_STRING8, 0x1015),
	PR_NATIVE_BODY_INFO = PROP_TAG(PT_LONG, 0x1016), /* PidTagNativeBody */
	// PR_INTERNET_APPROVED = PROP_TAG(PT_UNICODE, 0x1030), /* PidTagInternetApproved */
	// PR_INTERNET_CONTROL = PROP_TAG(PT_UNICODE, 0x1031), /* PidTagInternetControl */
	// PR_INTERNET_DISTRIBUTION = PROP_TAG(PT_UNICODE, 0x1032), /* PidTagInternetDistribution */
	// PR_INTERNET_FOLLOWUP_TO = PROP_TAG(PT_UNICODE, 0x1033), /* PidTagInternetFollowupTo */
	// PR_INTERNET_LINES = PROP_TAG(PT_LONG, 0x1034), /* PidTagInternetLines */
	PR_INTERNET_MESSAGE_ID = PROP_TAG(PT_UNICODE, 0x1035), /* PidTagInternetMessageId */
	PR_INTERNET_MESSAGE_ID_A = PROP_TAG(PT_STRING8, 0x1035),
	// PR_INTERNET_NEWSGROUPS = PROP_TAG(PT_UNICODE, 0x1036),
	// PR_INTERNET_ORGANIZATION = PROP_TAG(PT_UNICODE, 0x1037), /* PidTagInternetOrganization */
	// PR_INTERNET_NNTP_PATH = PROP_TAG(PT_UNICODE, 0x1038), /* PidTagInternetNntpPath */
	PR_INTERNET_REFERENCES = PROP_TAG(PT_UNICODE, 0x1039), /* PidTagInternetReferences */
	PR_INTERNET_REFERENCES_A = PROP_TAG(PT_STRING8, 0x1039),
	// PR_SUPERSEDES = PROP_TAG(PT_UNICODE, 0x103A),
	// PR_POST_FOLDER_ENTRIES = PROP_TAG(PT_BINARY, 0x103B),
	// PR_POST_FOLDER_NAMES = PROP_TAG(PT_UNICODE, 0x103C),
	// PR_POST_REPLY_FOLDER_ENTRIES = PROP_TAG(PT_BINARY, 0x103D),
	// PR_POST_REPLY_FOLDER_NAMES = PROP_TAG(PT_UNICODE, 0x103E),
	// PR_POST_REPLY_DENIED = PROP_TAG(PT_BINARY, 0x103F),
	// PR_NNTP_XREF = PROP_TAG(PT_UNICODE, 0x1040),
	PR_INTERNET_PRECEDENCE = PROP_TAG(PT_UNICODE, 0x1041),
	PR_IN_REPLY_TO_ID = PROP_TAG(PT_UNICODE, 0x1042), /* PidTagInReplyToId */
	PR_IN_REPLY_TO_ID_A = PROP_TAG(PT_STRING8, 0x1042),
	PR_LIST_HELP = PROP_TAG(PT_UNICODE, 0x1043), /* PidTagListHelp */
	PR_LIST_HELP_A = PROP_TAG(PT_STRING8, 0x1043),
	PR_LIST_SUBSCRIBE = PROP_TAG(PT_UNICODE, 0x1044), /* PidTagListSubscribe */
	PR_LIST_SUBSCRIBE_A = PROP_TAG(PT_STRING8, 0x1044),
	PR_LIST_UNSUBSCRIBE = PROP_TAG(PT_UNICODE, 0x1045), /* PidTagListUnsubscribe */
	PR_LIST_UNSUBSCRIBE_A = PROP_TAG(PT_STRING8, 0x1045),
	PidTagOriginalMessageId = PROP_TAG(PT_UNICODE, 0x1046),
	// PR_INTERNET_RETURN_PATH = PROP_TAG(PT_UNICODE, 0x1046), /* PidTagInternetReturnPath */
	PR_ICON_INDEX = PROP_TAG(PT_LONG, 0x1080), /* PidTagIconIndex */
	// PR_LAST_VERB_EXECUTED = PROP_TAG(PT_LONG, 0x1081), /* PidTagLastVerbExecuted */
	// PR_LAST_VERB_EXECUTION_TIME = PROP_TAG(PT_SYSTIME, 0x1082), /* PidTagLastVerbExecutionTime */
	PR_FLAG_STATUS = PROP_TAG(PT_LONG, 0x1090), /* PidTagFlagStatus */
	PR_FLAG_COMPLETE_TIME = PROP_TAG(PT_SYSTIME, 0x1091), /* PidTagFlagCompleteTime */
	PR_FOLLOWUP_ICON = PROP_TAG(PT_LONG, 0x1095), /* PidTagFollowupIcon */
	// PR_BLOCK_STATUS = PROP_TAG(PT_LONG, 0x1096), /* PidTagBlockStatus */
	// PR_ITEM_TMPFLAGS = PROP_TAG(PT_LONG, 0x1097), /* PidTagItemTemporaryflags */
	// PR_CONFLICT_ITEMS = PROP_TAG(PT_MV_BINARY, 0x1098), /* PidTagConflictItems */
	// PidTagICalendarStartTime = PROP_TAG(PT_SYSTIME, 0x10C3),
	// PidTagICalendarEndTime = PROP_TAG(PT_SYSTIME, 0x10C4),
	// PR_CDO_RECURRENCEID = PROP_TAG(PT_SYSTIME, 0x10C5), /* PidTagCdoRecurrenceid */
	// PidTagICalendarReminderNextTime = PROP_TAG(PT_SYSTIME, 0x10CA),
	PR_ATTR_HIDDEN = PROP_TAG(PT_BOOLEAN, 0x10F4), /* PidTagAttributeHidden */
	PR_ATTR_HIDDEN_GROMOX = PROP_TAG(PT_LONG, 0x10F4),
	PR_ATTR_SYSTEM = PROP_TAG(PT_BOOLEAN, 0x10F5), /* OXPROPS v2.0 §2.659 */
	PR_ATTR_READONLY = PROP_TAG(PT_BOOLEAN, 0x10F6), /* PidTagAttributeReadOnly */
	// ? = PROP_TAG(PT_MV_SHORT, 0x1205),
	// ? = PROP_TAG(PT_BINARY, 0x120D), /* entryid to Calendar\Birthdays folder */
	PR_ROWID = PROP_TAG(PT_LONG, 0x3000), /* PidTagRowid */
	PR_DISPLAY_NAME = PROP_TAG(PT_UNICODE, 0x3001), /* PidTagDisplayName */
	PR_DISPLAY_NAME_A = PROP_TAG(PT_STRING8, 0x3001),
	PR_ADDRTYPE = PROP_TAG(PT_UNICODE, 0x3002), /* PidTagAddressType */
	PR_ADDRTYPE_A = PROP_TAG(PT_STRING8, 0x3002),
	PR_EMAIL_ADDRESS = PROP_TAG(PT_UNICODE, 0x3003), /* PidTagEmailAddress */
	PR_EMAIL_ADDRESS_A = PROP_TAG(PT_STRING8, 0x3003),
	PR_COMMENT = PROP_TAG(PT_UNICODE, 0x3004), /* PidTagComment */
	PR_DEPTH = PROP_TAG(PT_LONG, 0x3005), /* PidTagDepth */
	PR_PROVIDER_DISPLAY = PROP_TAG(PT_UNICODE, 0x3006), /* PidTagProviderDisplay */
	PR_CREATION_TIME = PROP_TAG(PT_SYSTIME, 0x3007), /* PidTagCreationTime */
	PR_LAST_MODIFICATION_TIME = PROP_TAG(PT_SYSTIME, 0x3008), /* PidTagLastModificationTime */
	PR_RESOURCE_FLAGS = PROP_TAG(PT_LONG, 0x3009), /* PidTagResourceFlags */
	// PR_PROVIDER_DLL_NAME = PROP_TAG(PT_UNICODE, 0x300A), /* PidTagProviderDllName */
	PR_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x300B), /* PidTagSearchKey */
	// PR_PROVIDER_UID = PROP_TAG(PT_BINARY, 0x300C), /* PidTagProviderUid */
	// PR_PROVIDER_ORDINAL = PROP_TAG(PT_LONG, 0x300D), /* PidTagProviderOrdinal */
	PR_TARGET_ENTRYID = PROP_TAG(PT_BINARY, 0x3010), /* PidTagTargetEntryId */
	PR_CONVERSATION_ID = PROP_TAG(PT_BINARY, 0x3013), /* PidTagConversationId */
	PR_CONVERSATION_INDEX_TRACKING = PROP_TAG(PT_BOOLEAN, 0x3016), /* PidTagConversationIndexTracking */
	// PR_ARCHIVE_TAG = PROP_TAG(PT_BINARY, 0x3018), /* PidTagArchiveTag */
	// PR_POLICY_TAG = PROP_TAG(PT_BINARY, 0x3019), /* PidTagPolicyTag */
	// PR_RETENTION_PERIOD = PROP_TAG(PT_LONG, 0x301A), /* PidTagRetentionPeriod */
	// PR_START_DATE_ETC = PROP_TAG(PT_BINARY, 0x301B), /* PidTagStartDateEtc */
	// PR_RETENTION_DATE = PROP_TAG(PT_SYSTIME, 0x301C), /* PidTagRetentionDate */
	// PR_RETENTION_FLAGS = PROP_TAG(PT_LONG, 0x301D), /* PidTagRetentionFlags */
	// PR_ARCHIVE_PERIOD = PROP_TAG(PT_LONG, 0x301E), /* PidTagArchivePeriod */
	// PR_ARCHIVE_DATE = PROP_TAG(PT_SYSTIME, 0x301F), /* PidTagArchiveDate */
	// PR_SORT_POSITION = PROP_TAG(PT_BINARY, 0x3020),
	// PR_SORT_PARENTID = PROP_TAG(PT_BINARY, 0x3021),
	// PR_FORM_VERSION = PROP_TAG(PT_UNICODE, 0x3301), /* PidTagFormVersion */
	// PR_FORM_CLSID = PROP_TAG(PT_CLSID, 0x3302), /* PidTagFormClassId */
	// PR_FORM_CONTACT_NAME = PROP_TAG(PT_UNICODE, 0x3303), /* PidTagFormContactName */
	// PR_FORM_CATEGORY = PROP_TAG(PT_UNICODE, 0x3304), /* PidTagFormCategory */
	// PR_FORM_CATEGORY_SUB = PROP_TAG(PT_UNICODE, 0x3305), /* PidTagFormCategorySub */
	// PR_FORM_HOST_MAP = PROP_TAG(PT_MV_LONG, 0x3306), /* PidTagFormHostMap */
	// PR_FORM_HIDDEN = PROP_TAG(PT_BOOLEAN, 0x3307), /* PidTagFormHidden */
	// PR_FORM_DESIGNER_NAME = PROP_TAG(PT_UNICODE, 0x3308), /* PidTagFormDesignerName */
	// PR_FORM_DESIGNER_GUID = PROP_TAG(PT_CLSID, 0x3309), /* PidTagFormDesignerGuid */
	// PR_FORM_MESSAGE_BEHAVIOR = PROP_TAG(PT_LONG, 0x330A), /* PidTagFormMessageBehavior */
	PR_DEFAULT_STORE = PROP_TAG(PT_BOOLEAN, 0x3400), /* PidTagDefaultStore */
	PR_STORE_SUPPORT_MASK = PROP_TAG(PT_LONG, 0x340D), /* PidTagStoreSupportMask */
	PR_STORE_STATE = PROP_TAG(PT_LONG, 0x340E), /* PidTagStoreState */
	// PR_STORE_UNICODE_MASK = PROP_TAG(PT_LONG, 0x340F), /* PidTagStoreUnicodeMask */
	// PR_IPM_SUBTREE_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x3410),
	// PR_IPM_OUTBOX_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x3411),
	// PR_IPM_WASTEBASKET_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x3412),
	// PR_IPM_SENTMAIL_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x3413),
	PR_MDB_PROVIDER = PROP_TAG(PT_BINARY, 0x3414), /* PidTagStoreProvider */
	// PR_RECEIVE_FOLDER_SETTINGS = PROP_TAG(PT_OBJECT, 0x3415), /* PidTagReceiveFolderSettings */
	// PR_QUOTA_WARNING = PROP_TAG(PT_LONG, 0x3418), /* Cached Mode profile quotas */
	// PR_QUOTA_SEND = PROP_TAG(PT_LONG, 0x3419),
	// PR_QUOTA_RECEIVE = PROP_TAG(PT_LONG, 0x341A),
	PR_ROOT_ENTRYID = PROP_TAG(PT_BINARY, 0x35D8),
	PR_VALID_FOLDER_MASK = PROP_TAG(PT_LONG, 0x35DF), /* PidTagValidFolderMask */
	PR_IPM_SUBTREE_ENTRYID = PROP_TAG(PT_BINARY, 0x35E0), /* PidTagIpmSubtreeEntryId */
	PR_IPM_INBOX_ENTRYID = PROP_TAG(PT_BINARY, 0x35E1),
	PR_IPM_OUTBOX_ENTRYID = PROP_TAG(PT_BINARY, 0x35E2), /* PidTagIpmOutboxEntryId */
	PR_IPM_WASTEBASKET_ENTRYID = PROP_TAG(PT_BINARY, 0x35E3), /* PidTagIpmWastebasketEntryId */
	PR_IPM_SENTMAIL_ENTRYID = PROP_TAG(PT_BINARY, 0x35E4), /* PidTagIpmSentMailEntryId */
	PR_VIEWS_ENTRYID = PROP_TAG(PT_BINARY, 0x35E5), /* PidTagViewsEntryId */
	PR_COMMON_VIEWS_ENTRYID = PROP_TAG(PT_BINARY, 0x35E6), /* PidTagCommonViewsEntryId */
	PR_FINDER_ENTRYID = PROP_TAG(PT_BINARY, 0x35E7), /* PidTagFinderEntryId */
	PidTagXSpoolerQueueEntryId = PROP_TAG(PT_BINARY, 0x35E8),
	// PR_SYNC_ROOT_ENTRYID = PROP_TAG(PT_BINARY, 0x35EA), /* entryid to "exchangeSyncData" folder (EXC2019) */
	// PR_VOICEMAIL_FOLDER_ENTRYID = PROP_TAG(PT_BINARY, 0x35EB),
	// PidTagXAllItemsFolderEntryId = PROP_TAG(PT_BINARY, 0x35EE),
	// PidTagIpmSharingEntryId = PROP_TAG(PT_BINARY, 0x35EF),
	// PidTagAdminDataEntryId = PROP_TAG(PT_BINARY, 0x35FD),
	PR_CONTAINER_FLAGS = PROP_TAG(PT_LONG, 0x3600), /* PidTagContainerFlags */
	PR_FOLDER_TYPE = PROP_TAG(PT_LONG, 0x3601), /* PidTagFolderType */
	PR_CONTENT_COUNT = PROP_TAG(PT_LONG, 0x3602), /* PidTagContentCount */
	PR_CONTENT_UNREAD = PROP_TAG(PT_LONG, 0x3603), /* PidTagContentUnreadCount */
	// PR_CREATE_TEMPLATES = PROP_TAG(PT_OBJECT, 0x3604), /* PidTagCreateTemplates */
	// PR_DETAILS_TABLE  = PROP_TAG(PT_OBJECT, 0x3605), /* PidTagDetailsTable */
	// PR_SEARCH = PROP_TAG(PT_OBJECT, 0x3607), /* PidTagSearch */
	// PR_SELECTABLE = PROP_TAG(PT_BOOLEAN, 0x3609), /* PidTagSelectable */
	PR_SUBFOLDERS = PROP_TAG(PT_BOOLEAN, 0x360A), /* PidTagSubfolders */
	// PR_STATUS = PROP_TAG(PT_LONG, 0x360B), /* PidTagStatus */
	PR_ANR = PROP_TAG(PT_UNICODE, 0x360C), /* PidTagAnr */
	PR_ANR_A = PROP_TAG(PT_STRING8, 0x360C),
	// PR_CONTENTS_SORT_ORDER = PROP_TAG(PT_MV_LONG, 0x360D),
	PR_CONTAINER_HIERARCHY = PROP_TAG(PT_OBJECT, 0x360E), /* PidTagContainerHierarchy */
	PR_CONTAINER_CONTENTS = PROP_TAG(PT_OBJECT, 0x360F), /* PidTagContainerContents */
	PR_FOLDER_ASSOCIATED_CONTENTS = PROP_TAG(PT_OBJECT, 0x3610), /* PidTagFolderAssociatedContents */
	// PR_DEF_CREATE_DL = PROP_TAG(PT_BINARY, 0x3611), /* PidTagDefCreateDl */
	// PR_DEF_CREATE_MAILUSER = PROP_TAG(PT_BINARY, 0x3612), /* PidTagDefCreateMailuser */
	PR_CONTAINER_CLASS = PROP_TAG(PT_UNICODE, 0x3613), /* PidTagContainerClass */
	// PR_CONTAINER_MODIFY_VERSION = PROP_TAG(PT_I8, 0x3614),
	PR_AB_PROVIDER_ID = PROP_TAG(PT_BINARY, 0x3615), /* PidTagAbProviderId */
	PR_DEFAULT_VIEW_ENTRYID = PROP_TAG(PT_BINARY, 0x3616), /* PidTagDefaultViewEntryId */
	PR_ASSOC_CONTENT_COUNT = PROP_TAG(PT_LONG, 0x3617), /* PidTagAssociatedContentCount */
	PR_IPM_APPOINTMENT_ENTRYID = PROP_TAG(PT_BINARY, 0x36D0), /* PidTagIpmAppointmentEntryId */
	PR_IPM_CONTACT_ENTRYID = PROP_TAG(PT_BINARY, 0x36D1), /* PidTagIpmContactEntryId */
	PR_IPM_JOURNAL_ENTRYID = PROP_TAG(PT_BINARY, 0x36D2), /* PidTagIpmJournalEntryId */
	PR_IPM_NOTE_ENTRYID = PROP_TAG(PT_BINARY, 0x36D3), /* PidTagIpmNoteEntryId */
	PR_IPM_TASK_ENTRYID = PROP_TAG(PT_BINARY, 0x36D4), /* PidTagIpmTaskEntryId */
	PR_REM_ONLINE_ENTRYID = PROP_TAG(PT_BINARY, 0x36D5), /* PidTagRemindersOnlineEntryId */
	PR_REM_OFFLINE_ENTRYID = PROP_TAG(PT_BINARY, 0x36D6), /* PidTagRemindersOfflineEntryId */
	PR_IPM_DRAFTS_ENTRYID = PROP_TAG(PT_BINARY, 0x36D7), /* PidTagIpmDraftsEntryId */
	PR_ADDITIONAL_REN_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x36D8), /* PidTagAdditionalRenEntryIds */
	PR_ADDITIONAL_REN_ENTRYIDS_EX = PROP_TAG(PT_BINARY, 0x36D9), /* PidTagAdditionalRenEntryIdsEx */
	PR_EXTENDED_FOLDER_FLAGS = PROP_TAG(PT_BINARY, 0x36DA), /* PidTagExtendedFolderFlags */
	// PR_NET_FOLDER_FLAGS = PROP_TAG(PT_LONG, 0x36DE),
	// PR_FOLDER_WEBVIEWINFO = PROP_TAG(PT_BINARY, 0x36DF), /* PidTagFolderWebViewInfo */
	// PR_FOLDER_XVIEWINFO_E = PROP_TAG(PT_BINARY, 0x36E0),
	// PR_FOLDER_VIEWS_ONLY = PROP_TAG(PT_LONG, 0x36E1),
	// PR_ORDINAL_MOST = PROP_TAG(PT_LONG, 0x36E2), /* PidTagOrdinalMost */
	PR_FREEBUSY_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x36E4), /* PidTagFreeBusyEntryIds */
	PR_DEF_POST_MSGCLASS = PROP_TAG(PT_UNICODE, 0x36E5), /* PidTagDefaultPostMessageClass */
	// PR_DEF_POST_DISPLAYNAME = PROP_TAG(PT_UNICODE, 0x36E6),
	// PR_GENERATE_EXCHANGE_VIEWS = PROP_TAG(PT_BOOLEAN, 0x36E9), /* PidTagGenerateExchangeViews */
	// PR_ATTACHMENT_X400_PARAMETERS = PROP_TAG(PT_BINARY, 0x3700),
	PR_ATTACH_DATA_BIN = PROP_TAG(PT_BINARY, 0x3701), /* PidTagAttachDataBinary */
	PR_ATTACH_DATA_OBJ = PROP_TAG(PT_OBJECT, 0x3701), /* PidTagAttachDataObject */
	PR_ATTACH_ENCODING = PROP_TAG(PT_BINARY, 0x3702), /* PidTagAttachEncoding */
	PR_ATTACH_EXTENSION = PROP_TAG(PT_UNICODE, 0x3703), /* PidTagAttachExtension */
	PR_ATTACH_EXTENSION_A = PROP_TAG(PT_STRING8, 0x3703),
	PR_ATTACH_FILENAME = PROP_TAG(PT_UNICODE, 0x3704), /* PidTagAttachFilename (8.3 format) */
	PR_ATTACH_FILENAME_A = PROP_TAG(PT_STRING8, 0x3704),
	PR_ATTACH_METHOD = PROP_TAG(PT_LONG, 0x3705), /* PidTagAttachMethod */
	PR_ATTACH_LONG_FILENAME = PROP_TAG(PT_UNICODE, 0x3707), /* PidTagAttachLongFilename */
	PR_ATTACH_LONG_FILENAME_A = PROP_TAG(PT_STRING8, 0x3707),
	// PR_ATTACH_PATHNAME = PROP_TAG(PT_UNICODE, 0x3708), /* PidTagAttachPathname */
	PR_ATTACH_RENDERING = PROP_TAG(PT_BINARY, 0x3709), /* PidTagAttachRendering */
	PR_ATTACH_TAG = PROP_TAG(PT_BINARY, 0x370A), /* PidTagAttachTag */
	PR_RENDERING_POSITION = PROP_TAG(PT_LONG, 0x370B), /* PidTagRenderingPosition */
	PR_ATTACH_TRANSPORT_NAME_A = PROP_TAG(PT_STRING8, 0x370C),
	// PR_ATTACH_TRANSPORT_NAME = PROP_TAG(PT_UNICODE, 0x370C), /* PidTagAttachTransportName */
	// PR_ATTACH_LONG_PATHNAME = PROP_TAG(PT_UNICODE, 0x370D), /* PidTagAttachLongPathname */
	PR_ATTACH_MIME_TAG = PROP_TAG(PT_UNICODE, 0x370E), /* PidTagAttachMimeTag */
	PR_ATTACH_ADDITIONAL_INFO = PROP_TAG(PT_BINARY, 0x370F), /* PidTagAttachAdditionalInformation */
	PR_ATTACH_CONTENT_BASE = PROP_TAG(PT_UNICODE, 0x3711), /* PidTagAttachContentBase */
	PR_ATTACH_CONTENT_BASE_A = PROP_TAG(PT_STRING8, 0x3711),
	PR_ATTACH_CONTENT_ID = PROP_TAG(PT_UNICODE, 0x3712), /* PidTagAttachContentId */
	PR_ATTACH_CONTENT_ID_A = PROP_TAG(PT_STRING8, 0x3712),
	PR_ATTACH_CONTENT_LOCATION = PROP_TAG(PT_UNICODE, 0x3713), /* PidTagAttachContentLocation */
	PR_ATTACH_CONTENT_LOCATION_A = PROP_TAG(PT_STRING8, 0x3713),
	PR_ATTACH_FLAGS = PROP_TAG(PT_LONG, 0x3714), /* PidTagAttachFlags */
	// PR_ATTACH_PAYLOAD_PROV_GUID_STR = PROP_TAG(PT_UNICODE, 0x3719), /* PidTagAttachPayloadProviderGuidString */
	PR_ATTACH_PAYLOAD_CLASS = PROP_TAG(PT_UNICODE, 0x371A), /* PidTagAttachPayloadClass */
	PR_ATTACH_PAYLOAD_CLASS_A = PROP_TAG(PT_STRING8, 0x371A),
	PidTagTextAttachmentCharset = PROP_TAG(PT_UNICODE, 0x371B),
	PidTagTextAttachmentCharset_A = PROP_TAG(PT_STRING8, 0x371B),
	PR_DISPLAY_TYPE = PROP_TAG(PT_LONG, 0x3900), /* PidTagDisplayType */
	PR_TEMPLATEID = PROP_TAG(PT_BINARY, 0x3902), /* PidTagTemplateid */
	// PR_PRIMARY_CAPABILITY = PROP_TAG(PT_BINARY, 0x3904),
	PR_DISPLAY_TYPE_EX = PROP_TAG(PT_LONG, 0x3905), /* PidTagDisplayTypeEx */
	PR_SMTP_ADDRESS = PROP_TAG(PT_UNICODE, 0x39FE), /* PidTagSmtpAddress */
	PR_SMTP_ADDRESS_A = PROP_TAG(PT_STRING8, 0x39FE),
	PR_EMS_AB_DISPLAY_NAME_PRINTABLE = PROP_TAG(PT_UNICODE, 0x39FF), /* PidTagAddressBookDisplayNamePrintable */
	PR_EMS_AB_DISPLAY_NAME_PRINTABLE_A = PROP_TAG(PT_STRING8, 0x39FF),
	// PR_7BIT_DISPLAY_NAME = PROP_TAG(PT_STRING8, 0x39FF), /* PidTag7BitDisplayName */
	PR_ACCOUNT = PROP_TAG(PT_UNICODE, 0x3A00), /* PidTagAccount */
	PR_ACCOUNT_A = PROP_TAG(PT_STRING8, 0x3A00),
	// PR_ALTERNATE_RECIPIENT = PROP_TAG(PT_BINARY, 0x3A01), /* PidTagAlternateRecipient */
	PR_CALLBACK_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A02), /* PidTagCallbackTelephoneNumber */
	// PR_CONVERSION_PROHIBITED = PROP_TAG(PT_BOOLEAN, 0x3A03), /* PidTagConversionProhibited */
	// PR_DISCLOSE_RECIPIENTS = PROP_TAG(PT_BOOLEAN, 0x3A04),
	PR_GENERATION = PROP_TAG(PT_UNICODE, 0x3A05), /* PidTagGeneration */
	PR_GIVEN_NAME = PROP_TAG(PT_UNICODE, 0x3A06), /* PidTagGivenName */
	// PR_GOVERNMENT_ID_NUMBER = PROP_TAG(PT_UNICODE, 0x3A07), /* PidTagGovernmentIdNumber */
	PR_BUSINESS_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A08), /* PidTagBusinessTelephoneNumber */
	// PR_OFFICE_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A08), /* PR_BUSINESS_TELEPHONE_NUMBER */
	PR_HOME_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A09), /* PidTagHomeTelephoneNumber */
	PR_INITIALS = PROP_TAG(PT_UNICODE, 0x3A0A), /* PidTagInitials */
	// PR_KEYWORD = PROP_TAG(PT_UNICODE, 0x3A0B), /* PidTagKeyword */
	// PR_LANGUAGE = PROP_TAG(PT_UNICODE, 0x3A0C), /* PidTagLanguage */
	// PR_LOCATION = PROP_TAG(PT_UNICODE, 0x3A0D), /* PidTagLocation */
	// PR_MAIL_PERMISSION = PROP_TAG(PT_BOOLEAN, 0x3A0E), /* PidTagMailPermission */
	// PR_MHS_COMMON_NAME = PROP_TAG(PT_UNICODE, 0x3A0F), /* PidTagMessageHandlingSystemCommonName */
	// PR_ORGANIZATIONAL_ID_NUMBER = PROP_TAG(PT_UNICODE, 0x3A10), /* PidTagOrganizationalIdNumber */
	PR_SURNAME = PROP_TAG(PT_UNICODE, 0x3A11), /* PidTagSurname */
	PR_ORIGINAL_ENTRYID = PROP_TAG(PT_BINARY, 0x3A12), /* PidTagOriginalEntryId */
	// PR_ORIGINAL_DISPLAY_NAME = PROP_TAG(PT_UNICODE, 0x3A13), /* PidTagOriginalDisplayName */
	// PR_ORIGINAL_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x3A14), /* PidTagOriginalSearchKey */
	// PR_POSTAL_ADDRESS = PROP_TAG(PT_UNICODE, 0x3A15), /* PidTagPostalAddress */
	PR_COMPANY_NAME = PROP_TAG(PT_UNICODE, 0x3A16), /* PidTagCompanyName */
	PR_COMPANY_NAME_A = PROP_TAG(PT_STRING8, 0x3A16),
	PR_TITLE = PROP_TAG(PT_UNICODE, 0x3A17), /* PidTagTitle */
	PR_DEPARTMENT_NAME = PROP_TAG(PT_UNICODE, 0x3A18), /* PidTagDepartmentName */
	PR_DEPARTMENT_NAME_A = PROP_TAG(PT_STRING8, 0x3A18),
	PR_OFFICE_LOCATION = PROP_TAG(PT_UNICODE, 0x3A19), /* PidTagOfficeLocation */
	PR_OFFICE_LOCATION_A = PROP_TAG(PT_STRING8, 0x3A19),
	PR_PRIMARY_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1A), /* PidTagPrimaryTelephoneNumber */
	PR_PRIMARY_TELEPHONE_NUMBER_A = PROP_TAG(PT_STRING8, 0x3A1A),
	PR_BUSINESS2_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1B), /* PidTagBusiness2TelephoneNumber */
	// PR_BUSINESS2_TELEPHONE_NUMBER_MV = PROP_TAG(PT_MV_UNICODE, 0x3A1B), /* PidTagBusiness2TelephoneNumbers */
	// PR_OFFICE2_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1B), /* PR_BUSINESS2_TELEPHONE_NUMBER */
	PR_MOBILE_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1C), /* PidTagMobileTelephoneNumber */
	// PR_CELLULAR_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1C), /* PR_MOBILE_TELEPHONE_NUMBER */
	PR_RADIO_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1D), /* PidTagRadioTelephoneNumber */
	PR_CAR_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1E), /* PidTagCarTelephoneNumber */
	PR_OTHER_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A1F), /* PidTagOtherTelephoneNumber */
	PR_TRANSMITABLE_DISPLAY_NAME = PROP_TAG(PT_UNICODE, 0x3A20), /* PidTagTransmittableDisplayName */
	PR_TRANSMITABLE_DISPLAY_NAME_A = PROP_TAG(PT_STRING8, 0x3A20), /* carried over spello from OXPROPS */
	PR_BEEPER_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A21),
	PR_PAGER_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A21), /* PidTagPagerTelephoneNumber */
	// PR_USER_CERTIFICATE = PROP_TAG(PT_BINARY, 0x3A22), /* PidTagUserCertificate */
	PR_PRIMARY_FAX_NUMBER = PROP_TAG(PT_UNICODE, 0x3A23), /* PidTagPrimaryFaxNumber */
	PR_BUSINESS_FAX_NUMBER = PROP_TAG(PT_UNICODE, 0x3A24), /* PidTagBusinessFaxNumber */
	PR_HOME_FAX_NUMBER = PROP_TAG(PT_UNICODE, 0x3A25), /* PidTagHomeFaxNumber */
	PR_COUNTRY = PROP_TAG(PT_UNICODE, 0x3A26), /* PidTagCountry */
	// PR_BUSINESS_ADDRESS_COUNTRY = PROP_TAG(PT_UNICODE, 0x3A26), /* PR_COUNTRY */
	PR_LOCALITY = PROP_TAG(PT_UNICODE, 0x3A27), /* PidTagLocality */
	// PR_BUSINESS_ADDRESS_CITY = PROP_TAG(PT_UNICODE, 0x3A27), /* PR_LOCALITY */
	PR_STATE_OR_PROVINCE = PROP_TAG(PT_UNICODE, 0x3A28), /* PidTagStateOrProvince */
	// PR_BUSINESS_ADDRESS_STATE_OR_PROVINCE = PROP_TAG(PT_UNICODE, 0x3A28), /* PR_STATE_OR_PROVINCE */
	PR_STREET_ADDRESS = PROP_TAG(PT_UNICODE, 0x3A29), /* PidTagStreetAddress */
	// PR_BUSINESS_ADDRESS_STREET = PROP_TAG(PT_UNICODE, 0x3A29), /* PR_STREET_ADDRESS */
	PR_POSTAL_CODE = PROP_TAG(PT_UNICODE, 0x3A2A), /* PidTagPostalCode */
	// PR_BUSINESS_ADDRESS_POSTAL_CODE = PROP_TAG(PT_UNICODE, 0x3A2A), /* PR_POSTAL_CODE */
	// PR_POST_OFFICE_BOX = PROP_TAG(PT_UNICODE, 0x3A2B), /* PidTagPostOfficeBox */
	// PR_BUSINESS_ADDRESS_POST_OFFICE_BOX = PROP_TAG(PT_UNICODE, 0x3A2B), /* PR_POST_OFFICE_BOX */
	// PR_TELEX_NUMBER = PROP_TAG(PT_UNICODE, 0x3A2C), /* PidTagTelexNumber */
	PR_ISDN_NUMBER = PROP_TAG(PT_UNICODE, 0x3A2D), /* PidTagIsdnNumber */
	PR_ASSISTANT_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A2E), /* PidTagAssistantTelephoneNumber */
	PR_HOME2_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A2F), /* PidTagHome2TelephoneNumber */
	// PR_HOME2_TELEPHONE_NUMBER_MV = PROP_TAG(PT_MV_UNICODE, 0x3A2F), /* PidTagHome2TelephoneNumbers */
	PR_ASSISTANT = PROP_TAG(PT_UNICODE, 0x3A30), /* PidTagAssistant */
	PR_SEND_RICH_INFO = PROP_TAG(PT_BOOLEAN, 0x3A40), /* PidTagSendRichInfo */
	PR_WEDDING_ANNIVERSARY = PROP_TAG(PT_SYSTIME, 0x3A41), /* PidTagWeddingAnniversary */
	PR_BIRTHDAY = PROP_TAG(PT_SYSTIME, 0x3A42), /* PidTagBirthday */
	PR_HOBBIES = PROP_TAG(PT_UNICODE, 0x3A43), /* PidTagHobbies */
	PR_MIDDLE_NAME = PROP_TAG(PT_UNICODE, 0x3A44), /* PidTagMiddleName */
	PR_DISPLAY_NAME_PREFIX = PROP_TAG(PT_UNICODE, 0x3A45), /* PidTagDisplayNamePrefix */
	PR_PROFESSION = PROP_TAG(PT_UNICODE, 0x3A46), /* PidTagProfession */
	// PR_PREFERRED_BY_NAME = PROP_TAG(PT_UNICODE, 0x3A47), /* PidTagReferredByName */
	PR_SPOUSE_NAME = PROP_TAG(PT_UNICODE, 0x3A48), /* PidTagSpouseName */
	// PR_COMPUTER_NETWORK_NAME = PROP_TAG(PT_UNICODE, 0x3A49), /* PidTagComputerNetworkName */
	// PR_CUSTOMER_ID = PROP_TAG(PT_UNICODE, 0x3A4A), /* PidTagCustomerId */
	PR_TTYTDD_PHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A4B), /* PidTagTtyTddPhoneNumber, PidTagTelecommunicationsDeviceForDeafTelephoneNumber */
	// PR_FTP_SITE = PROP_TAG(PT_UNICODE, 0x3A4C), /* PidTagFtpSite */
	// PR_GENDER = PROP_TAG(PT_SHORT, 0x3A4D), /* PidTagGender */
	PR_MANAGER_NAME = PROP_TAG(PT_UNICODE, 0x3A4E), /* PidTagManagerName */
	PR_NICKNAME = PROP_TAG(PT_UNICODE, 0x3A4F), /* PidTagNickname */
	PR_PERSONAL_HOME_PAGE = PROP_TAG(PT_UNICODE, 0x3A50), /* PidTagPersonalHomePage */
	PR_BUSINESS_HOME_PAGE = PROP_TAG(PT_UNICODE, 0x3A51), /* PidTagBusinessHomePage */
	// PR_CONTACT_VERSION = PROP_TAG(PT_CLSID, 0x3A52), /* PidTagContactVersion */
	// PR_CONTACT_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x3A53),
	// PR_CONTACT_ADDRTYPES = PROP_TAG(PT_MV_UNICODE, 0x3A54), /* PidTagContactAddressTypes */
	// PR_CONTACT_DEFAULT_ADDRESS_INDEX = PROP_TAG(PT_LONG, 0x3A55),
	// PR_CONTACT_EMAIL_ADDRESSES = PROP_TAG(PT_MV_UNICODE, 0x3A56),
	PR_COMPANY_MAIN_PHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x3A57), /* PidTagCompanyMainTelephoneNumber */
	PR_CHILDRENS_NAMES = PROP_TAG(PT_MV_UNICODE, 0x3A58), /* PidTagChildrensNames */
	PR_HOME_ADDRESS_CITY = PROP_TAG(PT_UNICODE, 0x3A59), /* PidTagHomeAddressCity */
	PR_HOME_ADDRESS_COUNTRY = PROP_TAG(PT_UNICODE, 0x3A5A), /* PidTagHomeAddressCountry */
	PR_HOME_ADDRESS_POSTAL_CODE = PROP_TAG(PT_UNICODE, 0x3A5B), /* PidTagHomeAddressPostalCode */
	PR_HOME_ADDRESS_STATE_OR_PROVINCE = PROP_TAG(PT_UNICODE, 0x3A5C), /* PidTagHomeAddressStateOrProvince */
	PR_HOME_ADDRESS_STREET = PROP_TAG(PT_UNICODE, 0x3A5D), /* PidTagHomeAddressStreet */
	PR_HOME_ADDRESS_POST_OFFICE_BOX = PROP_TAG(PT_UNICODE, 0x3A5E), /* PidTagHomeAddressPostOfficeBox */
	PR_OTHER_ADDRESS_CITY = PROP_TAG(PT_UNICODE, 0x3A5F), /* PidTagOtherAddressCity */
	PR_OTHER_ADDRESS_COUNTRY = PROP_TAG(PT_UNICODE, 0x3A60), /* PidTagOtherAddressCountry */
	PR_OTHER_ADDRESS_POSTAL_CODE = PROP_TAG(PT_UNICODE, 0x3A61), /* PidTagOtherAddressPostalCode */
	PR_OTHER_ADDRESS_STATE_OR_PROVINCE = PROP_TAG(PT_UNICODE, 0x3A62), /* PidTagOtherAddressStateOrProvince */
	PR_OTHER_ADDRESS_STREET = PROP_TAG(PT_UNICODE, 0x3A63), /* PidTagOtherAddressStreet */
	PR_OTHER_ADDRESS_POST_OFFICE_BOX = PROP_TAG(PT_UNICODE, 0x3A64), /* PidTagOtherAddressPostOfficeBox */
	PR_USER_X509_CERTIFICATE = PROP_TAG(PT_MV_BINARY, 0x3A70), /* PidTagUserX509Certificate */
	PR_SEND_INTERNET_ENCODING = PROP_TAG(PT_LONG, 0x3A71), /* PidTagSendInternetEncoding */
	// PR_STORE_PROVIDERS = PROP_TAG(PT_BINARY, 0x3D00), /* PidTagStoreProviders */
	// PR_AB_PROVIDERS = PROP_TAG(PT_BINARY, 0x3D01), /* PidTagAbProviders */
	// PR_TRANSPORT_PROVIDERS = PROP_TAG(PT_BINARY, 0x3D02), /* PidTagTransportProviders */
	// PR_DEFAULT_PROFILE = PROP_TAG(PT_BOOLEAN, 0x3D04), /* PidTagDefaultProfile /*
	// PR_AB_SEARCH_PATH = PROP_TAG(PT_MV_BINARY, 0x3D05), /* PidTagAbSearchPath */
	// PR_AB_DEFAULT_DIR = PROP_TAG(PT_BINARY, 0x3D06), /* PidTagAbDefaultDir */
	// PR_AB_DEFAULT_PAB = PROP_TAG(PT_BINARY, 0x3D07),
	// PR_FILTERING_HOOKS = PROP_TAG(PT_BINARY, 0x3D08),
	// PR_SERVICE_NAME = PROP_TAG(PT_UNICODE, 0x3D09), /* PidTagServiceName */
	// PR_SERVICE_DLL_NAME = PROP_TAG(PT_UNICODE, 0x3D0A), /* PidTagServiceDllName */
	// PR_SERVICE_ENTRY_NAME = PROP_TAG(PT_STRING8, 0x3D0B), /* PidTagServiceEntryName */
	// PR_SERVICE_UID = PROP_TAG(PT_BINARY, 0x3D0C), /* PidTagServiceUid */
	// PR_SERVICE_EXTRA_UIDS = PROP_TAG(PT_BINARY, 0x3D0D), /* PidTagServiceExtraUids */
	// PR_SERVICES = PROP_TAG(PT_BINARY, 0x3D0E), /* PidTagServices /*
	// PR_SERVICE_SUPPORT_FILES = PROP_TAG(PT_MV_UNICODE, 0x3D0F), /* PidTagServiceSupportFiles */
	// PR_SERVICE_DELETE_FILES = PROP_TAG(PT_MV_UNICODE, 0x3D10), /* PidTagServiceDeleteFiles */
	// PR_AB_SEARCH_PATH_UPDATE = PROP_TAG(PT_BINARY, 0x3D11), /* PidTagAbSearchPathUpdate */
	// PR_PROFILE_NAME = PROP_TAG(PT_UNICODE, 0x3D12), /* PidTagProfileName */
	// PR_EMSMDB_SECTION_UID = PROP_TAG(PT_BINARY, 0x3D15), /* PidTagExchangeProfileSectionId */
	// PR_EMSMDB_LEGACY = PROP_TAG(PT_BOOLEAN, 0x3D18),
	// PR_EMSABP_USER_UID = PROP_TAG(PT_BINARY, 0x3D1A),
	// PR_AB_CHOOSE_DIRECTORY_AUTOMATICALLY = PROP_TAG(PT_BOOLEAN, 0x3D1C), /* PidTagAddressBookChooseDirectoryAutomatically */
	PR_CORRELATION_ID = PROP_TAG(PT_CLSID, 0x3DD1),
	// PR_IDENTITY_DISPLAY = PROP_TAG(PT_UNICODE, 0x3E00), /* PidTagIdentityDisplay */
	// PR_IDENTITY_ENTRYID = PROP_TAG(PT_BINARY, 0x3E01), /* PidTagIdentityEntryId */
	// PR_RESOURCE_METHODS = PROP_TAG(PT_LONG, 0x3E02), /* PidTagResourceMethods */
	PR_RESOURCE_TYPE = PROP_TAG(PT_LONG, 0x3E03), /* PidTagResourceType */
	// PR_STATUS_CODE = PROP_TAG(PT_LONG, 0x3E04), /* PidTagStatusCode */
	// PR_IDENTITY_SEARCH_KEY = PROP_TAG(PT_BINARY, 0x3E05), /* PidTagIdentitySearchKey */
	// PR_OWN_STORE_ENTRYID = PROP_TAG(PT_BINARY, 0x3E06), /* PidTagOwnStoreEntryId */
	// PR_RESOURCE_PATH = PROP_TAG(PT_UNICODE, 0x3E07), /* PidTagResourcePath /*
	// PR_STATUS_STRING = PROP_TAG(PT_UNICODE, 0x3E08), /* PidTagStatusString */
	// PR_X400_DEFERRED_DELIVERY_CANCEL = PROP_TAG(PT_BOOLEAN, 0x3E09),
	// PR_HEADER_FOLDER_ENTRYID = PROP_TAG(PT_BINARY, 0x3E0A),
	// PR_REMOTE_PROGRESS = PROP_TAG(PT_LONG, 0x3E0B), /* PidTagRemoteProgress */
	// PR_REMOTE_PROGRESS_TEXT = PROP_TAG(PT_UNICODE, 0x3E0C), /* PidTagRemoteProgressText */
	// PR_REMOTE_VALIDATE_OK = PROP_TAG(PT_BOOLEAN, 0x3E0D), /* PidTagRemoteValidateOk */
	PR_CONTROL_FLAGS = PROP_TAG(PT_LONG, 0x3F00), /* PidTagControlFlags */
	// PR_CONTROL_STRUCTURE = PROP_TAG(PT_BINARY, 0x3F01), /* PidTagControlStructure */
	PR_CONTROL_TYPE = PROP_TAG(PT_LONG, 0x3F02), /* PidTagControlType */
	// PR_DELTAX = PROP_TAG(PT_LONG, 0x3F03), /* PidTagDeltaX */
	// PR_DELTAY = PROP_TAG(PT_LONG, 0x3F04), /* PidTagDeltaY */
	// PR_XPOS = PROP_TAG(PT_LONG, 0x3F05), /* PidTagXCoordinate */
	// PR_YPOS = PROP_TAG(PT_LONG, 0x3F06), /* PidTagYCoordinate */
	// PR_CONTROL_ID = PROP_TAG(PT_BINARY, 0x3F07), /* PidTagControlId */
	// PR_INITIAL_DETAILS_PANE = PROP_TAG(PT_LONG, 0x3F08), /* PidTagInitialDetailsPane */
	// PR_PREVIEW_UNREAD = PROP_TAG(PT_UNICODE, 0x3FD8),
	PR_PREVIEW = PROP_TAG(PT_UNICODE, 0x3FD9),
	PR_INTERNET_CPID = PROP_TAG(PT_LONG, 0x3FDE), /* PidTagInternetCodepage */
	PR_AUTO_RESPONSE_SUPPRESS = PROP_TAG(PT_LONG, 0x3FDF), /* PidTagAutoResponseSuppress */
	PR_ACL_DATA = PROP_TAG(PT_BINARY, 0x3FE0), /* PidTagAccessControlListData */
	PR_ACL_TABLE = PROP_TAG(PT_OBJECT, 0x3FE0), /* PidTagAccessControlListTable */
	PR_RULES_DATA = PROP_TAG(PT_BINARY, 0x3FE1), /* PidTagRulesData */
	PR_RULES_TABLE = PROP_TAG(PT_OBJECT, 0x3FE1), /* PidTagRulesTable */
	PR_DELEGATED_BY_RULE = PROP_TAG(PT_BOOLEAN, 0x3FE3), /* PidTagDelegatedByRule */
	PR_RESOLVE_METHOD = PROP_TAG(PT_LONG, 0x3FE7), /* PidTagResolveMethod */
	// PR_HAS_DAMS = PROP_TAG(PT_BOOLEAN, 0x3FEA), /* PidTagHasDeferredActionMessages */
	PR_DEFERRED_SEND_NUMBER = PROP_TAG(PT_LONG, 0x3FEB), /* PidTagDeferredSendNumber */
	PR_DEFERRED_SEND_UNITS = PROP_TAG(PT_LONG, 0x3FEC), /* PidTagDeferredSendUnits */
	// PR_EXPIRY_NUMBER = PROP_TAG(PT_LONG, 0x3FED), /* PidTagExpiryNumber */
	// PR_EXPIRY_UNITS = PROP_TAG(PT_LONG, 0x3FEE), /* PidTagExpiryUnits */
	PR_DEFERRED_SEND_TIME = PROP_TAG(PT_SYSTIME, 0x3FEF), /* PidTagDeferredSendTime */
	PR_CONFLICT_ENTRYID = PROP_TAG(PT_BINARY, 0x3FF0), /* PidTagConflictEntryId */
	PR_MESSAGE_LOCALE_ID = PROP_TAG(PT_LONG, 0x3FF1), /* PidTagMessageLocaleId */
	PR_STORAGE_QUOTA_LIMIT = PROP_TAG(PT_LONG, 0x3FF5),
	PR_CREATOR_NAME = PROP_TAG(PT_UNICODE, 0x3FF8), /* PidTagCreatorName */
	PR_CREATOR_ENTRYID = PROP_TAG(PT_BINARY, 0x3FF9), /* PidTagCreatorEntryId */
	PR_LAST_MODIFIER_NAME = PROP_TAG(PT_UNICODE, 0x3FFA), /* PidTagLastModifierName */
	PR_LAST_MODIFIER_ENTRYID = PROP_TAG(PT_BINARY, 0x3FFB), /* PidTagLastModifierEntryId */
	PR_MESSAGE_CODEPAGE = PROP_TAG(PT_LONG, 0x3FFD), /* PidTagMessageCodepage */
	// ? = PROP_TAG(PT_LONG, 0x3FFF), /* EXCH2019: shows up with value 0 when ReceiveFolderTable was modified */
	NEWATTACH = PROP_TAG(PT_LONG, 0x4000), /* OXCFXICS §2.2.4.1.4 */
	STARTEMBED = PROP_TAG(PT_LONG, 0x4001),
	ENDEMBED = PROP_TAG(PT_LONG, 0x4002),
	STARTRECIP = PROP_TAG(PT_LONG, 0x4003),
	ENDTORECIP = PROP_TAG(PT_LONG, 0x4004),
	MetaTagDnPrefix = PROP_TAG(PT_STRING8, 0x4008), /* OXCFXICS §2.2.4.1.5 */
	STARTTOPFLD = PROP_TAG(PT_LONG, 0x4009),
	STARTSUBFLD = PROP_TAG(PT_LONG, 0x400A),
	ENDFOLDER = PROP_TAG(PT_LONG, 0x400B),
	STARTMESSAGE = PROP_TAG(PT_LONG, 0x400C),
	ENDMESSAGE = PROP_TAG(PT_LONG, 0x400D),
	ENDATTACH = PROP_TAG(PT_LONG, 0x400E),
	MetaTagEcWarning = PROP_TAG(PT_LONG, 0x400F),
	STARTFAIMSG = PROP_TAG(PT_LONG, 0x4010),
	MetaTagNewFXFolder = PROP_TAG(PT_BINARY, 0x4011),
	INCRSYNCCHG = PROP_TAG(PT_LONG, 0x4012),
	INCRSYNCDEL = PROP_TAG(PT_LONG, 0x4013),
	INCRSYNCEND = PROP_TAG(PT_LONG, 0x4014),
	INCRSYNCMESSAGE = PROP_TAG(PT_LONG, 0x4015),
	MetaTagFXDelProp = PROP_TAG(PT_LONG, 0x4016),
	MetaTagIdsetGiven = PROP_TAG(PT_LONG, 0x4017), /* OXCFXICS v24 §2.2.1.1 */
	MetaTagIdsetGiven1 = PROP_TAG(PT_BINARY, 0x4017), /* OXCFXICS v24 §3.2.5.2.1 */
	FXERRORINFO = PROP_TAG(PT_LONG, 0x4018),
	// PR_SENT_REPRESENTING_FLAGS = PROP_TAG(PT_LONG, 0x401A), /* PidTagSentRepresentingFlags */
	MetaTagIdsetNoLongerInScope = PROP_TAG(PT_BINARY, 0x4021),
	PidTagReadReceiptAddressType = PROP_TAG(PT_UNICODE, 0x4029),
	PidTagReadReceiptEmailAddress = PROP_TAG(PT_UNICODE, 0x402A),
	PidTagReadReceiptName = PROP_TAG(PT_UNICODE, 0x402B),
	MetaTagIdsetRead = PROP_TAG(PT_BINARY, 0x402D),
	MetaTagIdsetUnread = PROP_TAG(PT_BINARY, 0x402E),
	INCRSYNCREAD = PROP_TAG(PT_LONG, 0x402F),
	INCRSYNCSTATEBEGIN = PROP_TAG(PT_LONG, 0x403A),
	INCRSYNCSTATEEND = PROP_TAG(PT_LONG, 0x403B),
	INCRSYNCPROGRESSMODE = PROP_TAG(PT_BOOLEAN, 0x4074),
	INCRSYNCPROGRESSPERMSG = PROP_TAG(PT_BOOLEAN, 0x4075),
	PR_CONTENT_FILTER_SCL = PROP_TAG(PT_LONG, 0x4076), /* PidTagContentFilterSpamConfidenceLevel */
	PR_SENDER_ID_STATUS = PROP_TAG(PT_LONG, 0x4079), /* PidTagSenderIdStatus */
	MetaTagIncrementalSyncMessagePartial = PROP_TAG(PT_LONG, 0x407A),
	INCRSYNCGROUPINFO = PROP_TAG(PT_BINARY, 0x407B),
	MetaTagIncrSyncGroupId = PROP_TAG(PT_LONG, 0x407C),
	INCRSYNCCHGPARTIAL = PROP_TAG(PT_LONG, 0x407D),
	PR_HIER_REV = PROP_TAG(PT_SYSTIME, 0x4082), /* PidTagHierRev */
	PR_PURPORTED_SENDER_DOMAIN = PROP_TAG(PT_UNICODE, 0x4083), /* PidTagPurportedSenderDomain */
	PR_PURPORTED_SENDER_DOMAIN_A = PROP_TAG(PT_STRING8, 0x4083),
	PR_INETMAIL_OVERRIDE_FORMAT = PROP_TAG(PT_LONG, 0x5902), /* PidTagInternetMailOverrideFormat */
	// PR_MSG_EDITOR_FORMAT = PROP_TAG(PT_LONG, 0x5909), /* PidTagMessageEditorFormat */
	PR_SENDER_SMTP_ADDRESS = PROP_TAG(PT_UNICODE, 0x5D01), /* PidTagSenderSmtpAddress */
	PR_SENT_REPRESENTING_SMTP_ADDRESS = PROP_TAG(PT_UNICODE, 0x5D02), /* PidTagSentRepresentingSmtpAddress */
	PidTagReadReceiptSmtpAddress = PROP_TAG(PT_UNICODE, 0x5D05),
	// PidTagReceivedBySmtpAddress = PROP_TAG(PT_UNICODE, 0x5D07),
	// PidTagReceivedRepresentingSmtpAddress = PROP_TAG(PT_UNICODE, 0x5D08),
	// PR_RECIPIENT_ORDER = PROP_TAG(PT_LONG, 0x5FDF), /* PidTagRecipientOrder */
	// PR_RECIPIENT_PROPOSED = PROP_TAG(PT_BOOLEAN, 0x5FE1), /* PidTagRecipientProposed */
	// PR_RECIPIENT_PROPOSEDSTARTTIME = PROP_TAG(PT_SYSTIME, 0x5FE3), /* PidTagRecipientProposedStartTime */
	// PR_RECIPIENT_PROPOSEDENDTIME = PROP_TAG(PT_SYSTIME, 0x5FE4), /* PidTagRecipientProposedEndTime */
	PR_RECIPIENT_DISPLAY_NAME = PROP_TAG(PT_UNICODE, 0x5FF6), /* PidTagRecipientDisplayName */
	PR_RECIPIENT_ENTRYID = PROP_TAG(PT_BINARY, 0x5FF7), /* PidTagRecipientEntryId */
	// PR_RECIPIENT_TRACKSTATUS_TIME = PROP_TAG(PT_SYSTIME, 0x5FFB), /* PidTagRecipientTrackStatusTime */
	PR_RECIPIENT_FLAGS = PROP_TAG(PT_LONG, 0x5FFD), /* PidTagRecipientFlags */
	// PR_RECIPIENT_TRACKSTATUS = PROP_TAG(PT_LONG, 0x5FFF), /* PidTagRecipientTrackStatus */
	// PR_JUNK_INCLUDE_CONTACTS = PROP_TAG(PT_LONG, 0x6100), /* PidTagJunkIncludeContacts */
	// PR_JUNK_THRESHOLD = PROP_TAG(PT_LONG, 0x6101), /* PidTagJunkThreshold */
	// PR_JUNK_PERMANENTLY_DELETE = PROP_TAG(PT_LONG, 0x6102), /* PidTagJunkPermanentlyDelete */
	// PR_JUNK_ADD_RECIPS_TO_SSL = PROP_TAG(PT_LONG, 0x6103), /* PidTagJunkAddRecipientsToSafeSendersList */
	// PR_JUNK_PHISHING_ENABLE_LINKS = PROP_TAG(PT_BOOLEAN, 0x6107), /* PidTagJunkPhishingEnableLinks */
	PidTagMimeSkeleton = PROP_TAG(PT_BINARY, 0x64F0),
	PR_REPLY_TEMPLATE_ID = PROP_TAG(PT_BINARY, 0x65C2), /* PidTagReplyTemplateId */
	// PR_SECURE_SUBMIT_FLAGS = PROP_TAG(PT_LONG, 0x65C6), /* PidTagSecureSubmitFlags, OXPROPS v1.02 §2.864 */
	PR_SOURCE_KEY = PROP_TAG(PT_BINARY, 0x65E0), /* PidTagSourceKey */
	PR_PARENT_SOURCE_KEY = PROP_TAG(PT_BINARY, 0x65E1), /* PidTagParentSourceKey */
	PR_CHANGE_KEY = PROP_TAG(PT_BINARY, 0x65E2), /* PidTagChangeKey */
	PR_PREDECESSOR_CHANGE_LIST = PROP_TAG(PT_BINARY, 0x65E3), /* PidTagPredecessorChangeList */
	PR_RULE_MSG_STATE = PROP_TAG(PT_LONG, 0x65E9), /* PidTagRuleMessageState */
	// PR_RULE_MSG_USER_FLAGS = PROP_TAG(PT_LONG, 0x65EA), /* PidTagRuleMessageUserFlags */
	PR_RULE_MSG_PROVIDER = PROP_TAG(PT_UNICODE, 0x65EB), /* PidTagRuleMessageProvider */
	PR_RULE_MSG_NAME = PROP_TAG(PT_UNICODE, 0x65EC), /* PidTagRuleMessageName */
	// PR_RULE_MSG_LEVEL = PROP_TAG(PT_LONG, 0x65ED), /* PidTagRuleMessageLevel */
	// PR_RULE_MSG_PROVIDER_DATA = PROP_TAG(PT_BINARY, 0x65EE), /* PidTagRuleMessageProviderData */
	PR_RULE_MSG_SEQUENCE = PROP_TAG(PT_LONG, 0x65F3), /* PidTagRuleMessageSequence */
	PR_PST_RECEIVE_FOLDER_NID = PROP_TAG(PT_LONG, 0x6605),
	// PR_PROFILE_TRANSPORT_FLAGS = PROP_TAG(PT_LONG, 0x6605),
	PR_USER_ENTRYID = PROP_TAG(PT_BINARY, 0x6619), /* PidTagUserEntryId */
	PR_USER_NAME = PROP_TAG(PT_STRING8, 0x661A),
	PR_MAILBOX_OWNER_ENTRYID = PROP_TAG(PT_BINARY, 0x661B), /* PidTagMailboxOwnerEntryId */
	PR_MAILBOX_OWNER_NAME = PROP_TAG(PT_UNICODE, 0x661C), /* PidTagMailboxOwnerName */
	PR_MAILBOX_OWNER_NAME_A = PROP_TAG(PT_STRING8, 0x661C),
	PR_OOF_STATE = PROP_TAG(PT_BOOLEAN, 0x661D), /* PidTagOutOfOfficeState */
	PR_SCHEDULE_FOLDER_ENTRYID = PROP_TAG(PT_BINARY, 0x661E),
	PR_IPM_DAF_ENTRYID = PROP_TAG(PT_BINARY, 0x661F),
	PR_NON_IPM_SUBTREE_ENTRYID = PROP_TAG(PT_BINARY, 0x6620), /* PidTagNonIpmSubtreeEntryId */
	PR_EFORMS_REGISTRY_ENTRYID = PROP_TAG(PT_BINARY, 0x6621),
	PR_SPLUS_FREE_BUSY_ENTRYID = PROP_TAG(PT_BINARY, 0x6622), /* PidTagSchedulePlusFreeBusyEntryId */
	// PR_OFFLINE_ADDRBOOK_ENTRYID = PROP_TAG(PT_BINARY, 0x6623),
	PR_TEST_LINE_SPEED = PROP_TAG(PT_BINARY, 0x662B),
	PR_HIERARCHY_SYNCHRONIZER = PROP_TAG(PT_OBJECT, 0x662C),
	PR_CONTENTS_SYNCHRONIZER = PROP_TAG(PT_OBJECT, 0x662D),
	PR_COLLECTOR = PROP_TAG(PT_OBJECT, 0x662E),
	PR_IPM_FAVORITES_ENTRYID = PROP_TAG(PT_BINARY, 0x6630),
	PR_IPM_PUBLIC_FOLDERS_ENTRYID = PROP_TAG(PT_BINARY, 0x6631),
	PR_STORE_OFFLINE = PROP_TAG(PT_BOOLEAN, 0x6632),
	PR_HIERARCHY_SERVER = PROP_TAG(PT_UNICODE, 0x6633),
	// PR_PST_LRNORESTRICTIONS = PROP_TAG(PT_BOOLEAN, 0x6633), /* PidTagPstLrNoRestrictions */
	// PR_FAVORITES_DEFAULT_NAME = PROP_TAG(PT_UNICODE, 0x6635),
	// PR_PROFILE_OAB_COUNT_ATTEMPTED_FULLDN = PROP_TAG(PT_LONG, 0x6635), /* PidTagProfileOabCountAttemptedFulldn */
	// PR_PST_HIDDEN_COUNT = PROP_TAG(PT_LONG, 0x6635), /* PidTagPstHiddenCount */
	// PR_PROFILE_OAB_COUNT_ATTEMPTED_INCRDN = PROP_TAG(PT_LONG, 0x6636), /* PidTagProfileOabCountAttemptedIncrdn */
	// PR_PST_HIDDEN_UNREAD = PROP_TAG(PT_LONG, 0x6636), /* PidTagPstHiddenUnread */
	PR_FOLDER_CHILD_COUNT = PROP_TAG(PT_LONG, 0x6638),
	PidTagSerializedReplidGuidMap = PROP_TAG(PT_BINARY, 0x6638),
	PR_RIGHTS = PROP_TAG(PT_LONG, 0x6639), /* PidTagRights */
	PR_HAS_RULES = PROP_TAG(PT_BOOLEAN, 0x663A), /* PidTagHasRules */
	PR_ADDRESS_BOOK_ENTRYID = PROP_TAG(PT_BINARY, 0x663B), /* PidTagAddressBookEntryId */
	PR_HIERARCHY_CHANGE_NUM = PROP_TAG(PT_LONG, 0x663E), /* PidTagHierarchyChangeNumber */
	PR_DELETED_MSG_COUNT = PROP_TAG(PT_LONG, 0x6640), /* PidTagDeletedMessageCount */
	PR_DELETED_FOLDER_COUNT = PROP_TAG(PT_LONG, 0x6641), /* MS-OXPROPS v0.2 §2.570 PidTagDeletedMessageCount */
	PR_DELETED_ASSOC_MSG_COUNT = PROP_TAG(PT_LONG, 0x6643), /* MS-OXPROPS v0.2 §2.568 PidTagDeletedAssociatedMessageCount */
	// PR_REPLICA_SERVER = PROP_TAG(PT_STRING8, 0x6644),
	PR_CLIENT_ACTIONS = PROP_TAG(PT_BINARY, 0x6645), /* PidTagClientActions */
	PR_DAM_ORIGINAL_ENTRYID = PROP_TAG(PT_BINARY, 0x6646), /* PidTagDamOriginalEntryId */
	PR_DAM_BACK_PATCHED = PROP_TAG(PT_BOOLEAN, 0x6647), /* PidTagDamBackPatched */
	PR_RULE_ERROR = PROP_TAG(PT_LONG, 0x6648), /* PidTagRuleError */
	PR_RULE_ACTION_TYPE = PROP_TAG(PT_LONG, 0x6649), /* PidTagRuleActionType */
	PR_HAS_NAMED_PROPERTIES = PROP_TAG(PT_BOOLEAN, 0x664A), /* PidTagHasNamedProperties */
	// ? = PROP_TAG(PT_UNICODE, 0x664A), /* MSEMS service: Autodiscover URL (OL2013,2021) */
	PR_RULE_ACTION_NUMBER = PROP_TAG(PT_LONG, 0x6650), /* PidTagRuleActionNumber */
	PR_RULE_FOLDER_ENTRYID = PROP_TAG(PT_BINARY, 0x6651), /* PidTagRuleFolderEntryId */
	// ? = PROP_TAG(PT_UNICODE, 0x6652), /* MSEMS service: mh_emsmdb URL for the current store (OL2013) */
	// ? = PROP_TAG(PT_UNICODE, 0x6653), /* MSEMS service: mh_emsmdb URL for the current store (OL2013) */
	// ? = PROP_TAG(PT_UNICODE, 0x6654), /* MSEMS service: mh_nsp URL for the current store (OL2013) */
	// ? = PROP_TAG(PT_UNICODE, 0x6655), /* MSEMS service: mh_nsp URL for the current store (OL2013) */
	// ? = PROP_TAG(PT_UNICODE, 0x6656), /* MSEMS service: mh_emsmdb URL for the current store (OL2019) */
	PR_PROHIBIT_RECEIVE_QUOTA = PROP_TAG(PT_LONG, 0x666A), /* PidTagProhibitReceiveQuota */
	PR_IN_CONFLICT = PROP_TAG(PT_BOOLEAN, 0x666C), /* PidTagInConflict */
	PR_MAX_SUBMIT_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x666D), /* PidTagMaximumSubmitMessageSize */
	PR_PROHIBIT_SEND_QUOTA = PROP_TAG(PT_LONG, 0x666E), /* PidTagProhibitSendQuota */
	PR_EC_USER_LANGUAGE = PROP_TAG(PT_UNICODE, 0x6670),
	PR_EC_USER_TIMEZONE = PROP_TAG(PT_UNICODE, 0x6671),
	PR_MEMBER_ID = PROP_TAG(PT_I8, 0x6671), /* PidTagMemberId */
	PR_MEMBER_NAME = PROP_TAG(PT_UNICODE, 0x6672), /* PidTagMemberName */
	PR_MEMBER_NAME_A = PROP_TAG(PT_STRING8, 0x6672),
	PR_MEMBER_RIGHTS = PROP_TAG(PT_LONG, 0x6673), /* PidTagMemberRights */
	PR_RULE_ID = PROP_TAG(PT_I8, 0x6674), /* PidTagRuleId */
	PR_RULE_IDS = PROP_TAG(PT_BINARY, 0x6675), /* PidTagRuleIds */
	PR_RULE_SEQUENCE = PROP_TAG(PT_LONG, 0x6676), /* PidTagRuleSequence */
	PR_RULE_STATE = PROP_TAG(PT_LONG, 0x6677), /* PidTagRuleState */
	PR_RULE_USER_FLAGS = PROP_TAG(PT_LONG, 0x6678), /* PidTagRuleUserFlags */
	PR_RULE_CONDITION = PROP_TAG(PT_SRESTRICTION, 0x6679), /* PidTagRuleCondition */
	PR_RULE_ACTIONS = PROP_TAG(PT_ACTIONS, 0x6680), /* PidTagRuleActions */
	PR_RULE_PROVIDER = PROP_TAG(PT_UNICODE, 0x6681), /* PidTagRuleProvider */
	PR_RULE_PROVIDER_A = PROP_TAG(PT_STRING8, 0x6681),
	PR_RULE_NAME = PROP_TAG(PT_UNICODE, 0x6682), /* PidTagRuleName */
	PR_RULE_NAME_A = PROP_TAG(PT_STRING8, 0x6682),
	PR_RULE_LEVEL = PROP_TAG(PT_LONG, 0x6683), /* PidTagRuleLevel */
	PR_RULE_PROVIDER_DATA = PROP_TAG(PT_BINARY, 0x6684), /* PidTagRuleProviderData */
	// PR_RULE_VERSION = PROP_TAG(PT_SHORT, 0x668D),
	PR_DELETED_ON = PROP_TAG(PT_SYSTIME, 0x668F), /* PidTagDeletedOn */
	PR_DELETED_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x669B),
	PR_DELETED_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x669B), /* MS-OXPROPS v0.2 §2.571 PidTagDeletedMessageSizeExtended */
	PR_DELETED_NORMAL_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x669C),
	PR_DELETED_NORMAL_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x669C), /* MS-OXPROPS v0.2 §2.572 PidTagDeletedNormalMessageSizeExtended */
	PR_DELETED_ASSOC_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x669D),
	PR_DELETED_ASSOC_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x669D), /* MS-OXPROPS v0.2 §2.569 PidTagDeletedAssociatedMessageSizeExtended */
	PR_LOCALE_ID = PROP_TAG(PT_LONG, 0x66A1), /* PidTagLocaleId */
	PR_FOLDER_FLAGS = PROP_TAG(PT_LONG, 0x66A8), /* PidTagFolderFlags */
	PR_NORMAL_MSG_W_ATTACH_COUNT = PROP_TAG(PT_LONG, 0x66AD),
	PR_ASSOC_MSG_W_ATTACH_COUNT = PROP_TAG(PT_LONG, 0x66AE),
	PR_NORMAL_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x66B3), /* MS-OXPROPS v0.2 §2.719 PidTagNormalMessageSize */
	PR_NORMAL_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x66B3), /* PidTagNormalMessageSize */
	PR_ASSOC_MESSAGE_SIZE = PROP_TAG(PT_LONG, 0x66B4),
	PR_ASSOC_MESSAGE_SIZE_EXTENDED = PROP_TAG(PT_I8, 0x66B4),
	PR_FOLDER_PATHNAME = PROP_TAG(PT_UNICODE, 0x66B5),
	PR_CODE_PAGE_ID = PROP_TAG(PT_LONG, 0x66C3), /* PidTagCodePageId */
	// PR_LATEST_PST_ENSURE = PROP_TAG(PT_LONG, 0x66FA), /* PidTagLatestPstEnsure */
	// PR_EMS_AB_MANAGE_DL = PROP_TAG(PT_OBJECT, 0x6704), /* PidTagAddressBookManageDistributionList */
	PR_SORT_LOCALE_ID = PROP_TAG(PT_LONG, 0x6705), /* PidTagSortLocaleId */
	PR_EC_SSLKEY_PASS = PROP_TAG(PT_UNICODE, 0x6706),
	// PidTagMailboxDSGuid = PROP_TAG(PT_BINARY, 0x6707),
	PR_LOCAL_COMMIT_TIME = PROP_TAG(PT_SYSTIME, 0x6709), /* PidTagLocalCommitTime */
	PR_LOCAL_COMMIT_TIME_MAX = PROP_TAG(PT_SYSTIME, 0x670A), /* PidTagLocalCommitTimeMax */
	PR_DELETED_COUNT_TOTAL = PROP_TAG(PT_LONG, 0x670B), /* PidTagDeletedCountTotal */
	// PR_FLAT_URL_NAME = PROP_TAG(PT_UNICODE, 0x670E), /* PidTagFlatUrlName */
	// PR_ZC_CONTACT_STORE_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x6711), /* only on IProfSect, not in store */
	// PR_ZC_CONTACT_FOLDER_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x6712), /* IProfsect only */
	// PR_ZC_CONTACT_FOLDER_NAMES = PROP_TAG(PT_MV_UNICODE, 0x6713), /* IProfSect only */
	PR_EC_SERVER_VERSION = PROP_TAG(PT_UNICODE, 0x6716),
	// PR_QUOTA_WARNING_THRESHOLD = PROP_TAG(PT_LONG, 0x6721),
	// PR_QUOTA_SEND_THRESHOLD = PROP_TAG(PT_LONG, 0x6722),
	// PR_QUOTA_RECEIVE_THRESHOLD = PROP_TAG(PT_LONG, 0x6723),
	PR_EC_MESSAGE_BCC_ME = PROP_TAG(PT_BOOLEAN, 0x6725),
	// PR_MANAGED_FOLDER_INFORMATION = PROP_TAG(PT_LONG, 0x672D),
	// PR_MANAGED_FOLDER_SIZE = PROP_TAG(PT_LONG, 0x6730),
	// PR_MANAGED_FOLDER_STORAGE_QUOTA = PROP_TAG(PT_LONG, 0x6731),
	// PR_MANAGED_FOLDER_ID = PROP_TAG(PT_UNICODE, 0x6732),
	// PR_MANAGED_FOLDER_COMMENT = PROP_TAG(PT_UNICODE, 0x6733),
	PidTagSentMailSvrEID = PROP_TAG(PT_SVREID, 0x6740),
	PR_DAM_ORIG_MSG_SVREID = PROP_TAG(PT_BINARY, 0x6741), /* PidTagDeferredActionMessageOriginalEntryId */
	PR_RULE_FOLDER_FID = PROP_TAG(PT_I8, 0x6742), /* Gromox-specific */
	PidTagFolderId = PROP_TAG(PT_I8, 0x6748),
	PidTagParentFolderId = PROP_TAG(PT_I8, 0x6749),
	PidTagMid = PROP_TAG(PT_I8, 0x674A),
	PidTagInstID = PROP_TAG(PT_I8, 0x674D),
	PidTagInstanceNum = PROP_TAG(PT_LONG, 0x674E),
	// PidTagAddressBookMessageId = PROP_TAG(PT_I8, 0x674F),
	// ? = PROP_TAG(PT_STRING8, 0x6750), /* MSEMS service: MAPI profile name */
	PR_INTERNET_ARTICLE_NUMBER_NEXT = PROP_TAG(PT_LONG, 0x6751),
	PR_EC_OUTOFOFFICE = PROP_TAG(PT_LONG, 0x6760),
	PR_EC_OUTOFOFFICE_MSG = PROP_TAG(PT_UNICODE, 0x6761), /* specific to zcore & grommunio-web */
	PR_EC_OUTOFOFFICE_SUBJECT = PROP_TAG(PT_UNICODE, 0x6762),
	PR_EC_OUTOFOFFICE_FROM = PROP_TAG(PT_SYSTIME, 0x6763),
	PR_EC_OUTOFOFFICE_UNTIL = PROP_TAG(PT_SYSTIME, 0x6764),
	PR_EC_ALLOW_EXTERNAL = PROP_TAG(PT_BOOLEAN, 0x6765),
	PR_EC_EXTERNAL_AUDIENCE = PROP_TAG(PT_BOOLEAN, 0x6766),
	PR_EC_EXTERNAL_REPLY = PROP_TAG(PT_UNICODE, 0x6767),
	PR_EC_EXTERNAL_SUBJECT = PROP_TAG(PT_UNICODE, 0x6768),
	PR_EC_WEBACCESS_SETTINGS_JSON = PROP_TAG(PT_UNICODE, 0x6772),
	PR_EC_RECIPIENT_HISTORY_JSON = PROP_TAG(PT_UNICODE, 0x6773),
	PR_EC_WEBAPP_PERSISTENT_SETTINGS_JSON = PROP_TAG(PT_UNICODE, 0x6774),
	pidTagReservedCnCounterRangeUpperLimit = PROP_TAG(PT_I8, 0x677E),
	pidTagReservedIdCounterRangeUpperLimit = PROP_TAG(PT_I8, 0x677F),
	// ? = PROP_TAG(PT_LONG, 0x6780), /* EXCH2019: number of ReceiveFolderTable entries pointing to this folder */
	// PR_EC_OUTGOING_FLAGS = PROP_TAG(PT_LONG, 0x6780),
	PR_EC_IMAP_ID = PROP_TAG(PT_LONG, 0x6782),
	PR_EC_IMAP_SUBSCRIBED = PROP_TAG(PT_BINARY, 0x6784),
	PR_EC_IMAP_MAX_ID = PROP_TAG(PT_LONG, 0x6785),
	// PR_EC_CLIENT_SUBMIT_DATE = PROP_TAG(PT_SYSTIME, 0x6786),
	// PR_EC_MESSAGE_DELIVERY_DATE = PROP_TAG(PT_SYSTIME, 0x6787),
	PR_EC_IMAP_EMAIL_SIZE = PROP_TAG(PT_LONG, 0x678D),
	PR_EC_IMAP_BODY = PROP_TAG(PT_UNICODE, 0x678E),
	PR_EC_IMAP_BODYSTRUCTURE = PROP_TAG(PT_UNICODE, 0x678F),
	MetaTagIdsetExpired = PROP_TAG(PT_BINARY, 0x6793),
	MetaTagCnsetSeen = PROP_TAG(PT_BINARY, 0x6796),
	PidTagChangeNumber = PROP_TAG(PT_I8, 0x67A4),
	PR_ASSOCIATED = PROP_TAG(PT_BOOLEAN, 0x67AA), /* PidTagAssociated */
	PR_EC_ENABLED_FEATURES_L = PROP_TAG(PT_LONG, 0x67B3),
	MetaTagCnsetRead = PROP_TAG(PT_BINARY, 0x67D2),
	MetaTagCnsetSeenFAI = PROP_TAG(PT_BINARY, 0x67DA),
	MetaTagIdsetDeleted = PROP_TAG(PT_BINARY, 0x67E5), /* OXCFXICS §2.2.1.3 */
	// PR_LTP_ROW_ID = PROP_TAG(PT_LONG, 0x67F2), /* PidTagLtpRowId */
	// PR_LTP_ROW_VER = PROP_TAG(PT_LONG, 0x67F3), /* PidTagLtpRowVer */
	// ? = PROP_TAG(PT_I8, 0x67F4), /* PFF/OST: EXCH-side FID (0x6748-style) of this folder */
	// PR_PST_PASSWORD = PROP_TAG(PT_LONG, 0x67FF), /* PidTagPstPassword */
	// PR_OAB_NAME = PROP_TAG(PT_UNICODE, 0x6800), /* PidTagOfflineAddressBookName */
	PidTagVoiceMessageDuration = PROP_TAG(PT_LONG, 0x6801),
	// PR_OAB_SEQUENCE = PROP_TAG(PT_LONG, 0x6801), /* PidTagOfflineAddressBookSequence */
	PR_RW_RULES_STREAM = PROP_TAG(PT_BINARY, 0x6802), /* PidTagRwRulesStream */
	PR_SENDER_TELEPHONE_NUMBER = PROP_TAG(PT_UNICODE, 0x6802), /* PidTagSenderTelephoneNumber */
	PR_SENDER_TELEPHONE_NUMBER_A = PROP_TAG(PT_STRING8, 0x6802),
	// PR_OAB_CONTAINER_GUID = PROP_TAG(PT_STRING8, 0x6802), /* PidTagOfflineAddressBookContainerGuid */
	PidTagVoiceMessageSenderName = PROP_TAG(PT_UNICODE, 0x6803),
	PidTagVoiceMessageSenderName_A = PROP_TAG(PT_STRING8, 0x6803),
	// PR_OAB_MESSAGE_CLASS = PROP_TAG(PT_LONG, 0x6803), /* PidTagOfflineAddressBookMessageClass */
	PidTagFaxNumberOfPages = PROP_TAG(PT_LONG, 0x6804),
	// PR_OAB_DN = PROP_TAG(PT_STRING8, 0x6804), /* PidTagOfflineAddressBookDistinguishedName */
	PidTagVoiceMessageAttachmentOrder = PROP_TAG(PT_UNICODE, 0x6805),
	PidTagVoiceMessageAttachmentOrder_A = PROP_TAG(PT_STRING8, 0x6805),
	// PR_OAB_TRUNCATED_PROPS = PROP_TAG(PT_MV_LONG, 0x6805), /* PidTagOfflineAddressBookTruncatedProperties */
	PidTagCallId = PROP_TAG(PT_UNICODE, 0x6806),
	PidTagCallId_A = PROP_TAG(PT_STRING8, 0x6806),
	// ? = PROP_TAG(PT_BINARY, 0x6814), /* entryid to IPM.Microsoft.OOF.UserOofSettings message */
	PidTagReportingMessageTransferAgent = PROP_TAG(PT_UNICODE, 0x6820),
	// PR_WB_SF_LAST_USED = PROP_TAG(PT_LONG, 0x6834), /* PidTagSearchFolderLastUsed */
	// PR_WB_SF_EXPIRATION = PROP_TAG(PT_LONG, 0x683A), /* PidTagSearchFolderExpiration */
	// PR_WB_SF_TEMPLATE_ID = PROP_TAG(PT_LONG, 0x6841), /* PidTagSearchFolderTemplateId */
	// PR_SCHDINFO_BOSS_WANTS_COPY = PROP_TAG(PT_BOOLEAN, 0x6842), /* PidTagScheduleInfoDelegatorWantsCopy */
	// PR_WB_SF_ID = PROP_TAG(PT_BINARY, 0x6842), /* PidTagSearchFolderId */
	// PidTagWlinkGroupHeaderID = PROP_TAG(PT_CLSID, 0x6842), /* OXPROPS v27 §2.1071 says it is binary(!?) */
	// PR_SCHDINFO_DONT_MAIL_DELEGATES = PROP_TAG(PT_BOOLEAN, 0x6843), /* PidTagScheduleInfoDontMailDelegates */
	// PR_SCHDINFO_DELEGATE_NAMES = PROP_TAG(PT_MV_UNICODE, 0x6844), /* PidTagScheduleInfoDelegateNames */
	// PR_WB_SF_RECREATE_INFO = PROP_TAG(PT_BINARY, 0x6844), /* PidTagSearchFolderRecreateInfo */
	// PR_SCHDINFO_DELEGATE_ENTRYIDS = PROP_TAG(PT_MV_BINARY, 0x6845), /* PidTagScheduleInfoDelegateEntryIds */
	// PR_WB_SF_DEFINITION = PROP_TAG(PT_BINARY, 0x6845), /* PidTagSearchFolderDefinition */
	// PR_GATEWAY_NEEDS_TO_REFRESH = PROP_TAG(PT_BOOLEAN, 0x6846), /* PidTagGatewayNeedsToRefresh */
	// PR_WB_SF_STORAGE_TYPE = PROP_TAG(PT_LONG, 0x6846), /* PidTagSearchFolderStorageType */
	// PR_FREEBUSY_PUBLISH_START = PROP_TAG(PT_LONG, 0x6847), /* PidTagFreeBusyPublishStart */
	// PR_FREEBUSY_PUBLISH_END = PROP_TAG(PT_LONG, 0x6848), /* PidTagFreeBusyPublishEnd */
	// PR_FREEBUSY_EMA = PROP_TAG(PT_UNICODE, 0x6849), /* PidTagFreeBusyMessageEmailAddress */
	// PR_WLINK_TYPE = PROP_TAG(PT_LONG, 0x6849), /* PidTagWlinkType */
	// PR_SCHDINFO_DELEGATE_NAMES_W = PROP_TAG(PT_MV_UNICODE, 0x684A), /* PidTagScheduleInfoDelegateNamesW */
	// PR_WLINK_FLAGS = PROP_TAG(PT_LONG, 0x684A), /* PidTagWlinkFlags */
	// PR_SCHDINFO_BOSS_WANTS_INFO = PROP_TAG(PT_BOOLEAN, 0x684B), /* PidTagScheduleInfoDelegatorWantsInfo */
	// PR_WLINK_ORDINAL = PROP_TAG(PT_BINARY, 0x684B), /* PidTagWlinkOrdinal */
	// PR_WLINK_ENTRYID = PROP_TAG(PT_BINARY, 0x684C), /* PidTagWlinkEntryId */
	// PR_WLINK_RECKEY = PROP_TAG(PT_BINARY, 0x684D), /* PidTagWlinkRecordKey */
	// PR_WLINK_STORE_ENTRYID = PROP_TAG(PT_BINARY, 0x684E), /* PidTagWlinkStoreEntryId */
	// PR_SCHDINFO_MONTHS_MERGED = PROP_TAG(PT_MV_LONG, 0x684F), /* PidTagScheduleInfoMonthsMerged */
	// PR_WLINK_FOLDER_TYPE = PROP_TAG(PT_BINARY, 0x684F), /* PidTagWlinkFolderType */
	// PR_SCHDINFO_FREEBUSY_MERGED = PROP_TAG(PT_MV_BINARY, 0x6850), /* PidTagScheduleInfoFreeBusyMerged */
	// PR_WLINK_GROUP_CLSID = PROP_TAG(PT_BINARY, 0x6850), /* PidTagWlinkGroupClsid */
	// PR_SCHDINFO_MONTHS_TENTATIVE = PROP_TAG(PT_MV_LONG, 0x6851), /* PidTagScheduleInfoMonthsTentative */
	// PR_WLINK_GROUP_NAME = PROP_TAG(PT_UNICODE, 0x6851), /* PidTagWlinkGroupName */
	// PR_SCHDINFO_FREEBUSY_TENTATIVE = PROP_TAG(PT_MV_BINARY, 0x6852), /* PidTagScheduleInfoFreeBusyTentative */
	// PR_WLINK_SECTION = PROP_TAG(PT_LONG, 0x6852), /* PidTagWlinkSection */
	// PR_SCHDINFO_MONTHS_BUSY = PROP_TAG(PT_MV_LONG, 0x6853), /* PidTagScheduleInfoMonthsBusy */
	// PR_WLINK_CALENDAR_COLOR = PROP_TAG(PT_LONG, 0x6853), /* PidTagWlinkCalendarColor */
	// PR_SCHDINFO_FREEBUSY_BUSY = PROP_TAG(PT_MV_BINARY, 0x6854), /* PidTagScheduleInfoFreeBusyBusy */
	// PR_WLINK_ABEID = PROP_TAG(PT_BINARY, 0x6854), /* PidTagWlinkAddressBookEID */
	// PR_SCHDINFO_MONTHS_OOF = PROP_TAG(PT_MV_LONG, 0x6855), /* PidTagScheduleInfoMonthsAway */
	// PR_SCHDINFO_FREEBUSY_OOF = PROP_TAG(PT_MV_BINARY, 0x6856), /* PidTagScheduleInfoFreeBusyAway */
	// PR_FREEBUSY_RANGE_TIMESTAMP = PROP_TAG(PT_SYSTIME, 0x6868), /* PidTagFreeBusyRangeTimestamp */
	// PR_FREEBUSY_COUNT_MONTHS = PROP_TAG(PT_LONG, 0x6869), /* PidTagFreeBusyCountMonths */
	// PR_SCHDINFO_APPT_TOMBSTONE = PROP_TAG(PT_BINARY, 0x686A), /* PidTagScheduleInfoAppointmentTombstone */
	// PR_DELEGATE_FLAGS = PROP_TAG(PT_MV_LONG, 0x686B), /* PidTagDelegateFlags */
	// PR_SCHDINFO_FREEBUSY = PROP_TAG(PT_BINARY, 0x686C), /* PidTagScheduleInfoFreeBusy */
	PR_SCHDINFO_AUTO_ACCEPT_APPTS = PROP_TAG(PT_BOOLEAN, 0x686D), /* PidTagScheduleInfoAutoAcceptAppointments */
	PR_SCHDINFO_DISALLOW_RECURRING_APPTS = PROP_TAG(PT_BOOLEAN, 0x686E), /* PidTagScheduleInfoDisallowRecurringAppts */
	PR_SCHDINFO_DISALLOW_OVERLAPPING_APPTS = PROP_TAG(PT_BOOLEAN, 0x686F), /* PidTagScheduleInfoDisallowOverlappingAppts */
	pidTagConversationContentCount = PROP_TAG(PT_LONG, 0x688E),
	// PR_WLINK_CLIENTID = PROP_TAG(PT_BINARY, 0x6890), /* PidTagWlinkClientID */
	// PR_WLINK_AB_EXSTOREEID = PROP_TAG(PT_BINARY, 0x6891), /* PidTagWlinkAddressBookStoreEID */
	// PR_WLINK_RO_GROUP_TYPE = PROP_TAG(PT_LONG, 0x6892), /* PidTagWlinkROGroupType */
	// PR_SECURITY_FLAGS = PROP_TAG(PT_LONG, 0x6E01),
	// PR_VD_BINARY = PROP_TAG(PT_BINARY, 0x7001), /* PidTagViewDescriptorBinary */
	// PR_VD_STRINGS = PROP_TAG(PT_UNICODE, 0x7002), /* PidTagViewDescriptorStrings */
	// PR_VD_NAME = PROP_TAG(PT_UNICODE, 0x7006), /* PidTagViewDescriptorName */
	// PR_VD_VERSION = PROP_TAG(PT_LONG, 0x7007), /* PidTagViewDescriptorVersion */
	// PR_FAV_DISPLAY_NAME = PROP_TAG(PT_UNICODE, 0x7C00),
	// PR_FAV_DISPLAY_ALIAS = PROP_TAG(PT_UNICODE, 0x7C01),
	// PR_FAV_PUBLIC_SOURCE_KEY = PROP_TAG(PT_BINARY, 0x7C02),
	PR_OST_OSTID = PROP_TAG(PT_BINARY, 0x7C04),
	// PR_OFFLINE_FOLDER = PROP_TAG(PT_BINARY, 0x7C05),
	// PR_ROAMING_DATATYPES = PROP_TAG(PT_LONG, 0x7C06), /* PidTagRoamingDatatypes */
	// PR_ROAMING_DICTIONARY = PROP_TAG(PT_BINARY, 0x7C07), /* PidTagRoamingDictionary */
	// PR_ROAMING_XMLSTREAM  = PROP_TAG(PT_BINARY, 0x7C08), /* PidTagRoamingXmlStream */
	// PR_ROAMING_BINARYSTREAM = PROP_TAG(PT_BINARY, 0x7C09), /* PidTagRoamingBinary */
	// PR_STORE_SLOWLINK = PROP_TAG(PT_BOOLEAN, 0x7C0A),
	// PR_OSC_SYNC_ENABLEDONSERVER = PROP_TAG(PT_BOOLEAN, 0x7C24), /* PidTagOscSyncEnabled */
	// PR_FORCE_USE_ENTRYID_SERVER = PROP_TAG(PT_BOOLEAN, 0x7CFE),
	// PR_PROFILE_MDB_DN = PROP_TAG(PT_STRING8, 0x7CFF),
	// PR_FAV_AUTOSUBFOLDERS = PROP_TAG(PT_LONG, 0x7D01),
	PR_PROCESSED = PROP_TAG(PT_BOOLEAN, 0x7D01), /* PidTagProcessed */
	// PR_FAV_PARENT_SOURCE_KEY = PROP_TAG(PT_BINARY, 0x7D02),
	// PR_FAV_LEVEL_MASK = PROP_TAG(PT_LONG, 0x7D03),
	// PR_FAV_KNOWN_SUBS = PROP_TAG(PT_BINARY, 0x7D04),
	// PR_FAV_GUID_MAP = PROP_TAG(PT_BINARY, 0x7D05),
	// PR_FAV_KNOWN_DELS_OLD = PROP_TAG(PT_BINARY, 0x7D06),
	// PR_FAV_INHERIT_AUTO = PROP_TAG(PT_LONG, 0x7D07),
	// PR_FAV_DEL_SUBS = PROP_TAG(PT_BINARY, 0x7D08),
	// PR_FAV_CONTAINER_CLASS = PROP_TAG(PT_UNICODE, 0x7D09),
	// PR_EXCEPTION_REPLACETIME = PROP_TAG(PT_SYSTIME, 0x7FF9), /* PidTagExceptionReplaceTime */
	PR_ATTACHMENT_LINKID = PROP_TAG(PT_LONG, 0x7FFA), /* PidTagAttachmentLinkId */
	PR_EXCEPTION_STARTTIME = PROP_TAG(PT_SYSTIME, 0x7FFB), /* PidTagExceptionStartTime */
	PR_EXCEPTION_ENDTIME = PROP_TAG(PT_SYSTIME, 0x7FFC), /* PidTagExceptionEndTime */
	PR_ATTACHMENT_FLAGS = PROP_TAG(PT_LONG, 0x7FFD), /* PidTagAttachmentFlags */
	PR_ATTACHMENT_HIDDEN = PROP_TAG(PT_BOOLEAN, 0x7FFE), /* PidTagAttachmentHidden */
	PR_ATTACHMENT_CONTACTPHOTO = PROP_TAG(PT_BOOLEAN, 0x7FFF), /* PidTagAttachmentContactPhoto */
	// PR_EMS_AB_FOLDER_PATHNAME = PROP_TAG(PT_UNICODE, 0x8004), /* PidTagAddressBookFolderPathname */
	// PR_EMS_AB_MANAGER = PROP_TAG(PT_OBJECT, 0x8005), /* PidTagAddressBookManager */
	// PR_EMS_AB_MANAGER_T = PROP_TAG(PT_UNICODE, 0x8005), /* PidTagAddressBookManagerDistinguishedName */
	PR_EMS_AB_HOME_MDB = PROP_TAG(PT_UNICODE, 0x8006), /* PidTagAddressBookHomeMessageDatabase */
	PR_EMS_AB_HOME_MDB_A = PROP_TAG(PT_STRING8, 0x8006),
	// PR_EMS_AB_IS_MEMBER_OF_DL = PROP_TAG(PT_STRING8, 0x8008), /* PidTagAddressBookIsMemberOfDistributionList */
	PR_EMS_AB_MEMBER = PROP_TAG(PT_OBJECT, 0x8009), /* PidTagAddressBookMember */
	// PR_EMS_AB_OWNER = PROP_TAG(PT_BINARY, 0x800C),
	// PR_EMS_AB_OWNER_O = PROP_TAG(PT_OBJECT, 0x800C), /* PidTagAddressBookOwner */
	// PR_EMS_AB_REPORTS = PROP_TAG(PT_OBJECT, 0x800E), /* PidTagAddressBookReports */
	// PR_EMS_AB_REPORTS_MV = PROP_TAG(PT_MV_BINARY, 0x800E),
	PR_EMS_AB_PROXY_ADDRESSES = PROP_TAG(PT_MV_UNICODE, 0x800F), /* PidTagEmsAbProxyAddresses, PidTagAddressBookProxyAddresses */
	PR_EMS_AB_PROXY_ADDRESSES_A = PROP_TAG(PT_MV_STRING8, 0x800F),
	// PR_EMS_AB_PROXY_ADDRESSES_MV = PROP_TAG(PT_MV_UNICODE, 0x800F),
	// PR_EMS_AB_TARGET_ADDRESS = PROP_TAG(PT_UNICODE, 0x8011), /* PidTagAddressBookTargetAddress */
	PR_EMS_AB_PUBLIC_DELEGATES = PROP_TAG(PT_OBJECT, 0x8015), /* PidTagAddressBookPublicDelegates */
	// PR_EMS_AB_OWNER_BL_O = PROP_TAG(PT_OBJECT, 0x8024), /* PidTagAddressBookOwnerBackLink */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_1 = PROP_TAG(PT_UNICODE, 0x802D), /* PidTagAddressBookExtensionAttribute1 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_2 = PROP_TAG(PT_UNICODE, 0x802E), /* PidTagAddressBookExtensionAttribute2 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_3 = PROP_TAG(PT_UNICODE, 0x802F), /* PidTagAddressBookExtensionAttribute3 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_4 = PROP_TAG(PT_UNICODE, 0x8030), /* PidTagAddressBookExtensionAttribute4 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_5 = PROP_TAG(PT_UNICODE, 0x8031), /* PidTagAddressBookExtensionAttribute5 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_6 = PROP_TAG(PT_UNICODE, 0x8032), /* PidTagAddressBookExtensionAttribute6 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_7 = PROP_TAG(PT_UNICODE, 0x8033), /* PidTagAddressBookExtensionAttribute7 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_8 = PROP_TAG(PT_UNICODE, 0x8034), /* PidTagAddressBookExtensionAttribute8 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_9 = PROP_TAG(PT_UNICODE, 0x8035), /* PidTagAddressBookExtensionAttribute9 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_10 = PROP_TAG(PT_UNICODE, 0x8036), /* PidTagAddressBookExtensionAttribute10 */
	// PR_EMS_AB_OBJ_DIST_NAME = PROP_TAG(PT_UNICODE, 0x803C), /* PidTagAddressBookObjectDistinguishedName */
	// PR_EMS_AB_DELIV_CONT_LENGTH = PROP_TAG(PT_LONG, 0x806A), /* PidTagAddressBookDeliveryContentLength */
	// PR_EMS_AB_DL_MEM_SUBMIT_PERMS_BL_O = PROP_TAG(PT_OBJECT, 0x8073), /* PidTagAddressBookDistributionListMemberSubmitAccepted */
	PR_EMS_AB_NETWORK_ADDRESS = PROP_TAG(PT_MV_UNICODE, 0x8170), /* PidTagAddressBookNetworkAddress */
	PR_EMS_AB_NETWORK_ADDRESS_A = PROP_TAG(PT_MV_STRING8, 0x8170),
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_11 = PROP_TAG(PT_UNICODE, 0x8C57), /* PidTagAddressBookExtensionAttribute11 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_12 = PROP_TAG(PT_UNICODE, 0x8C58), /* PidTagAddressBookExtensionAttribute12 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_13 = PROP_TAG(PT_UNICODE, 0x8C59), /* PidTagAddressBookExtensionAttribute13 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_14 = PROP_TAG(PT_UNICODE, 0x8C60), /* PidTagAddressBookExtensionAttribute14 */
	// PR_EMS_AB_EXTENSION_ATTRIBUTE_15 = PROP_TAG(PT_UNICODE, 0x8C61), /* PidTagAddressBookExtensionAttribute15 */
	// PR_EMS_AB_X509_CERT = PROP_TAG(PT_MV_BINARY, 0x8C6A), /* PidTagAddressBookX509Certificate */
	PR_EMS_AB_OBJECT_GUID = PROP_TAG(PT_BINARY, 0x8C6D), /* PidTagAddressBookObjectGuid */
	// ? = PROP_TAG(PT_BINARY, 0x8C73), /* contains Mailbox GUID */
	// PR_EMS_AB_PHONETIC_GIVEN_NAME = PROP_TAG(PT_UNICODE, 0x8C8E), /* PidTagAddressBookPhoneticGivenName */
	// PR_EMS_AB_PHONETIC_SURNAME = PROP_TAG(PT_UNICODE, 0x8C8F), /* PidTagAddressBookPhoneticSurname */
	// PR_EMS_AB_PHONETIC_DEPARTMENT_NAME = PROP_TAG(PT_UNICODE, 0x8C90), /* PidTagAddressBookPhoneticDepartmentName */
	// PR_EMS_AB_PHONETIC_COMPANY_NAME = PROP_TAG(PT_UNICODE, 0x8C91), /* PidTagAddressBookPhoneticCompanyName */
	PR_EMS_AB_PHONETIC_DISPLAY_NAME = PROP_TAG(PT_UNICODE, 0x8C92), /* PidTagAddressBookPhoneticDisplayName */
	PR_EMS_AB_PHONETIC_DISPLAY_NAME_A = PROP_TAG(PT_STRING8, 0x8C92),
	// PR_EMS_AB_DISPLAY_TYPE_EX = PROP_TAG(PT_LONG, 0x8C93), /* PidTagAddressBookDisplayTypeExtended */
	// PR_EMS_AB_HAB_SHOW_IN_DEPARTMENTS = PROP_TAG(PT_OBJECT, 0x8C94), /* PidTagAddressBookHierarchicalShowInDepartments */
	// PR_EMS_AB_ROOM_CONTAINERS = PROP_TAG(PT_MV_UNICODE, 0x8C96), /* PidTagAddressBookRoomContainers */
	// PR_EMS_AB_HAB_DEPARTMENT_MEMBERS = PROP_TAG(PT_OBJECT, 0x8C97), /* PidTagAddressBookHierarchicalDepartmentMembers */
	// PR_EMS_AB_HAB_ROOT_DEPARTMENT = PROP_TAG(PT_STRING8, 0x8C98), /* PidTagAddressBookHierarchicalRootDepartment */
	// PR_EMS_AB_HAB_PARENT_DEPARTMENT = PROP_TAG(PT_OBJECT, 0x8C99), /* PidTagAddressBookHierarchicalParentDepartment */
	// PR_EMS_AB_HAB_CHILD_DEPARTMENTS = PROP_TAG(PT_OBJECT, 0x8C9A), /* PidTagAddressBookHierarchicalChildDepartments */
	PR_EMS_AB_THUMBNAIL_PHOTO = PROP_TAG(PT_BINARY, 0x8C9E), /* PidTagThumbnailPhoto */
	// PR_EMS_AB_HAB_SENIORITY_INDEX = PROP_TAG(PT_LONG, 0x8CA0), /* PidTagAddressBookSeniorityIndex */
	// PR_EMS_AB_ORG_UNIT_ROOT_DN = PROP_TAG(PT_UNICODE, 0x8CA8), /* PidTagAddressBookOrganizationalUnitRootDistinguishedName */
	// PR_EMS_AB_DL_SENDER_HINT_TRANSLATIONS = PROP_TAG(PT_MV_UNICODE, 0x8CAC), /* PidTagAddressBookSenderHintTranslations */
	// PR_EMS_AB_ENABLE_MODERATION = PROP_TAG(PT_BOOLEAN, 0x8CB5), /* PidTagAddressBookModerationEnabled */
	// PR_EMS_AB_UM_SPOKEN_NAME = PROP_TAG(PT_BINARY, 0x8CC2), /* PidTagSpokenName */
	// PR_EMS_AB_AUTH_ORIG = PROP_TAG(PT_OBJECT, 0x8CD8), /* PidTagAddressBookAuthorizedSenders */
	// PR_EMS_AB_UNAUTH_ORIG = PROP_TAG(PT_OBJECT, 0x8CD9), /* PidTagAddressBookUnauthorizedSenders */
	// PR_EMS_AB_DL_MEM_SUBMIT_PERMS = PROP_TAG(PT_OBJECT, 0x8CDA), /* PidTagAddressBookDistributionListMemberSubmitRejected */
	// PR_EMS_AB_DL_MEM_REJECT_PERMS = PROP_TAG(PT_OBJECT, 0x8CDB), /* PidTagAddressBookDistributionListRejectMessagesFromDLMembers */
	// PR_EMS_AB_HAB_IS_HIERARCHICAL_GROUP = PROP_TAG(PT_BOOLEAN, 0x8CDD), /* PidTagAddressBookHierarchicalIsHierarchicalGroup */
	// PR_EMS_AB_DL_TOTAL_MEMBER_COUNT = PROP_TAG(PT_LONG, 0x8CE2), /* PidTagAddressBookDistributionListMemberCount */
	// PR_EMS_AB_DL_EXTERNAL_MEMBER_COUNT = PROP_TAG(PT_LONG, 0x8CE3), /* PidTagAddressBookDistributionListExternalMemberCount */
	PR_EMS_AB_IS_MASTER = PROP_TAG(PT_BOOLEAN, 0xFFFB), /* PidTagAddressBookIsMaster */
	PR_EMS_AB_PARENT_ENTRYID = PROP_TAG(PT_BINARY, 0xFFFC), /* PidTagAddressBookParentEntryId */
	PR_EMS_AB_CONTAINERID = PROP_TAG(PT_LONG, 0xFFFD), /* PidTagAddressBookContainerId */
};
}

enum {
	PidLidCategories = 0x2328,

	/* PSETID_Address */
	PidLidFileAs = 0x8005,
	PidLidHomeAddress = 0x801a,
	PidLidBusinessAddress = 0x801b,
	PidLidOtherAddress = 0x801c,
	PidLidMailingAdress = 0x8022,  // PT_UNICODE
	PidLidPostalAddressIndex = 0x8022, // PT_LONG
	dispidEmailList = 0x8027,
	PidLidBusinessCardDisplayDefinition = 0x8040,
	PidLidWorkAddressStreet = 0x8045,
	PidLidWorkAddressCity = 0x8046,
	PidLidWorkAddressState = 0x8047,
	PidLidWorkAddressPostalCode = 0x8048,
	PidLidWorkAddressCountry = 0x8049,
	PidLidWorkAddressPostOfficeBox = 0x804A,
	PidLidContactUserField1 = 0x804F,
	PidLidContactUserField2 = 0x8050,
	PidLidContactUserField3 = 0x8051,
	PidLidContactUserField4 = 0x8052,
	PidLidInstantMessagingAddress = 0x8062,
	PidLidEmail1DisplayName = 0x8080,
	PidLidEmail1AddressType = 0x8082,
	PidLidEmail1EmailAddress = 0x8083,
	PidLidEmail2DisplayName = 0x8090,
	PidLidEmail2AddressType = 0x8092,
	PidLidEmail2EmailAddress = 0x8093,
	PidLidEmail3DisplayName = 0x80A0,
	PidLidEmail3AddressType = 0x80A2,
	PidLidEmail3EmailAddress = 0x80A3,
	PidLidFreeBusyLocation = 0x80D8,

	/* PSETID_Task */
	PidLidTaskStatus = 0x8101,
	PidLidPercentComplete = 0x8102,
	PidLidTaskStartDate = 0x8104,
	PidLidTaskDueDate = 0x8105,
	PidLidTaskDateCompleted = 0x810F,
	PidLidTaskActualEffort = 0x8110,
	PidLidTaskEstimatedEffort = 0x8111,
	PidLidTaskRecurrence = 0x8116,
	PidLidTaskComplete = 0x811C,
	PidLidTaskOwner = 0x811F,
	PidLidTaskFRecurring = 0x8126,

	/* PSETID_Appointment */
	PidLidSendMeetingAsIcal = 0x8200,
	PidLidAppointmentSequence = 0x8201,
	PidLidBusyStatus = 0x8205,
	PidLidLocation = 0x8208,
	PidLidAppointmentStartWhole = 0x820D,
	PidLidAppointmentEndWhole = 0x820E,
	PidLidAppointmentDuration = 0x8213,
	PidLidAppointmentSubType = 0x8215,
	PidLidAppointmentRecur = 0x8216,
	PidLidAppointmentStateFlags = 0x8217,
	PidLidResponseStatus = 0x8218,
	PidLidAppointmentReplyTime = 0x8220,
	PidLidRecurring = 0x8223, /* this object is a recurring series */
	PidLidIntendedBusyStatus = 0x8224,
	PidLidExceptionReplaceTime = 0x8228,
	PidLidFInvited = 0x8229,
	PidLidAppointmentReplyName = 0x8230,
	PidLidRecurrenceType = 0x8231,
	PidLidRecurrencePattern = 0x8232,
	PidLidTimeZoneStruct = 0x8233,
	PidLidTimeZoneDescription = 0x8234,
	PidLidClipStart = 0x8235,
	PidLidClipEnd = 0x8236,
	PidLidAllAttendeesString = 0x8238,
	PidLidToAttendeesString = 0x823B,
	PidLidCcAttendeesString = 0x823C,
	PidLidAppointmentProposedStartWhole = 0x8250,
	PidLidAppointmentProposedEndWhole = 0x8251,
	PidLidAppointmentCounterProposal = 0x8257,
	PidLidAppointmentNotAllowPropose = 0x825A,
	PidLidAppointmentTimeZoneDefinitionStartDisplay = 0x825E,
	PidLidAppointmentTimeZoneDefinitionEndDisplay = 0x825F,
	PidLidAppointmentTimeZoneDefinitionRecur = 0x8260,

	/* PSETID_Meeting */
	PidLidAttendeeCriticalChange = 0x0001,
	PidLidWhere = 0x0002,
	PidLidGlobalObjectId = 0x0003, /* a.k.a. LID_GLOBAL_OBJID */
	PidLidIsSilent = 0x0004,
	PidLidIsRecurring = 0x0005, /* object is associated with a recurring series object */
	PidLidIsException = 0x000A,
	PidLidTimeZone = 0x000C,
	PidLidStartRecurrenceTime = 0x000E,
	PidLidMonthOfYearMask = 0x0017,
	PidLidOwnerCriticalChange = 0x001A,
	PidLidCleanGlobalObjectId = 0x0023,
	PidLidMeetingType = 0x0026,

	/* PSETID_Common */
	PidLidReminderDelta = 0x8501,
	PidLidReminderTime = 0x8502,
	PidLidReminderSet = 0x8503,
	PidLidPrivate = 0x8506,
	PidLidSideEffects = 0x8510,
	PidLidSmartNoAttach = 0x8514,
	PidLidCommonStart = 0x8516,
	PidLidCommonEnd = 0x8517,
	PidLidTaskMode = 0x8518,
	PidLidFlagRequest = 0x8530,
	PidLidMileage = 0x8534, // not in ms-oxprops
	PidLidBilling = 0x8535,
	PidLidCompanies = 0x8539,
	PidLidReminderSignalTime = 0x8560,
	PidLidToDoTitle = 0x85A4,
	PidLidInfoPathFromName = 0x85B1,
	// ? = 0x85B3, /* some codepage identifier (PSETID_Common) */
	PidLidClassified = 0x85B5,
	PidLidClassification = 0x85B6,
	PidLidClassificationDescription = 0x85B7,
	PidLidClassificationGuid = 0x85B8,
	PidLidClassificationKeep = 0x85BA,
	PROP_ID_INVALID = 0xFFFF,
};
