// SPDX-License-Identifier: AGPL-3.0-or-later, OR GPL-2.0-or-later WITH linking exception
// SPDX-FileCopyrightText: 2020–2021 grommunio GmbH
// This file is part of Gromox.
#include <gromox/defs.h>
#include "rop_ids.hpp"

using namespace gromox;

//define E(s) static_cast<unsigned int>(s)] = #s
#define E(s) (static_cast<void>(s), #s)
static constexpr const char *rop_names[256] = {
	{},
	E(ropRelease),
	E(ropOpenFolder),
	E(ropOpenMessage),
	E(ropGetHierarchyTable),
	E(ropGetContentsTable),
	E(ropCreateMessage),
	E(ropGetPropertiesSpecific),
	E(ropGetPropertiesAll),
	E(ropGetPropertiesList),
	E(ropSetProperties),
	E(ropDeleteProperties),
	E(ropSaveChangesMessage),
	E(ropRemoveAllRecipients),
	E(ropModifyRecipients),
	E(ropReadRecipients),
	E(ropReloadCachedInformation),
	E(ropSetMessageReadFlag),
	E(ropSetColumns),
	E(ropSortTable),
	E(ropRestrict),
	E(ropQueryRows),
	E(ropGetStatus),
	E(ropQueryPosition),
	E(ropSeekRow),
	E(ropSeekRowBookmark),
	E(ropSeekRowFractional),
	E(ropCreateBookmark),
	E(ropCreateFolder),
	E(ropDeleteFolder),
	E(ropDeleteMessages),
	E(ropGetMessageStatus),
	E(ropSetMessageStatus),
	E(ropGetAttachmentTable),
	E(ropOpenAttachment),
	E(ropCreateAttachment),
	E(ropDeleteAttachment),
	E(ropSaveChangesAttachment),
	E(ropSetReceiveFolder),
	E(ropGetReceiveFolder),
	/* 0x28 */ {},
	E(ropRegisterNotification),
	E(ropNotify),
	E(ropOpenStream),
	E(ropReadStream),
	E(ropWriteStream),
	E(ropSeekStream),
	E(ropSetStreamSize),
	E(ropSetSearchCriteria),
	E(ropGetSearchCriteria),
	E(ropSubmitMessage),
	E(ropMoveCopyMessages),
	E(ropAbortSubmit),
	E(ropMoveFolder),
	E(ropCopyFolder),
	E(ropQueryColumnsAll),
	E(ropAbort),
	E(ropCopyTo),
	E(ropCopyToStream),
	E(ropCloneStream),
	/* 0x3C-0x3D */ {}, {},
	E(ropGetPermissionsTable),
	E(ropGetRulesTable),
	E(ropModifyPermissions),
	E(ropModifyRules),
	E(ropGetOwningServers),
	E(ropLongTermIdFromId),
	E(ropIdFromLongTermId),
	E(ropPublicFolderIsGhosted),
	E(ropOpenEmbeddedMessage),
	E(ropSetSpooler),
	E(ropSpoolerLockMessage),
	E(ropGetAddressTypes),
	E(ropTransportSend),
	E(ropFastTransferSourceCopyMessages),
	E(ropFastTransferSourceCopyFolder),
	E(ropFastTransferSourceCopyTo),
	E(ropFastTransferSourceGetBuffer),
	E(ropFindRow),
	E(ropProgress),
	E(ropTransportNewMail),
	E(ropGetValidAttachments),
	E(ropFastTransferDestinationConfigure),
	E(ropFastTransferDestinationPutBuffer),
	E(ropGetNamesFromPropertyIds),
	E(ropGetPropertyIdsFromNames),
	E(ropUpdateDeferredActionMessages),
	E(ropEmptyFolder),
	E(ropExpandRow),
	E(ropCollapseRow),
	E(ropLockRegionStream),
	E(ropUnlockRegionStream),
	E(ropCommitStream),
	E(ropGetStreamSize),
	E(ropQueryNamedProperties),
	E(ropGetPerUserLongTermIds),
	E(ropGetPerUserGuid),
	/* 0x62 */ {},
	E(ropReadPerUserInformation),
	E(ropWritePerUserInformation),
	/* 0x65 */ {},
	E(ropSetReadFlags),
	E(ropCopyProperties),
	E(ropGetReceiveFolderTable),
	E(ropFastTransferSourceCopyProperties),
	/* 0x6A */ {},
	E(ropGetCollapseState),
	E(ropSetCollapseState),
	E(ropGetTransportFolder),
	E(ropPending),
	E(ropOptionsData),
	E(ropSynchronizationConfigure),
	/* 0x71 */ {},
	E(ropSynchronizationImportMessageChange),
	E(ropSynchronizationImportHierarchyChange),
	E(ropSynchronizationImportDeletes),
	E(ropSynchronizationUploadStateStreamBegin),
	E(ropSynchronizationUploadStateStreamContinue),
	E(ropSynchronizationUploadStateStreamEnd),
	E(ropSynchronizationImportMessageMove),
	E(ropSetPropertiesNoReplicate),
	E(ropDeletePropertiesNoReplicate),
	E(ropGetStoreState),
	/* 0x7C-0x7D */ {}, {},
	E(ropSynchronizationOpenCollector),
	E(ropGetLocalReplicaIds),
	E(ropSynchronizationImportReadStateChanges),
	E(ropResetTable),
	E(ropSynchronizationGetTransferState),
	E(ropSynchronizationOpenAdvisor),
	E(ropRegisterSynchronizationNotifications),
	/* 0x85 */ {},
	E(ropTellVersion),
	E(ropOpenPublicFolderByName),
	E(ropSetSynchronizationNotificationGuid),
	E(ropFreeBookmark),
	E(ropDeletePublicFolderByName),
	/* 0x8B-0x8F */ {}, {}, {}, {}, {},
	E(ropWriteAndCommitStream),
	E(ropHardDeleteMessages),
	E(ropHardDeleteMessagesAndSubfolders),
	E(ropSetLocalReplicaMidsetDeleted),
	/* 0x94-0x9F */ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {},
	/* 0xA0-0xAF */ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {},
	/* 0xB0-0xBF */ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {},
	/* 0xC0-0xCF */ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {},
	/* 0xD0-0xDF */ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {},
	/* 0xE0-0xEF */ {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {},
	/* 0xF0-0xF8 */ {}, {}, {}, {}, {}, {}, {}, {}, {},
	E(ropBackoff),
	/* 0xFA-0xFD */ {}, {}, {}, {},
	E(ropLogon),
	E(ropBufferTooSmall),
};
#undef E

const char *rop_idtoname(unsigned int i)
{
	auto s = i < std::size(rop_names) ? rop_names[i] : nullptr;
	return znul(s);
}
