#include <cstring>
#include <utility>
#include <gromox/exmdb_client.hpp>
#include <gromox/exmdb_rpc.hpp>
using namespace gromox;
BOOL exmdb_client_remote::ping_store(const char *dir)
{
	exreq_ping_store::view_t q{};
	exresp_ping_store r{};

	q.call_id = exmdb_callid::ping_store;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_all_named_propids(const char *dir, PROPID_ARRAY *propids)
{
	exreq_get_all_named_propids::view_t q{};
	exresp_get_all_named_propids r{};

	q.call_id = exmdb_callid::get_all_named_propids;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propids != nullptr)
		*propids = std::move(r.propids);
	return TRUE;
}

BOOL exmdb_client_remote::get_named_propids(const char *dir, BOOL b_create, const PROPNAME_ARRAY *ppropnames, PROPID_ARRAY *propids)
{
	exreq_get_named_propids::view_t q{};
	exresp_get_named_propids r{};

	q.call_id = exmdb_callid::get_named_propids;
	q.dir = deconst(dir);
	q.b_create = b_create;
	q.ppropnames = deconst(ppropnames);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propids != nullptr)
		*propids = std::move(r.propids);
	return TRUE;
}

BOOL exmdb_client_remote::get_named_propnames(const char *dir, const PROPID_ARRAY &ppropids, PROPNAME_ARRAY *propnames)
{
	exreq_get_named_propnames::view_t q{};
	exresp_get_named_propnames r{};

	q.call_id = exmdb_callid::get_named_propnames;
	q.dir = deconst(dir);
	q.ppropids = ppropids;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propnames != nullptr)
		*propnames = std::move(r.propnames);
	return TRUE;
}

BOOL exmdb_client_remote::get_mapping_guid(const char *dir, uint16_t replid, BOOL *b_found, GUID *guid)
{
	exreq_get_mapping_guid::view_t q{};
	exresp_get_mapping_guid r{};

	q.call_id = exmdb_callid::get_mapping_guid;
	q.dir = deconst(dir);
	q.replid = replid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_found != nullptr)
		*b_found = std::move(r.b_found);
	if (guid != nullptr)
		*guid = std::move(r.guid);
	return TRUE;
}

BOOL exmdb_client_remote::get_mapping_replid(const char *dir, GUID guid, uint16_t *replid, ec_error_t *e_result)
{
	exreq_get_mapping_replid::view_t q{};
	exresp_get_mapping_replid r{};

	q.call_id = exmdb_callid::get_mapping_replid;
	q.dir = deconst(dir);
	q.guid = guid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (replid != nullptr)
		*replid = std::move(r.replid);
	if (e_result != nullptr)
		*e_result = std::move(r.e_result);
	return TRUE;
}

BOOL exmdb_client_remote::get_store_all_proptags(const char *dir, PROPTAG_ARRAY *proptags)
{
	exreq_get_store_all_proptags::view_t q{};
	exresp_get_store_all_proptags r{};

	q.call_id = exmdb_callid::get_store_all_proptags;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	return TRUE;
}

BOOL exmdb_client_remote::get_store_properties(const char *dir, cpid_t cpid, proptag_cspan pproptags, TPROPVAL_ARRAY *propvals)
{
	exreq_get_store_properties::view_t q{};
	exresp_get_store_properties r{};

	q.call_id = exmdb_callid::get_store_properties;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::set_store_properties(const char *dir, cpid_t cpid, const TPROPVAL_ARRAY *ppropvals, PROBLEM_ARRAY *problems)
{
	exreq_set_store_properties::view_t q{};
	exresp_set_store_properties r{};

	q.call_id = exmdb_callid::set_store_properties;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.ppropvals = deconst(ppropvals);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::remove_store_properties(const char *dir, proptag_cspan pproptags)
{
	exreq_remove_store_properties::view_t q{};
	exresp_remove_store_properties r{};

	q.call_id = exmdb_callid::remove_store_properties;
	q.dir = deconst(dir);
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_mbox_perm(const char *dir, const char *username, uint32_t *permission)
{
	exreq_get_mbox_perm::view_t q{};
	exresp_get_mbox_perm r{};

	q.call_id = exmdb_callid::get_mbox_perm;
	q.dir = deconst(dir);
	q.username = deconst(username);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (permission != nullptr)
		*permission = std::move(r.permission);
	return TRUE;
}

BOOL exmdb_client_remote::get_folder_by_class(const char *dir, const char *str_class, uint64_t *id, std::string *str_explicit)
{
	exreq_get_folder_by_class::view_t q{};
	exresp_get_folder_by_class r{};

	q.call_id = exmdb_callid::get_folder_by_class;
	q.dir = deconst(dir);
	q.str_class = deconst(str_class);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (id != nullptr)
		*id = std::move(r.id);
	if (str_explicit != nullptr)
		*str_explicit = std::move(r.str_explicit);
	return TRUE;
}

BOOL exmdb_client_remote::set_folder_by_class(const char *dir, uint64_t folder_id, const char *str_class, BOOL *b_result)
{
	exreq_set_folder_by_class::view_t q{};
	exresp_set_folder_by_class r{};

	q.call_id = exmdb_callid::set_folder_by_class;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.str_class = deconst(str_class);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::get_folder_class_table(const char *dir, TARRAY_SET *table)
{
	exreq_get_folder_class_table::view_t q{};
	exresp_get_folder_class_table r{};

	q.call_id = exmdb_callid::get_folder_class_table;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (table != nullptr)
		*table = std::move(r.table);
	return TRUE;
}

BOOL exmdb_client_remote::is_folder_present(const char *dir, uint64_t folder_id, BOOL *b_exist)
{
	exreq_is_folder_present::view_t q{};
	exresp_is_folder_present r{};

	q.call_id = exmdb_callid::is_folder_present;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_exist != nullptr)
		*b_exist = std::move(r.b_exist);
	return TRUE;
}

BOOL exmdb_client_remote::is_folder_deleted(const char *dir, uint64_t folder_id, BOOL *b_del)
{
	exreq_is_folder_deleted::view_t q{};
	exresp_is_folder_deleted r{};

	q.call_id = exmdb_callid::is_folder_deleted;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_del != nullptr)
		*b_del = std::move(r.b_del);
	return TRUE;
}

BOOL exmdb_client_remote::get_folder_by_name(const char *dir, uint64_t parent_id, const char *str_name, uint64_t *folder_id)
{
	exreq_get_folder_by_name::view_t q{};
	exresp_get_folder_by_name r{};

	q.call_id = exmdb_callid::get_folder_by_name;
	q.dir = deconst(dir);
	q.parent_id = parent_id;
	q.str_name = deconst(str_name);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (folder_id != nullptr)
		*folder_id = std::move(r.folder_id);
	return TRUE;
}

BOOL exmdb_client_remote::get_folder_perm(const char *dir, uint64_t folder_id, const char *username, uint32_t *permission)
{
	exreq_get_folder_perm::view_t q{};
	exresp_get_folder_perm r{};

	q.call_id = exmdb_callid::get_folder_perm;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.username = deconst(username);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (permission != nullptr)
		*permission = std::move(r.permission);
	return TRUE;
}

BOOL exmdb_client_remote::create_folder_v1(const char *dir, cpid_t cpid, const TPROPVAL_ARRAY *pproperties, uint64_t *folder_id)
{
	exreq_create_folder_v1::view_t q{};
	exresp_create_folder_v1 r{};

	q.call_id = exmdb_callid::create_folder_v1;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.pproperties = deconst(pproperties);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (folder_id != nullptr)
		*folder_id = std::move(r.folder_id);
	return TRUE;
}

BOOL exmdb_client_remote::create_folder(const char *dir, cpid_t cpid, const TPROPVAL_ARRAY *pproperties, uint64_t *folder_id, ec_error_t *e_result)
{
	exreq_create_folder::view_t q{};
	exresp_create_folder r{};

	q.call_id = exmdb_callid::create_folder;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.pproperties = deconst(pproperties);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (folder_id != nullptr)
		*folder_id = std::move(r.folder_id);
	if (e_result != nullptr)
		*e_result = std::move(r.e_result);
	return TRUE;
}

BOOL exmdb_client_remote::get_folder_all_proptags(const char *dir, uint64_t folder_id, PROPTAG_ARRAY *proptags)
{
	exreq_get_folder_all_proptags::view_t q{};
	exresp_get_folder_all_proptags r{};

	q.call_id = exmdb_callid::get_folder_all_proptags;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	return TRUE;
}

BOOL exmdb_client_remote::get_folder_properties(const char *dir, cpid_t cpid, uint64_t folder_id, proptag_cspan pproptags, TPROPVAL_ARRAY *propvals)
{
	exreq_get_folder_properties::view_t q{};
	exresp_get_folder_properties r{};

	q.call_id = exmdb_callid::get_folder_properties;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::set_folder_properties(const char *dir, cpid_t cpid, uint64_t folder_id, const TPROPVAL_ARRAY *pproperties, PROBLEM_ARRAY *problems)
{
	exreq_set_folder_properties::view_t q{};
	exresp_set_folder_properties r{};

	q.call_id = exmdb_callid::set_folder_properties;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.pproperties = deconst(pproperties);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::remove_folder_properties(const char *dir, uint64_t folder_id, proptag_cspan pproptags)
{
	exreq_remove_folder_properties::view_t q{};
	exresp_remove_folder_properties r{};

	q.call_id = exmdb_callid::remove_folder_properties;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::delete_folder(const char *dir, cpid_t cpid, uint64_t folder_id, BOOL b_hard, BOOL *b_result)
{
	exreq_delete_folder::view_t q{};
	exresp_delete_folder r{};

	q.call_id = exmdb_callid::delete_folder;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.b_hard = b_hard;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::empty_folder(const char *dir, cpid_t cpid, const char *username, uint64_t folder_id, uint32_t flags, BOOL *b_partial)
{
	exreq_empty_folder::view_t q{};
	exresp_empty_folder r{};

	q.call_id = exmdb_callid::empty_folder;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.username = deconst(username);
	q.folder_id = folder_id;
	q.flags = flags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_partial != nullptr)
		*b_partial = std::move(r.b_partial);
	return TRUE;
}

BOOL exmdb_client_remote::is_descendant_folder(const char *dir, uint64_t parent_fid, uint64_t child_fid, BOOL *b_included)
{
	exreq_is_descendant_folder::view_t q{};
	exresp_is_descendant_folder r{};

	q.call_id = exmdb_callid::is_descendant_folder;
	q.dir = deconst(dir);
	q.parent_fid = parent_fid;
	q.child_fid = child_fid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_included != nullptr)
		*b_included = std::move(r.b_included);
	return TRUE;
}

BOOL exmdb_client_remote::copy_folder_internal(const char *dir, cpid_t cpid, BOOL b_guest, const char *username, uint64_t src_fid, BOOL b_normal, BOOL b_fai, BOOL b_sub, uint64_t dst_fid, BOOL *b_collid, BOOL *b_partial)
{
	exreq_copy_folder_internal::view_t q{};
	exresp_copy_folder_internal r{};

	q.call_id = exmdb_callid::copy_folder_internal;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.b_guest = b_guest;
	q.username = deconst(username);
	q.src_fid = src_fid;
	q.b_normal = b_normal;
	q.b_fai = b_fai;
	q.b_sub = b_sub;
	q.dst_fid = dst_fid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_collid != nullptr)
		*b_collid = std::move(r.b_collid);
	if (b_partial != nullptr)
		*b_partial = std::move(r.b_partial);
	return TRUE;
}

BOOL exmdb_client_remote::get_search_criteria(const char *dir, uint64_t folder_id, uint32_t *search_status, RESTRICTION **prestriction, EID_ARRAY *folder_ids)
{
	exreq_get_search_criteria::view_t q{};
	exresp_get_search_criteria r{};

	q.call_id = exmdb_callid::get_search_criteria;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (search_status != nullptr)
		*search_status = std::move(r.search_status);
	if (prestriction != nullptr)
		*prestriction = std::move(r.prestriction);
	if (folder_ids != nullptr)
		*folder_ids = std::move(r.folder_ids);
	return TRUE;
}

BOOL exmdb_client_remote::set_search_criteria(const char *dir, cpid_t cpid, uint64_t folder_id, uint32_t search_flags, const RESTRICTION *prestriction, const EID_ARRAY *pfolder_ids, BOOL *b_result)
{
	exreq_set_search_criteria::view_t q{};
	exresp_set_search_criteria r{};

	q.call_id = exmdb_callid::set_search_criteria;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.search_flags = search_flags;
	q.prestriction = deconst(prestriction);
	q.pfolder_ids = deconst(pfolder_ids);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::movecopy_message(const char *dir, cpid_t cpid, uint64_t message_id, uint64_t dst_fid, uint64_t dst_id, BOOL b_move, BOOL *b_result)
{
	exreq_movecopy_message::view_t q{};
	exresp_movecopy_message r{};

	q.call_id = exmdb_callid::movecopy_message;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.message_id = message_id;
	q.dst_fid = dst_fid;
	q.dst_id = dst_id;
	q.b_move = b_move;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::movecopy_messages(const char *dir, cpid_t cpid, BOOL b_guest, const char *username, uint64_t src_fid, uint64_t dst_fid, BOOL b_copy, const EID_ARRAY *pmessage_ids, BOOL *b_partial)
{
	exreq_movecopy_messages::view_t q{};
	exresp_movecopy_messages r{};

	q.call_id = exmdb_callid::movecopy_messages;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.b_guest = b_guest;
	q.username = deconst(username);
	q.src_fid = src_fid;
	q.dst_fid = dst_fid;
	q.b_copy = b_copy;
	q.pmessage_ids = deconst(pmessage_ids);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_partial != nullptr)
		*b_partial = std::move(r.b_partial);
	return TRUE;
}

BOOL exmdb_client_remote::movecopy_folder(const char *dir, cpid_t cpid, BOOL b_guest, const char *username, uint64_t src_pid, uint64_t src_fid, uint64_t dst_fid, const char *str_new, BOOL b_copy, ec_error_t *e_result)
{
	exreq_movecopy_folder::view_t q{};
	exresp_movecopy_folder r{};

	q.call_id = exmdb_callid::movecopy_folder;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.b_guest = b_guest;
	q.username = deconst(username);
	q.src_pid = src_pid;
	q.src_fid = src_fid;
	q.dst_fid = dst_fid;
	q.str_new = deconst(str_new);
	q.b_copy = b_copy;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (e_result != nullptr)
		*e_result = std::move(r.e_result);
	return TRUE;
}

BOOL exmdb_client_remote::delete_messages(const char *dir, cpid_t cpid, const char *username, uint64_t folder_id, const EID_ARRAY *pmessage_ids, BOOL b_hard, BOOL *b_partial)
{
	exreq_delete_messages::view_t q{};
	exresp_delete_messages r{};

	q.call_id = exmdb_callid::delete_messages;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.username = deconst(username);
	q.folder_id = folder_id;
	q.pmessage_ids = deconst(pmessage_ids);
	q.b_hard = b_hard;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_partial != nullptr)
		*b_partial = std::move(r.b_partial);
	return TRUE;
}

BOOL exmdb_client_remote::get_message_brief(const char *dir, cpid_t cpid, uint64_t message_id, MESSAGE_CONTENT **pbrief)
{
	exreq_get_message_brief::view_t q{};
	exresp_get_message_brief r{};

	q.call_id = exmdb_callid::get_message_brief;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (pbrief != nullptr)
		*pbrief = std::move(r.pbrief);
	return TRUE;
}

BOOL exmdb_client_remote::sum_hierarchy(const char *dir, uint64_t folder_id, const char *username, BOOL b_depth, uint32_t *count)
{
	exreq_sum_hierarchy::view_t q{};
	exresp_sum_hierarchy r{};

	q.call_id = exmdb_callid::sum_hierarchy;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.username = deconst(username);
	q.b_depth = b_depth;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (count != nullptr)
		*count = std::move(r.count);
	return TRUE;
}

BOOL exmdb_client_remote::load_hierarchy_table(const char *dir, uint64_t folder_id, const char *username, uint8_t table_flags, const RESTRICTION *prestriction, uint32_t *table_id, uint32_t *row_count)
{
	exreq_load_hierarchy_table::view_t q{};
	exresp_load_hierarchy_table r{};

	q.call_id = exmdb_callid::load_hierarchy_table;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.username = deconst(username);
	q.table_flags = table_flags;
	q.prestriction = deconst(prestriction);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (table_id != nullptr)
		*table_id = std::move(r.table_id);
	if (row_count != nullptr)
		*row_count = std::move(r.row_count);
	return TRUE;
}

BOOL exmdb_client_remote::sum_content(const char *dir, uint64_t folder_id, BOOL b_fai, BOOL b_deleted, uint32_t *count)
{
	exreq_sum_content::view_t q{};
	exresp_sum_content r{};

	q.call_id = exmdb_callid::sum_content;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.b_fai = b_fai;
	q.b_deleted = b_deleted;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (count != nullptr)
		*count = std::move(r.count);
	return TRUE;
}

BOOL exmdb_client_remote::load_content_table(const char *dir, cpid_t cpid, uint64_t folder_id, const char *username, uint8_t table_flags, const RESTRICTION *prestriction, const SORTORDER_SET *psorts, uint32_t *table_id, uint32_t *row_count)
{
	exreq_load_content_table::view_t q{};
	exresp_load_content_table r{};

	q.call_id = exmdb_callid::load_content_table;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.username = deconst(username);
	q.table_flags = table_flags;
	q.prestriction = deconst(prestriction);
	q.psorts = deconst(psorts);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (table_id != nullptr)
		*table_id = std::move(r.table_id);
	if (row_count != nullptr)
		*row_count = std::move(r.row_count);
	return TRUE;
}

BOOL exmdb_client_remote::reload_content_table(const char *dir, uint32_t table_id)
{
	exreq_reload_content_table::view_t q{};
	exresp_reload_content_table r{};

	q.call_id = exmdb_callid::reload_content_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::load_permission_table(const char *dir, uint64_t folder_id, uint32_t table_flags, uint32_t *table_id, uint32_t *row_count)
{
	exreq_load_permission_table::view_t q{};
	exresp_load_permission_table r{};

	q.call_id = exmdb_callid::load_permission_table;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.table_flags = table_flags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (table_id != nullptr)
		*table_id = std::move(r.table_id);
	if (row_count != nullptr)
		*row_count = std::move(r.row_count);
	return TRUE;
}

BOOL exmdb_client_remote::load_rule_table(const char *dir, uint64_t folder_id, uint8_t table_flags, const RESTRICTION *prestriction, uint32_t *table_id, uint32_t *row_count)
{
	exreq_load_rule_table::view_t q{};
	exresp_load_rule_table r{};

	q.call_id = exmdb_callid::load_rule_table;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.table_flags = table_flags;
	q.prestriction = deconst(prestriction);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (table_id != nullptr)
		*table_id = std::move(r.table_id);
	if (row_count != nullptr)
		*row_count = std::move(r.row_count);
	return TRUE;
}

BOOL exmdb_client_remote::unload_table(const char *dir, uint32_t table_id)
{
	exreq_unload_table::view_t q{};
	exresp_unload_table r{};

	q.call_id = exmdb_callid::unload_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::sum_table(const char *dir, uint32_t table_id, uint32_t *rows)
{
	exreq_sum_table::view_t q{};
	exresp_sum_table r{};

	q.call_id = exmdb_callid::sum_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (rows != nullptr)
		*rows = std::move(r.rows);
	return TRUE;
}

BOOL exmdb_client_remote::query_table(const char *dir, const char *username, cpid_t cpid, uint32_t table_id, proptag_cspan pproptags, uint32_t start_pos, int32_t row_needed, TARRAY_SET *set)
{
	exreq_query_table::view_t q{};
	exresp_query_table r{};

	q.call_id = exmdb_callid::query_table;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.table_id = table_id;
	q.pproptags = pproptags;
	q.start_pos = start_pos;
	q.row_needed = row_needed;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (set != nullptr)
		*set = std::move(r.set);
	return TRUE;
}

BOOL exmdb_client_remote::match_table(const char *dir, const char *username, cpid_t cpid, uint32_t table_id, BOOL b_forward, uint32_t start_pos, const RESTRICTION *pres, proptag_cspan pproptags, int32_t *position, TPROPVAL_ARRAY *propvals)
{
	exreq_match_table::view_t q{};
	exresp_match_table r{};

	q.call_id = exmdb_callid::match_table;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.table_id = table_id;
	q.b_forward = b_forward;
	q.start_pos = start_pos;
	q.pres = deconst(pres);
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (position != nullptr)
		*position = std::move(r.position);
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::locate_table(const char *dir, uint32_t table_id, uint64_t inst_id, uint32_t inst_num, int32_t *position, uint32_t *row_type)
{
	exreq_locate_table::view_t q{};
	exresp_locate_table r{};

	q.call_id = exmdb_callid::locate_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	q.inst_id = inst_id;
	q.inst_num = inst_num;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (position != nullptr)
		*position = std::move(r.position);
	if (row_type != nullptr)
		*row_type = std::move(r.row_type);
	return TRUE;
}

BOOL exmdb_client_remote::read_table_row(const char *dir, const char *username, cpid_t cpid, uint32_t table_id, proptag_cspan pproptags, uint64_t inst_id, uint32_t inst_num, TPROPVAL_ARRAY *propvals)
{
	exreq_read_table_row::view_t q{};
	exresp_read_table_row r{};

	q.call_id = exmdb_callid::read_table_row;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.table_id = table_id;
	q.pproptags = pproptags;
	q.inst_id = inst_id;
	q.inst_num = inst_num;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::mark_table(const char *dir, uint32_t table_id, uint32_t position, uint64_t *inst_id, uint32_t *inst_num, uint32_t *row_type)
{
	exreq_mark_table::view_t q{};
	exresp_mark_table r{};

	q.call_id = exmdb_callid::mark_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	q.position = position;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (inst_id != nullptr)
		*inst_id = std::move(r.inst_id);
	if (inst_num != nullptr)
		*inst_num = std::move(r.inst_num);
	if (row_type != nullptr)
		*row_type = std::move(r.row_type);
	return TRUE;
}

BOOL exmdb_client_remote::get_table_all_proptags(const char *dir, uint32_t table_id, PROPTAG_ARRAY *proptags)
{
	exreq_get_table_all_proptags::view_t q{};
	exresp_get_table_all_proptags r{};

	q.call_id = exmdb_callid::get_table_all_proptags;
	q.dir = deconst(dir);
	q.table_id = table_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	return TRUE;
}

BOOL exmdb_client_remote::expand_table(const char *dir, uint32_t table_id, uint64_t inst_id, BOOL *b_found, int32_t *position, uint32_t *row_count)
{
	exreq_expand_table::view_t q{};
	exresp_expand_table r{};

	q.call_id = exmdb_callid::expand_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	q.inst_id = inst_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_found != nullptr)
		*b_found = std::move(r.b_found);
	if (position != nullptr)
		*position = std::move(r.position);
	if (row_count != nullptr)
		*row_count = std::move(r.row_count);
	return TRUE;
}

BOOL exmdb_client_remote::collapse_table(const char *dir, uint32_t table_id, uint64_t inst_id, BOOL *b_found, int32_t *position, uint32_t *row_count)
{
	exreq_collapse_table::view_t q{};
	exresp_collapse_table r{};

	q.call_id = exmdb_callid::collapse_table;
	q.dir = deconst(dir);
	q.table_id = table_id;
	q.inst_id = inst_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_found != nullptr)
		*b_found = std::move(r.b_found);
	if (position != nullptr)
		*position = std::move(r.position);
	if (row_count != nullptr)
		*row_count = std::move(r.row_count);
	return TRUE;
}

BOOL exmdb_client_remote::store_table_state(const char *dir, uint32_t table_id, uint64_t inst_id, uint32_t inst_num, uint32_t *state_id)
{
	exreq_store_table_state::view_t q{};
	exresp_store_table_state r{};

	q.call_id = exmdb_callid::store_table_state;
	q.dir = deconst(dir);
	q.table_id = table_id;
	q.inst_id = inst_id;
	q.inst_num = inst_num;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (state_id != nullptr)
		*state_id = std::move(r.state_id);
	return TRUE;
}

BOOL exmdb_client_remote::restore_table_state(const char *dir, uint32_t table_id, uint32_t state_id, int32_t *position)
{
	exreq_restore_table_state::view_t q{};
	exresp_restore_table_state r{};

	q.call_id = exmdb_callid::restore_table_state;
	q.dir = deconst(dir);
	q.table_id = table_id;
	q.state_id = state_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (position != nullptr)
		*position = std::move(r.position);
	return TRUE;
}

BOOL exmdb_client_remote::is_msg_present(const char *dir, uint64_t folder_id, uint64_t message_id, BOOL *b_exist)
{
	exreq_is_msg_present::view_t q{};
	exresp_is_msg_present r{};

	q.call_id = exmdb_callid::is_msg_present;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_exist != nullptr)
		*b_exist = std::move(r.b_exist);
	return TRUE;
}

BOOL exmdb_client_remote::is_msg_deleted(const char *dir, uint64_t message_id, BOOL *b_del)
{
	exreq_is_msg_deleted::view_t q{};
	exresp_is_msg_deleted r{};

	q.call_id = exmdb_callid::is_msg_deleted;
	q.dir = deconst(dir);
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_del != nullptr)
		*b_del = std::move(r.b_del);
	return TRUE;
}

BOOL exmdb_client_remote::load_message_instance(const char *dir, const char *username, cpid_t cpid, BOOL b_new, uint64_t folder_id, uint64_t message_id, uint32_t *instance_id)
{
	exreq_load_message_instance::view_t q{};
	exresp_load_message_instance r{};

	q.call_id = exmdb_callid::load_message_instance;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.b_new = b_new;
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (instance_id != nullptr)
		*instance_id = std::move(r.instance_id);
	return TRUE;
}

BOOL exmdb_client_remote::load_embedded_instance(const char *dir, BOOL b_new, uint32_t attachment_instance_id, uint32_t *instance_id)
{
	exreq_load_embedded_instance::view_t q{};
	exresp_load_embedded_instance r{};

	q.call_id = exmdb_callid::load_embedded_instance;
	q.dir = deconst(dir);
	q.b_new = b_new;
	q.attachment_instance_id = attachment_instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (instance_id != nullptr)
		*instance_id = std::move(r.instance_id);
	return TRUE;
}

BOOL exmdb_client_remote::get_embedded_cn(const char *dir, uint32_t instance_id, uint64_t **pcn)
{
	exreq_get_embedded_cn::view_t q{};
	exresp_get_embedded_cn r{};

	q.call_id = exmdb_callid::get_embedded_cn;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (pcn != nullptr)
		*pcn = std::move(r.pcn);
	return TRUE;
}

BOOL exmdb_client_remote::reload_message_instance(const char *dir, uint32_t instance_id, BOOL *b_result)
{
	exreq_reload_message_instance::view_t q{};
	exresp_reload_message_instance r{};

	q.call_id = exmdb_callid::reload_message_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::clear_message_instance(const char *dir, uint32_t instance_id)
{
	exreq_clear_message_instance::view_t q{};
	exresp_clear_message_instance r{};

	q.call_id = exmdb_callid::clear_message_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::read_message_instance(const char *dir, uint32_t instance_id, MESSAGE_CONTENT *msgctnt)
{
	exreq_read_message_instance::view_t q{};
	exresp_read_message_instance r{};

	q.call_id = exmdb_callid::read_message_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (msgctnt != nullptr)
		*msgctnt = std::move(r.msgctnt);
	return TRUE;
}

BOOL exmdb_client_remote::write_message_instance(const char *dir, uint32_t instance_id, const MESSAGE_CONTENT *pmsgctnt, BOOL b_force, PROPTAG_ARRAY *proptags, PROBLEM_ARRAY *problems)
{
	exreq_write_message_instance::view_t q{};
	exresp_write_message_instance r{};

	q.call_id = exmdb_callid::write_message_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pmsgctnt = deconst(pmsgctnt);
	q.b_force = b_force;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::load_attachment_instance(const char *dir, uint32_t message_instance_id, uint32_t attachment_num, uint32_t *instance_id)
{
	exreq_load_attachment_instance::view_t q{};
	exresp_load_attachment_instance r{};

	q.call_id = exmdb_callid::load_attachment_instance;
	q.dir = deconst(dir);
	q.message_instance_id = message_instance_id;
	q.attachment_num = attachment_num;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (instance_id != nullptr)
		*instance_id = std::move(r.instance_id);
	return TRUE;
}

BOOL exmdb_client_remote::create_attachment_instance(const char *dir, uint32_t message_instance_id, uint32_t *instance_id, uint32_t *attachment_num)
{
	exreq_create_attachment_instance::view_t q{};
	exresp_create_attachment_instance r{};

	q.call_id = exmdb_callid::create_attachment_instance;
	q.dir = deconst(dir);
	q.message_instance_id = message_instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (instance_id != nullptr)
		*instance_id = std::move(r.instance_id);
	if (attachment_num != nullptr)
		*attachment_num = std::move(r.attachment_num);
	return TRUE;
}

BOOL exmdb_client_remote::read_attachment_instance(const char *dir, uint32_t instance_id, ATTACHMENT_CONTENT *attctnt)
{
	exreq_read_attachment_instance::view_t q{};
	exresp_read_attachment_instance r{};

	q.call_id = exmdb_callid::read_attachment_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (attctnt != nullptr)
		*attctnt = std::move(r.attctnt);
	return TRUE;
}

BOOL exmdb_client_remote::write_attachment_instance(const char *dir, uint32_t instance_id, const ATTACHMENT_CONTENT *pattctnt, BOOL b_force, PROBLEM_ARRAY *problems)
{
	exreq_write_attachment_instance::view_t q{};
	exresp_write_attachment_instance r{};

	q.call_id = exmdb_callid::write_attachment_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pattctnt = deconst(pattctnt);
	q.b_force = b_force;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::delete_message_instance_attachment(const char *dir, uint32_t message_instance_id, uint32_t attachment_num)
{
	exreq_delete_message_instance_attachment::view_t q{};
	exresp_delete_message_instance_attachment r{};

	q.call_id = exmdb_callid::delete_message_instance_attachment;
	q.dir = deconst(dir);
	q.message_instance_id = message_instance_id;
	q.attachment_num = attachment_num;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::flush_instance(const char *dir, uint32_t instance_id, ec_error_t *e_result)
{
	exreq_flush_instance::view_t q{};
	exresp_flush_instance r{};

	q.call_id = exmdb_callid::flush_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (e_result != nullptr)
		*e_result = std::move(r.e_result);
	return TRUE;
}

BOOL exmdb_client_remote::unload_instance(const char *dir, uint32_t instance_id)
{
	exreq_unload_instance::view_t q{};
	exresp_unload_instance r{};

	q.call_id = exmdb_callid::unload_instance;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_instance_all_proptags(const char *dir, uint32_t instance_id, PROPTAG_ARRAY *proptags)
{
	exreq_get_instance_all_proptags::view_t q{};
	exresp_get_instance_all_proptags r{};

	q.call_id = exmdb_callid::get_instance_all_proptags;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	return TRUE;
}

BOOL exmdb_client_remote::get_instance_properties(const char *dir, uint32_t size_limit, uint32_t instance_id, proptag_cspan pproptags, TPROPVAL_ARRAY *propvals)
{
	exreq_get_instance_properties::view_t q{};
	exresp_get_instance_properties r{};

	q.call_id = exmdb_callid::get_instance_properties;
	q.dir = deconst(dir);
	q.size_limit = size_limit;
	q.instance_id = instance_id;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::set_instance_properties(const char *dir, uint32_t instance_id, const TPROPVAL_ARRAY *pproperties, PROBLEM_ARRAY *problems)
{
	exreq_set_instance_properties::view_t q{};
	exresp_set_instance_properties r{};

	q.call_id = exmdb_callid::set_instance_properties;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pproperties = deconst(pproperties);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::remove_instance_properties(const char *dir, uint32_t instance_id, proptag_cspan pproptags, PROBLEM_ARRAY *problems)
{
	exreq_remove_instance_properties::view_t q{};
	exresp_remove_instance_properties r{};

	q.call_id = exmdb_callid::remove_instance_properties;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::is_descendant_instance(const char *dir, uint32_t parent_iid, uint32_t child_iid, BOOL *b_included)
{
	exreq_is_descendant_instance::view_t q{};
	exresp_is_descendant_instance r{};

	q.call_id = exmdb_callid::is_descendant_instance;
	q.dir = deconst(dir);
	q.parent_iid = parent_iid;
	q.child_iid = child_iid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_included != nullptr)
		*b_included = std::move(r.b_included);
	return TRUE;
}

BOOL exmdb_client_remote::empty_message_instance_rcpts(const char *dir, uint32_t instance_id)
{
	exreq_empty_message_instance_rcpts::view_t q{};
	exresp_empty_message_instance_rcpts r{};

	q.call_id = exmdb_callid::empty_message_instance_rcpts;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_message_instance_rcpts_num(const char *dir, uint32_t instance_id, uint16_t *num)
{
	exreq_get_message_instance_rcpts_num::view_t q{};
	exresp_get_message_instance_rcpts_num r{};

	q.call_id = exmdb_callid::get_message_instance_rcpts_num;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (num != nullptr)
		*num = std::move(r.num);
	return TRUE;
}

BOOL exmdb_client_remote::get_message_instance_rcpts_all_proptags(const char *dir, uint32_t instance_id, PROPTAG_ARRAY *proptags)
{
	exreq_get_message_instance_rcpts_all_proptags::view_t q{};
	exresp_get_message_instance_rcpts_all_proptags r{};

	q.call_id = exmdb_callid::get_message_instance_rcpts_all_proptags;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	return TRUE;
}

BOOL exmdb_client_remote::get_message_instance_rcpts(const char *dir, uint32_t instance_id, uint32_t row_id, uint16_t need_count, TARRAY_SET *set)
{
	exreq_get_message_instance_rcpts::view_t q{};
	exresp_get_message_instance_rcpts r{};

	q.call_id = exmdb_callid::get_message_instance_rcpts;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.row_id = row_id;
	q.need_count = need_count;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (set != nullptr)
		*set = std::move(r.set);
	return TRUE;
}

BOOL exmdb_client_remote::update_message_instance_rcpts(const char *dir, uint32_t instance_id, const TARRAY_SET *pset)
{
	exreq_update_message_instance_rcpts::view_t q{};
	exresp_update_message_instance_rcpts r{};

	q.call_id = exmdb_callid::update_message_instance_rcpts;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pset = deconst(pset);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::copy_instance_rcpts(const char *dir, BOOL b_force, uint32_t src_instance_id, uint32_t dst_instance_id, BOOL *b_result)
{
	exreq_copy_instance_rcpts::view_t q{};
	exresp_copy_instance_rcpts r{};

	q.call_id = exmdb_callid::copy_instance_rcpts;
	q.dir = deconst(dir);
	q.b_force = b_force;
	q.src_instance_id = src_instance_id;
	q.dst_instance_id = dst_instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::empty_message_instance_attachments(const char *dir, uint32_t instance_id)
{
	exreq_empty_message_instance_attachments::view_t q{};
	exresp_empty_message_instance_attachments r{};

	q.call_id = exmdb_callid::empty_message_instance_attachments;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_message_instance_attachments_num(const char *dir, uint32_t instance_id, uint16_t *num)
{
	exreq_get_message_instance_attachments_num::view_t q{};
	exresp_get_message_instance_attachments_num r{};

	q.call_id = exmdb_callid::get_message_instance_attachments_num;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (num != nullptr)
		*num = std::move(r.num);
	return TRUE;
}

BOOL exmdb_client_remote::get_message_instance_attachment_table_all_proptags(const char *dir, uint32_t instance_id, PROPTAG_ARRAY *proptags)
{
	exreq_get_message_instance_attachment_table_all_proptags::view_t q{};
	exresp_get_message_instance_attachment_table_all_proptags r{};

	q.call_id = exmdb_callid::get_message_instance_attachment_table_all_proptags;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (proptags != nullptr)
		*proptags = std::move(r.proptags);
	return TRUE;
}

BOOL exmdb_client_remote::query_message_instance_attachment_table(const char *dir, uint32_t instance_id, proptag_cspan pproptags, uint32_t start_pos, int32_t row_needed, TARRAY_SET *set)
{
	exreq_query_message_instance_attachment_table::view_t q{};
	exresp_query_message_instance_attachment_table r{};

	q.call_id = exmdb_callid::query_message_instance_attachment_table;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pproptags = pproptags;
	q.start_pos = start_pos;
	q.row_needed = row_needed;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (set != nullptr)
		*set = std::move(r.set);
	return TRUE;
}

BOOL exmdb_client_remote::copy_instance_attachments(const char *dir, BOOL b_force, uint32_t src_instance_id, uint32_t dst_instance_id, BOOL *b_result)
{
	exreq_copy_instance_attachments::view_t q{};
	exresp_copy_instance_attachments r{};

	q.call_id = exmdb_callid::copy_instance_attachments;
	q.dir = deconst(dir);
	q.b_force = b_force;
	q.src_instance_id = src_instance_id;
	q.dst_instance_id = dst_instance_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::set_message_instance_conflict(const char *dir, uint32_t instance_id, const MESSAGE_CONTENT *pmsgctnt)
{
	exreq_set_message_instance_conflict::view_t q{};
	exresp_set_message_instance_conflict r{};

	q.call_id = exmdb_callid::set_message_instance_conflict;
	q.dir = deconst(dir);
	q.instance_id = instance_id;
	q.pmsgctnt = deconst(pmsgctnt);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_message_rcpts(const char *dir, uint64_t message_id, TARRAY_SET *set)
{
	exreq_get_message_rcpts::view_t q{};
	exresp_get_message_rcpts r{};

	q.call_id = exmdb_callid::get_message_rcpts;
	q.dir = deconst(dir);
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (set != nullptr)
		*set = std::move(r.set);
	return TRUE;
}

BOOL exmdb_client_remote::get_message_properties(const char *dir, const char *username, cpid_t cpid, uint64_t message_id, proptag_cspan pproptags, TPROPVAL_ARRAY *propvals)
{
	exreq_get_message_properties::view_t q{};
	exresp_get_message_properties r{};

	q.call_id = exmdb_callid::get_message_properties;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.message_id = message_id;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::set_message_properties(const char *dir, const char *username, cpid_t cpid, uint64_t message_id, const TPROPVAL_ARRAY *pproperties, PROBLEM_ARRAY *problems)
{
	exreq_set_message_properties::view_t q{};
	exresp_set_message_properties r{};

	q.call_id = exmdb_callid::set_message_properties;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.message_id = message_id;
	q.pproperties = deconst(pproperties);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::set_message_read_state(const char *dir, const char *username, uint64_t message_id, uint8_t mark_as_read, uint64_t *read_cn)
{
	exreq_set_message_read_state::view_t q{};
	exresp_set_message_read_state r{};

	q.call_id = exmdb_callid::set_message_read_state;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.message_id = message_id;
	q.mark_as_read = mark_as_read;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (read_cn != nullptr)
		*read_cn = std::move(r.read_cn);
	return TRUE;
}

BOOL exmdb_client_remote::remove_message_properties(const char *dir, cpid_t cpid, uint64_t message_id, proptag_cspan pproptags)
{
	exreq_remove_message_properties::view_t q{};
	exresp_remove_message_properties r{};

	q.call_id = exmdb_callid::remove_message_properties;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.message_id = message_id;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::allocate_message_id(const char *dir, uint64_t folder_id, uint64_t *message_id)
{
	exreq_allocate_message_id::view_t q{};
	exresp_allocate_message_id r{};

	q.call_id = exmdb_callid::allocate_message_id;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (message_id != nullptr)
		*message_id = std::move(r.message_id);
	return TRUE;
}

BOOL exmdb_client_remote::allocate_cn(const char *dir, uint64_t *cn)
{
	exreq_allocate_cn::view_t q{};
	exresp_allocate_cn r{};

	q.call_id = exmdb_callid::allocate_cn;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (cn != nullptr)
		*cn = std::move(r.cn);
	return TRUE;
}

BOOL exmdb_client_remote::mark_modified(const char *dir, uint64_t message_id)
{
	exreq_mark_modified::view_t q{};
	exresp_mark_modified r{};

	q.call_id = exmdb_callid::mark_modified;
	q.dir = deconst(dir);
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::try_mark_submit(const char *dir, uint64_t message_id, BOOL *b_marked)
{
	exreq_try_mark_submit::view_t q{};
	exresp_try_mark_submit r{};

	q.call_id = exmdb_callid::try_mark_submit;
	q.dir = deconst(dir);
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_marked != nullptr)
		*b_marked = std::move(r.b_marked);
	return TRUE;
}

BOOL exmdb_client_remote::clear_submit(const char *dir, uint64_t message_id, BOOL b_unsent)
{
	exreq_clear_submit::view_t q{};
	exresp_clear_submit r{};

	q.call_id = exmdb_callid::clear_submit;
	q.dir = deconst(dir);
	q.message_id = message_id;
	q.b_unsent = b_unsent;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::link_message(const char *dir, cpid_t cpid, uint64_t folder_id, uint64_t message_id, BOOL *b_result)
{
	exreq_link_message::view_t q{};
	exresp_link_message r{};

	q.call_id = exmdb_callid::link_message;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_result != nullptr)
		*b_result = std::move(r.b_result);
	return TRUE;
}

BOOL exmdb_client_remote::unlink_message(const char *dir, cpid_t cpid, uint64_t folder_id, uint64_t message_id)
{
	exreq_unlink_message::view_t q{};
	exresp_unlink_message r{};

	q.call_id = exmdb_callid::unlink_message;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::rule_new_message(const char *dir, const char *username, cpid_t cpid, uint64_t folder_id, uint64_t message_id)
{
	exreq_rule_new_message::view_t q{};
	exresp_rule_new_message r{};

	q.call_id = exmdb_callid::rule_new_message;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::set_message_timer(const char *dir, uint64_t message_id, uint32_t timer_id)
{
	exreq_set_message_timer::view_t q{};
	exresp_set_message_timer r{};

	q.call_id = exmdb_callid::set_message_timer;
	q.dir = deconst(dir);
	q.message_id = message_id;
	q.timer_id = timer_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::get_message_timer(const char *dir, uint64_t message_id, uint32_t **ptimer_id)
{
	exreq_get_message_timer::view_t q{};
	exresp_get_message_timer r{};

	q.call_id = exmdb_callid::get_message_timer;
	q.dir = deconst(dir);
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (ptimer_id != nullptr)
		*ptimer_id = std::move(r.ptimer_id);
	return TRUE;
}

BOOL exmdb_client_remote::empty_folder_permission(const char *dir, uint64_t folder_id)
{
	exreq_empty_folder_permission::view_t q{};
	exresp_empty_folder_permission r{};

	q.call_id = exmdb_callid::empty_folder_permission;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::update_folder_permission(const char *dir, uint64_t folder_id, BOOL b_freebusy, uint16_t count, const PERMISSION_DATA *prow)
{
	exreq_update_folder_permission::view_t q{};
	exresp_update_folder_permission r{};

	q.call_id = exmdb_callid::update_folder_permission;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.b_freebusy = b_freebusy;
	q.count = count;
	q.prow = deconst(prow);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::empty_folder_rule(const char *dir, uint64_t folder_id)
{
	exreq_empty_folder_rule::view_t q{};
	exresp_empty_folder_rule r{};

	q.call_id = exmdb_callid::empty_folder_rule;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::update_folder_rule(const char *dir, uint64_t folder_id, uint16_t count, const RULE_DATA *prow, BOOL *b_exceed)
{
	exreq_update_folder_rule::view_t q{};
	exresp_update_folder_rule r{};

	q.call_id = exmdb_callid::update_folder_rule;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.count = count;
	q.prow = deconst(prow);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_exceed != nullptr)
		*b_exceed = std::move(r.b_exceed);
	return TRUE;
}

BOOL exmdb_client_remote::deliver_message(const char *dir, const char *from_address, const char *account, cpid_t cpid, uint32_t dlflags, const MESSAGE_CONTENT *pmsg, const char *pdigest, uint64_t *folder_id, uint64_t *message_id, uint32_t *result)
{
	exreq_deliver_message::view_t q{};
	exresp_deliver_message r{};

	q.call_id = exmdb_callid::deliver_message;
	q.dir = deconst(dir);
	q.from_address = deconst(from_address);
	q.account = deconst(account);
	q.cpid = cpid;
	q.dlflags = dlflags;
	q.pmsg = deconst(pmsg);
	q.pdigest = deconst(pdigest);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (folder_id != nullptr)
		*folder_id = std::move(r.folder_id);
	if (message_id != nullptr)
		*message_id = std::move(r.message_id);
	if (result != nullptr)
		*result = std::move(r.result);
	return TRUE;
}

BOOL exmdb_client_remote::write_message(const char *dir, cpid_t cpid, uint64_t folder_id, const MESSAGE_CONTENT *pmsgctnt, const std::string &digest, uint64_t *outmid, uint64_t *outcn, ec_error_t *e_result)
{
	exreq_write_message::view_t q{};
	exresp_write_message r{};

	q.call_id = exmdb_callid::write_message;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.folder_id = folder_id;
	q.pmsgctnt = deconst(pmsgctnt);
	q.digest = digest;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (outmid != nullptr)
		*outmid = std::move(r.outmid);
	if (outcn != nullptr)
		*outcn = std::move(r.outcn);
	if (e_result != nullptr)
		*e_result = std::move(r.e_result);
	return TRUE;
}

BOOL exmdb_client_remote::read_message(const char *dir, const char *username, cpid_t cpid, uint64_t message_id, MESSAGE_CONTENT **pmsgctnt)
{
	exreq_read_message::view_t q{};
	exresp_read_message r{};

	q.call_id = exmdb_callid::read_message;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.cpid = cpid;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (pmsgctnt != nullptr)
		*pmsgctnt = std::move(r.pmsgctnt);
	return TRUE;
}

BOOL exmdb_client_remote::get_content_sync(const char *dir, uint64_t folder_id, const char *username, const gromox::idset *pgiven, const gromox::idset *pseen, const gromox::idset *pseen_fai, const gromox::idset *pread, cpid_t cpid, const RESTRICTION *prestriction, BOOL b_ordered, uint32_t *fai_count, uint64_t *fai_total, uint32_t *normal_count, uint64_t *normal_total, EID_ARRAY *updated_mids, EID_ARRAY *chg_mids, uint64_t *last_cn, EID_ARRAY *given_mids, EID_ARRAY *deleted_mids, EID_ARRAY *nolonger_mids, EID_ARRAY *read_mids, EID_ARRAY *unread_mids, uint64_t *last_readcn)
{
	exreq_get_content_sync::view_t q{};
	exresp_get_content_sync r{};

	q.call_id = exmdb_callid::get_content_sync;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.username = deconst(username);
	q.pgiven = deconst(pgiven);
	q.pseen = deconst(pseen);
	q.pseen_fai = deconst(pseen_fai);
	q.pread = deconst(pread);
	q.cpid = cpid;
	q.prestriction = deconst(prestriction);
	q.b_ordered = b_ordered;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (fai_count != nullptr)
		*fai_count = std::move(r.fai_count);
	if (fai_total != nullptr)
		*fai_total = std::move(r.fai_total);
	if (normal_count != nullptr)
		*normal_count = std::move(r.normal_count);
	if (normal_total != nullptr)
		*normal_total = std::move(r.normal_total);
	if (updated_mids != nullptr)
		*updated_mids = std::move(r.updated_mids);
	if (chg_mids != nullptr)
		*chg_mids = std::move(r.chg_mids);
	if (last_cn != nullptr)
		*last_cn = std::move(r.last_cn);
	if (given_mids != nullptr)
		*given_mids = std::move(r.given_mids);
	if (deleted_mids != nullptr)
		*deleted_mids = std::move(r.deleted_mids);
	if (nolonger_mids != nullptr)
		*nolonger_mids = std::move(r.nolonger_mids);
	if (read_mids != nullptr)
		*read_mids = std::move(r.read_mids);
	if (unread_mids != nullptr)
		*unread_mids = std::move(r.unread_mids);
	if (last_readcn != nullptr)
		*last_readcn = std::move(r.last_readcn);
	return TRUE;
}

BOOL exmdb_client_remote::get_hierarchy_sync(const char *dir, uint64_t folder_id, const char *username, const gromox::idset *pgiven, const gromox::idset *pseen, FOLDER_CHANGES *fldchgs, uint64_t *last_cn, EID_ARRAY *given_fids, EID_ARRAY *deleted_fids)
{
	exreq_get_hierarchy_sync::view_t q{};
	exresp_get_hierarchy_sync r{};

	q.call_id = exmdb_callid::get_hierarchy_sync;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.username = deconst(username);
	q.pgiven = deconst(pgiven);
	q.pseen = deconst(pseen);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (fldchgs != nullptr)
		*fldchgs = std::move(r.fldchgs);
	if (last_cn != nullptr)
		*last_cn = std::move(r.last_cn);
	if (given_fids != nullptr)
		*given_fids = std::move(r.given_fids);
	if (deleted_fids != nullptr)
		*deleted_fids = std::move(r.deleted_fids);
	return TRUE;
}

BOOL exmdb_client_remote::allocate_ids(const char *dir, uint32_t count, uint64_t *begin_eid)
{
	exreq_allocate_ids::view_t q{};
	exresp_allocate_ids r{};

	q.call_id = exmdb_callid::allocate_ids;
	q.dir = deconst(dir);
	q.count = count;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (begin_eid != nullptr)
		*begin_eid = std::move(r.begin_eid);
	return TRUE;
}

BOOL exmdb_client_remote::subscribe_notification(const char *dir, uint16_t notification_type, BOOL b_whole, uint64_t folder_id, uint64_t message_id, uint32_t *sub_id)
{
	exreq_subscribe_notification::view_t q{};
	exresp_subscribe_notification r{};

	q.call_id = exmdb_callid::subscribe_notification;
	q.dir = deconst(dir);
	q.notification_type = notification_type;
	q.b_whole = b_whole;
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (sub_id != nullptr)
		*sub_id = std::move(r.sub_id);
	return TRUE;
}

BOOL exmdb_client_remote::unsubscribe_notification(const char *dir, uint32_t sub_id)
{
	exreq_unsubscribe_notification::view_t q{};
	exresp_unsubscribe_notification r{};

	q.call_id = exmdb_callid::unsubscribe_notification;
	q.dir = deconst(dir);
	q.sub_id = sub_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::transport_new_mail(const char *dir, uint64_t folder_id, uint64_t message_id, uint32_t message_flags, const char *pstr_class)
{
	exreq_transport_new_mail::view_t q{};
	exresp_transport_new_mail r{};

	q.call_id = exmdb_callid::transport_new_mail;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.message_id = message_id;
	q.message_flags = message_flags;
	q.pstr_class = deconst(pstr_class);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::check_contact_address(const char *dir, const char *paddress, BOOL *b_found)
{
	exreq_check_contact_address::view_t q{};
	exresp_check_contact_address r{};

	q.call_id = exmdb_callid::check_contact_address;
	q.dir = deconst(dir);
	q.paddress = deconst(paddress);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (b_found != nullptr)
		*b_found = std::move(r.b_found);
	return TRUE;
}

BOOL exmdb_client_remote::get_public_folder_unread_count(const char *dir, const char *username, uint64_t folder_id, uint32_t *count)
{
	exreq_get_public_folder_unread_count::view_t q{};
	exresp_get_public_folder_unread_count r{};

	q.call_id = exmdb_callid::get_public_folder_unread_count;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.folder_id = folder_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (count != nullptr)
		*count = std::move(r.count);
	return TRUE;
}

BOOL exmdb_client_remote::vacuum(const char *dir)
{
	exreq_vacuum::view_t q{};
	exresp_vacuum r{};

	q.call_id = exmdb_callid::vacuum;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::unload_store(const char *dir)
{
	exreq_unload_store::view_t q{};
	exresp_unload_store r{};

	q.call_id = exmdb_callid::unload_store;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::notify_new_mail(const char *dir, uint64_t folder_id, uint64_t message_id)
{
	exreq_notify_new_mail::view_t q{};
	exresp_notify_new_mail r{};

	q.call_id = exmdb_callid::notify_new_mail;
	q.dir = deconst(dir);
	q.folder_id = folder_id;
	q.message_id = message_id;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::store_eid_to_user(const char *dir, const STORE_ENTRYID *store_eid, char **maildir, unsigned int *user_id, unsigned int *domain_id)
{
	exreq_store_eid_to_user::view_t q{};
	exresp_store_eid_to_user r{};

	q.call_id = exmdb_callid::store_eid_to_user;
	q.dir = deconst(dir);
	q.store_eid = deconst(store_eid);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (maildir != nullptr)
		*maildir = std::move(r.maildir);
	if (user_id != nullptr)
		*user_id = std::move(r.user_id);
	if (domain_id != nullptr)
		*domain_id = std::move(r.domain_id);
	return TRUE;
}

BOOL exmdb_client_remote::purge_softdelete(const char *dir, const char *username, uint64_t folder_id, uint32_t del_flags, gromox::mapitime_t cutoff, uint32_t *cnt_folders, uint32_t *cnt_messages, uint64_t *sz_normal, uint64_t *sz_fai)
{
	exreq_purge_softdelete::view_t q{};
	exresp_purge_softdelete r{};

	q.call_id = exmdb_callid::purge_softdelete;
	q.dir = deconst(dir);
	q.username = deconst(username);
	q.folder_id = folder_id;
	q.del_flags = del_flags;
	q.cutoff = cutoff;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (cnt_folders != nullptr)
		*cnt_folders = std::move(r.cnt_folders);
	if (cnt_messages != nullptr)
		*cnt_messages = std::move(r.cnt_messages);
	if (sz_normal != nullptr)
		*sz_normal = std::move(r.sz_normal);
	if (sz_fai != nullptr)
		*sz_fai = std::move(r.sz_fai);
	return TRUE;
}

BOOL exmdb_client_remote::purge_datafiles(const char *dir)
{
	exreq_purge_datafiles::view_t q{};
	exresp_purge_datafiles r{};

	q.call_id = exmdb_callid::purge_datafiles;
	q.dir = deconst(dir);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::autoreply_tsquery(const char *dir, const char *peer, uint64_t window, uint64_t *tdiff)
{
	exreq_autoreply_tsquery::view_t q{};
	exresp_autoreply_tsquery r{};

	q.call_id = exmdb_callid::autoreply_tsquery;
	q.dir = deconst(dir);
	q.peer = deconst(peer);
	q.window = window;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (tdiff != nullptr)
		*tdiff = std::move(r.tdiff);
	return TRUE;
}

BOOL exmdb_client_remote::autoreply_tsupdate(const char *dir, const char *peer)
{
	exreq_autoreply_tsupdate::view_t q{};
	exresp_autoreply_tsupdate r{};

	q.call_id = exmdb_callid::autoreply_tsupdate;
	q.dir = deconst(dir);
	q.peer = deconst(peer);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::recalc_store_size(const char *dir, uint32_t flags)
{
	exreq_recalc_store_size::view_t q{};
	exresp_recalc_store_size r{};

	q.call_id = exmdb_callid::recalc_store_size;
	q.dir = deconst(dir);
	q.flags = flags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::imapfile_read(const char *dir, const std::string &type, const std::string &mid, std::string *data)
{
	exreq_imapfile_read::view_t q{};
	exresp_imapfile_read r{};

	q.call_id = exmdb_callid::imapfile_read;
	q.dir = deconst(dir);
	q.type = type;
	q.mid = mid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (data != nullptr)
		*data = std::move(r.data);
	return TRUE;
}

BOOL exmdb_client_remote::imapfile_write(const char *dir, const std::string &type, const std::string &mid, const std::string &data)
{
	exreq_imapfile_write::view_t q{};
	exresp_imapfile_write r{};

	q.call_id = exmdb_callid::imapfile_write;
	q.dir = deconst(dir);
	q.type = type;
	q.mid = mid;
	q.data = data;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::imapfile_delete(const char *dir, const std::string &type, const std::string &mid)
{
	exreq_imapfile_delete::view_t q{};
	exresp_imapfile_delete r{};

	q.call_id = exmdb_callid::imapfile_delete;
	q.dir = deconst(dir);
	q.type = type;
	q.mid = mid;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::cgkreset(const char *dir, uint32_t flags)
{
	exreq_cgkreset::view_t q{};
	exresp_cgkreset r{};

	q.call_id = exmdb_callid::cgkreset;
	q.dir = deconst(dir);
	q.flags = flags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::set_maintenance(const char *dir, uint32_t mode)
{
	exreq_set_maintenance::view_t q{};
	exresp_set_maintenance r{};

	q.call_id = exmdb_callid::set_maintenance;
	q.dir = deconst(dir);
	q.mode = mode;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

BOOL exmdb_client_remote::autoreply_getprop(const char *dir, cpid_t cpid, proptag_cspan pproptags, TPROPVAL_ARRAY *propvals)
{
	exreq_autoreply_getprop::view_t q{};
	exresp_autoreply_getprop r{};

	q.call_id = exmdb_callid::autoreply_getprop;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.pproptags = pproptags;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (propvals != nullptr)
		*propvals = std::move(r.propvals);
	return TRUE;
}

BOOL exmdb_client_remote::autoreply_setprop(const char *dir, cpid_t cpid, const TPROPVAL_ARRAY *ppropvals, PROBLEM_ARRAY *problems)
{
	exreq_autoreply_setprop::view_t q{};
	exresp_autoreply_setprop r{};

	q.call_id = exmdb_callid::autoreply_setprop;
	q.dir = deconst(dir);
	q.cpid = cpid;
	q.ppropvals = deconst(ppropvals);
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (problems != nullptr)
		*problems = std::move(r.problems);
	return TRUE;
}

BOOL exmdb_client_remote::read_delegates(const char *dir, uint32_t mode, std::vector<std::string> *userlist)
{
	exreq_read_delegates::view_t q{};
	exresp_read_delegates r{};

	q.call_id = exmdb_callid::read_delegates;
	q.dir = deconst(dir);
	q.mode = mode;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	if (userlist != nullptr)
		*userlist = std::move(r.userlist);
	return TRUE;
}

BOOL exmdb_client_remote::write_delegates(const char *dir, uint32_t mode, const std::vector<std::string> &userlist)
{
	exreq_write_delegates::view_t q{};
	exresp_write_delegates r{};

	q.call_id = exmdb_callid::write_delegates;
	q.dir = deconst(dir);
	q.mode = mode;
	q.userlist = userlist;
	if (!exmdb_client_do_rpc(&q, &r))
		return false;
	return TRUE;
}

