#ifndef RPL_DEV_H
#define RPL_DEV_H 1

#define K24_MINORBITS 8
#define K24_MINORMASK ((1U << K24_MINORBITS) - 1)
#define K24_MAJOR(dev) ((dev) >> K24_MINORBITS)
#define K24_MINOR(dev) ((dev) & K24_MINORMASK)
#define K24_MKDEV(major, minor) (((major) << K24_MINORBITS) | (minor))

#define K26_MINORBITS 20
#define K26_MINORMASK ((1U << K26_MINORBITS) - 1)
#define K26_MAJOR(dev) (unsigned long)((dev) >> K26_MINORBITS)
#define K26_MINOR(dev) (unsigned long)((dev) & K26_MINORMASK)
#define K26_MKDEV(major, minor) (((major) << K26_MINORBITS) | (minor))
#define KD26_PARTS(dev) K26_MAJOR(dev), K26_MINOR(dev)

#endif // RPL_DEV_H
