/*=============================================================================
ttyrpld - TTY replay daemon
user/shared.c - Shared data
  Copyright (C) Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)
  -- For details see doc/GPL2.txt.
=============================================================================*/
#include <sys/types.h>
#include <stdio.h>
#include "dev.h"
#include "ushared.h"

const char *SH_event_type[] =
 {NULL, "OPEN", "READ", "WRITE", "IOCTL", "CLOSE"};

//-----------------------------------------------------------------------------
int SH_count_args(const char **args) {
    int argk = 0;
    while(*args++ != NULL) { ++argk; }
    return argk;
}

char *SH_device_name(uint32_t dev, char *buf, size_t count) {
    switch(K26_MAJOR(dev)) {
        case 2: // Pseudo TTY masters
            snprintf(buf, count, "pty-%lu", K26_MINOR(dev));
            break;
        case 4: // TTY devices
            if(K26_MINOR(dev) < 64) {
                snprintf(buf, count, "vc-%lu", K26_MINOR(dev));
            } else {
                goto unknown;
            }
            break;
        case 128: // Unix98 PTY masters
            snprintf(buf, count, "ptm-%lu", K26_MINOR(dev));
            break;
        case 136: // Unix98 PTY slaves
            snprintf(buf, count, "pts-%lu", K26_MINOR(dev));
            break;
    }
    return buf;
unknown:
    snprintf(buf, count, "%lu,%lu", K26_MAJOR(dev), K26_MINOR(dev));
    return buf;
}

//==[ End of file ]============================================================
