/*=============================================================================
ttyrpld - TTY replay daemon
dev.h - Supply file for dev_t encoding
  Copyright (C) Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however only version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see doc/GPL2.txt.
=============================================================================*/
#ifndef RPL_DEV_H
#define RPL_DEV_H 1

// The Linux Kernel include files do not export these macros correctly.

#define K24_MINORBITS 8
#define K24_MINORMASK ((1U << K24_MINORBITS) - 1)
#define K24_MAJOR(dev) ((dev) >> K24_MINORBITS)
#define K24_MINOR(dev) ((dev) & K24_MINORMASK)
#define K24_MKDEV(major, minor) (((major) << K24_MINORBITS) | (minor))

// Let's hope MINORBITS stays the same for some time :-)

#define K26_MINORBITS 20
#define K26_MINORMASK ((1U << K26_MINORBITS) - 1)
#define K26_MAJOR(dev) (unsigned long)((dev) >> K26_MINORBITS)
#define K26_MINOR(dev) (unsigned long)((dev) & K26_MINORMASK)
#define K26_MKDEV(major, minor) (((major) << K26_MINORBITS) | (minor))
#define KD26_PARTS(dev) K26_MAJOR(dev), K26_MINOR(dev)

// Glibc still uses MINORBITS = 8

#define GLIBC_MKDEV(major, minor) (((major) << K24_MINORBITS) | (minor))

#endif // RPL_DEV_H

//==[ End of file ]============================================================
