/*=============================================================================
ttyrpld - TTY replay daemon
rpl_ioctl.h - IOCTL numbers for `ttyrpld` and the rpldev module
  Copyright (C) Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however only version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see doc/GPL2.txt.
=============================================================================*/
#ifndef RPL_IOCTL_H
#define RPL_IOCTL_H 1

#ifdef __KERNEL__
#    include <linux/ioctl.h>
#else
#    include <sys/ioctl.h>
#endif

enum {
    RPL_IOC_MAGIC      = 0xB7,
    RPL_IOC_GETBUFSIZE = _IOR(RPL_IOC_MAGIC, 1, size_t),
    RPL_IOC__MAXNUM    = _IO(RPL_IOC_MAGIC, 2),
};

#endif /* RPL_IOCTL_H */

//==[ End of file ]============================================================
