/*=============================================================================
ttyrpld - TTY replay daemon
shared.h
  Copyright (C) Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however only version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see doc/GPL2.txt.
=============================================================================*/
#ifndef RPL_USHARED_H
#define RPL_USHARED_H 1

#include <endian.h>
#include <stdint.h>

#ifndef O_BINARY
#    define O_BINARY 0
#endif
#define MAXFNLEN 1024

#if __BYTE_ORER == __BIG_ENDIAN
#    define BIGENDIAN 1
#endif

extern void SH_check_balign(void);
extern const char *SH_event_type[];
extern int SH_count_args(const char **);
extern ssize_t SH_read_wait(int, void *, size_t);
extern off_t SH_skip(int, off_t, int);
extern void SH_swab(void *, size_t);

inline static unsigned int min_uint(unsigned int a, unsigned int b) {
    return a < b ? a : b;
}

#endif /* RPL_SHARED_H */

//==[ End of file ]============================================================
