/*=============================================================================
ttyrpld - TTY replay daemon
include/rdsh.h - Shared definitions for RPLD/INFO/RPLINFO
  Copyright (C) Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however only version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see doc/GPL2.txt.
=============================================================================*/
#ifndef RPL_RDSH_H
#define RPL_RDSH_H 1

#include <sys/types.h>
#include <pthread.h>
#include <stdint.h>
#include <libHX.h>
#if LIBHX_VERSION < 20040905
#    error --------------------------------------------
#    error You need a newer version of libHX (20040905)
#    error --------------------------------------------
#endif

#define RECEIVE_FULL(fd, ptr, sz) \
    (recv((fd), (ptr), (sz), MSG_WAITALL) == (sz))

struct Optmap_t {
    int _running;
    char *ovdev, *fbdev, *ofmt;
    int nocreat, syslog, verbose;
    long bsize, user_id;

    char *infod_port;
    int infod_start;
};

struct Statmap_t {
    size_t open, read, write, ioctl, close, badpack;
    unsigned long long in, out;
};

struct tty {
    uint32_t dev;
    int fd, status;
    size_t in, out;
    char *file;
};

enum {
    IFP_NONE = 0,
    IFP_ACTIVATE,
    IFP_DEACTIVATE,
    IFP_DEACTIVSES, // deactivate logging until tty is closed
    IFP_GETINFO,
    IFP_REMOVE,
    IFP_FLUSH,

    NF_NEWLINE = 1 << 0,
};

// infod.c
extern void infod_init(void);
extern void *infod_main(void *);

// rplctl.c
extern int rplctl_main(int, const char **);

// rdsh.c
extern pthread_mutex_t Ttys_lock;
extern struct HXbtree *Ttys;
extern struct Statmap_t Stats;
extern struct Optmap_t Opt;

extern char *G_devname_nm(uint32_t, char *, size_t);
extern char *G_devname_fs(uint32_t, char *, size_t);
extern struct tty *get_tty(uint32_t);
extern void log_close(struct tty *);
extern int notify(int, unsigned int, const char *, ...);
extern ssize_t send_wait(int, const void *, size_t, int);

#endif // RPL_RDSH_H

//==[ End of file ]============================================================
