/*=============================================================================
ttyrpld - TTY replay daemon
include/global.h - Shared definitions for user-space apps
  Copyright (C) Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however only version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see doc/GPL2.txt.
=============================================================================*/
#ifndef TTYRPLD_GLOBAL_H
#define TTYRPLD_GLOBAL_H 1

#include <endian.h>
#include <stdint.h>

#ifndef O_BINARY
#    define O_BINARY 0
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
#    define PP_swab(ptr, sz) swab_be((ptr), (sz))
#else
#    define PP_swab(ptr, sz)
#endif

#define MAXFNLEN 256
#define TTYRPLD_VERSION "1.00"

extern int count_args(const char **);
extern ssize_t read_wait(int, void *, size_t);
extern off_t G_skip(int, off_t, int);
extern void swab_be(void *, size_t);

inline static unsigned int min_uint(unsigned int a, unsigned int b) {
    return a < b ? a : b;
}

#endif // TTYRPLD_GLOBAL_H

//==[ End of file ]============================================================
