/*=============================================================================
ttyrpld - TTY replay daemon
include/rpl_packet.h - Packet definitions for RPLD and RPLDEV
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004
  -- License restrictions apply (GPL2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however only version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see doc/GPL2.txt.
=============================================================================*/
#ifndef RPL_PACKET_H
#define RPL_PACKET_H 1

#define PACKED __attribute__((packed))

#ifdef __KERNEL__
#    include <linux/types.h>
#else
#    include <stdint.h>
#endif

enum {
    MAGIC_2_4 = 0xFF,
    MAGIC_2_6 = 0xEE,
    MAGIC_SIG = MAGIC_2_6,
};

enum {
    EVT_NONE = 0,
    EVT_OPEN,
    EVT_READ,
    EVT_WRITE,
    EVT_IOCTL,
    EVT_CLOSE,
    EVT_INIT   = 'i',
    EVT_DEINIT = 'd',
    EVT_IDENT  = 240,
    EVT_IGNORE = 255,
};

struct rpld_packet {
    uint32_t dev, dev2 PACKED;
    uint16_t size PACKED;
    uint8_t event PACKED, magic PACKED;
} PACKED;

struct mem_packet {
    uint32_t dev, dev2 PACKED;
    uint16_t size PACKED;
    uint8_t event PACKED, magic PACKED;
    struct timeval tv PACKED;
} PACKED;

struct disk_packet {
    uint16_t size;
    uint8_t event PACKED, magic PACKED;
    struct timeval tv PACKED;
} PACKED;

#endif /* RPL_PACKET_H */

//==[ End of file ]============================================================
