#!/usr/bin/rpmbuild -bb
#==============================================================================
# ttyrpld - TTY replay daemon
#   Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
#   -- License restrictions apply (GPL v2)
#
#   This file is part of ttyrpld.
#   ttyrpld is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by
#   the Free Software Foundation; however ONLY version 2 of the License.
#
#   ttyrpld is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program kit; if not, write to:
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#   02111-1307, USA.
#
#   -- For details see the COPYING file
#==============================================================================
Name: ttyrpld
Version: 1.44.2
Release: 1
Group: System Environment/Daemons
Packager: Jan Engelhardt <jengelh [at] linux01 gwdg de>
URL: http://ttyrpld.sourceforge.net/
Summary: ttyrpld kernel-based screen- and keylogger

Vendor: Jan Engelhardt <jengelh [at] linux01 gwdg de>
Source: http://heanet.dl.sourceforge.net/sourceforge/ttyrpld/%name-%version.tbz2
%define source http://heanet.dl.sourceforge.net/sourceforge/ttyrpld/%name-%version.tbz2
License: GPL2

BuildRoot: %_tmppath/%name-%version-build
AutoReqProv: no
Prefix: /usr
Requires: libHX.so.0.3 libpopt.so.1 libpthread.so.0 libc.so.6 libdl.so.2

%description
ttyrpld is a Kernel-based keylogger and screenlogger for
Linux 2.x and FreeBSD 5.3 with a real-time and tail-follow log
analyzer. It supports most tty types, including vc, bsd and
unix98-style ptys (xterm/ssh), serial, isdn, etc.

THIS PACKAGE DOES NOT CONTAIN COMPILED KERNEL FILES --
you will have to build the modified kernel and the rpldev
module yourself. Sources are provided in
%prefix/src/ttyrpld-1.44.2-kd.
(Run `make -C %prefix/src/ttyrpld-1.44.2-kd/linux-2.6`)
Be sure to have the Kernel sources installed properly!

Author:
-------
  Jan Engelhardt <jengelh [at] linux01 gwdg de>

#------------------------------------------------------------------------------
%prep
LOCALSRC=/home/jengelha/f/%name

cd "$RPM_SOURCE_DIR"/;
copy_from_local=0;
if [ ! -e %name-%version.tbz2 ]; then
    if [ -d "$LOCALSRC" ]; then
        copy_from_local=1;
    else
        wget -c %source;
    fi;
fi;

cd "$RPM_BUILD_DIR"/;
rm -Rf %name %name-%version;
if [ "$copy_from_local" == "1" ]; then
    cp -av "$LOCALSRC" ./;
    mv %name %name-%version;
    make -C %name-%version cleanx;
else
    tar -jvxf %name-%version.tbz2;
fi;

#------------------------------------------------------------------------------
%build
cd "$RPM_BUILD_DIR"/%name-%version/;
make EXT_CFLAGS="$RPM_OPT_FLAGS" DEBUG=0;

#------------------------------------------------------------------------------
%install
bdroot="$RPM_BUILD_ROOT";
[ "$bdroot" != "/" -a -d "$bdroot" ] && rm -Rfv "$bdroot";
cd "$RPM_BUILD_DIR"/%name-%version/;

make ROOT="$bdroot" PREFIX="%prefix" install;
install -d "$bdroot/usr/src/%name-%version-kd/kpatch";
install -d "$bdroot/usr/src/%name-%version-kd/include";
cp -av linux-2.[46] "$bdroot/usr/src/%name-%version-kd/";
cp -av kpatch/linux* "$bdroot/usr/src/%name-%version-kd/kpatch/";
cp -av include/rpl_* "$bdroot/usr/src/%name-%version-kd/include/";
install -d "$bdroot""%_defaultdocdir";
cp -av doc "$bdroot""%_defaultdocdir"/%name;
install -d "$bdroot""/usr/sbin";
ln -s /etc/init.d/rpld "$bdroot""/usr/sbin/rcrpld";
chown -R root:root "$bdroot";

#------------------------------------------------------------------------------
%clean
bdroot="$RPM_BUILD_ROOT";
[ "$bdroot" != "/" -a -d "$bdroot" ] && rm -Rfv "$bdroot";

#------------------------------------------------------------------------------
%files
%defattr(-,root,root)
%config /etc/rpld.conf
/etc/init.d/rpld
/usr/bin/ttyreplay
/usr/sbin/rcrpld
/usr/sbin/rplctl
/usr/sbin/rpld
/usr/share/locale/ar_IQ/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/de/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/es/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/fr/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/it/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/nb/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/nl/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/sv/LC_MESSAGES/ttyrpld.mo
/usr/src/%name-%version-kd
%docdir %_defaultdocdir/%name
%_defaultdocdir/%name

#------------------------------------------------------------------------------
%post
echo "*** Please do not forget to compile the RPLDEV kernel module if you";
echo "*** have not done so yet for your kernel.";

#==[ End of file ]=============================================================
