#~~syntax:makefile
#==============================================================================
# ttyrpld - TTY replay daemon
#   Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
#   -- License restrictions apply (GPL v2)
#
#   This file is part of ttyrpld.
#   ttyrpld is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by
#   the Free Software Foundation; however ONLY version 2 of the License.
#
#   ttyrpld is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program kit; if not, write to:
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#   02111-1307, USA.
#
#   -- For details see the COPYING file
#==============================================================================

GNUmakefile: $(patsubst %.c,%.d,$(wildcard user/*.c)) \
 $(patsubst %.cpp,%.d,$(wildcard user/*.cpp));

%.d: %.c;
	${VECHO_DEP}
	${CC} ${CFLAGS} -MM -MF $@ -MT $(@:.d=.o) $<;

%.d: %.cpp;
	${VECHO_DEP}
	${CXX} ${CXXFLAGS} -MM -MF $@ -MT $(@:.d=.o) $<;

_DEP_FILES := $(wildcard */*.d)
ifneq (${_DEP_FILES},)
-include ${_DEP_FILES}
endif

#==[ End of file ]=============================================================
