/*=============================================================================
ttyrpld - TTY replay daemon
include/rdsh.h - Shared definitions for RPLD/INFO/RPLINFO
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see the COPYING file
=============================================================================*/
#ifndef TTYRPLD_RDSH_H
#define TTYRPLD_RDSH_H 1

#include <sys/types.h>
#include <pthread.h>
#include "rpl_stdint.h"
#include <libHX.h>
#if !defined(_LIBHX_H) || _LIBHX_H < 20050206
#    error --------------------------------------
#    error You need a newer version of libHX
#    error (at least 0_3-20050206)
#    error http:/jengelh.hopto.org/prog-libHX.php
#    error --------------------------------------
#endif

#define RECEIVE_FULL(fd, ptr, sz) \
    (recv((fd), (ptr), (sz), MSG_WAITALL) == (sz))

struct GOptmap_t {
    int syslog, verbose;
    long user_id;
    const char *infod_port, *ofmt;
};

struct Statmap_t {
    unsigned long init, open, read, write, ioctl, close, deinit, badpack;
    unsigned long long in, out;
};

struct tty {
    uint32_t dev;
    uid_t uid;
    int fd, status;
    unsigned long in, out;
    char *log, *sdev, *full_dev;
};

enum {
    IFP_NONE = 0x3F,
    IFP_DEFAULT,
    IFP_ACTIVATE,
    IFP_DEACTIVATE,
    IFP_DEACTIVSES,
    IFP_REMOVE,
    IFP_GETINFO,
    IFP_GETINFO_T,
    IFP_ZERO,
};

// infod.c
extern void infod_init(void);
extern void *infod_main(void *);

// rplctl.c
extern int rplctl_main(int, const char **);

// rdsh.c
extern pthread_mutex_t Ttys_lock;
extern const char *Device_dirs[];
extern struct HXbtree *Ttys;
extern struct Statmap_t Stats;
extern struct GOptmap_t GOpt;

extern struct tty *get_tty(uint32_t, int);
extern void log_close(struct tty *);
extern void notify(int, const char *, ...);
extern ssize_t send_wait(int, const void *, size_t, int);

#endif // TTYRPLD_RDSH_H

//==[ End of file ]============================================================
