/*=============================================================================
ttyrpld - TTY replay daemon
include/rpl_endian.h
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  -- For details see the COPYING file
=============================================================================*/
#ifndef RPL_ENDIAN_H
#define RPL_ENDIAN_H 1

#if defined(__FreeBSD__)
#    include <sys/endian.h>
#    if _BYTE_ORDER == _BIG_ENDIAN
#        define SWAB(ptr, sz) swab_be((ptr), (sz))
#    else
#        define SWAB(ptr, sz)
#    endif
#elif defined(__OpenBSD__)
#    include <machine/endian.h>
#    if BYTE_ORDER == BIG_ENDIAN
#        define SWAB(ptr, sz) swab_be((ptr), (sz))
#    else
#        define SWAB(ptr, sz)
#    endif
#else
#    include <endian.h>
#    if __BYTE_ORDER == __BIG_ENDIAN
#        define SWAB(ptr, sz) swab_be((ptr), (sz))
#    else
#        define SWAB(ptr, sz)
#    endif
#endif

#endif // RPL_ENDIAN_H

//==[ End of file ]============================================================
