#==============================================================================
# ttyrpld - TTY replay daemon
#   Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
#   -- License restrictions apply (GPL v2)
#
#   This file is part of ttyrpld.
#   ttyrpld is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by
#   the Free Software Foundation; however ONLY version 2 of the License.
#
#   ttyrpld is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program kit; if not, write to:
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#   02111-1307, USA.
#
#   -- For details see the COPYING file
#==============================================================================
Name:     ttyrpld
Version:  2.00
Release:  1
Group:    System Environment/Daemons
Packager: Jan Engelhardt <jengelh [at] linux01 gwdg de>
URL:      http://ttyrpld.sourceforge.net/
Summary:  ttyrpld kernel-based screen- and keylogger

Vendor:  Jan Engelhardt <jengelh [at] linux01 gwdg de>
Source:  http://heanet.dl.sourceforge.net/sourceforge/ttyrpld/%name-%version.tbz2
%define source http://heanet.dl.sourceforge.net/sourceforge/ttyrpld/%name-%version.tbz2
License: GPL2

BuildRoot:   %_tmppath/%name-%version-build
AutoReqProv: no
Prefix:      /usr
Requires:    libHX.so.0.4 libpopt.so.1 libpthread.so.0 libc.so.6 libdl.so.2

%description
ttyrpld is a Kernel-based keylogger and screenlogger for
Linux 2.x and FreeBSD 5.3 with a real-time and tail-follow log
analyzer. It supports most tty types, including vc, bsd and
unix98-style ptys (xterm/ssh), serial, isdn, etc.

THIS PACKAGE DOES NOT CONTAIN COMPILED KERNEL FILES --
you will have to build the modified kernel and the rpldev
module yourself. Sources are provided in
%prefix/src/%name-%version-kd.
(Run `make -C %prefix/src/%name-%version-kd/linux-2.6`
after install, and also be sure to have the Kernel sources
installed properly!

Author:
-------
  Jan Engelhardt <jengelh [at] linux01 gwdg de>

%prep
LOCALSRC=/home/jengelha/f/%name

cd "$RPM_SOURCE_DIR"/;
copy_from_local=0;
if [ ! -e %name-%version.tbz2 ]; then
    if [ -d "$LOCALSRC" ]; then
        copy_from_local=1;
    else
        wget -c %source;
    fi;
fi;

cd "$RPM_BUILD_DIR"/;
rm -Rf %name %name-%version;
if [ "$copy_from_local" == "1" ]; then
    cp -av "$LOCALSRC" ./;
    mv %name %name-%version;
    make -C %name-%version cleanx;
else
    tar -jvxf %name-%version.tbz2;
fi;

%build
cd "$RPM_BUILD_DIR"/%name-%version/;
make EXT_CFLAGS="$RPM_OPT_FLAGS" DEBUG=0;

%install
b="$RPM_BUILD_ROOT";
[ "$b" != "/" -a -d "$b" ] && rm -Rfv "$b";
cd "$RPM_BUILD_DIR"/%name-%version/;

make ROOT="$b" PREFIX="%prefix" install;
install -d "$b/usr/src/%name-%version-kd/kpatch";
install -d "$b/usr/src/%name-%version-kd/include";
cp -av linux-2.[46] "$b/usr/src/%name-%version-kd/";
cp -av kpatch/linux* "$b/usr/src/%name-%version-kd/kpatch/";
cp -av include/rpl_{ioctl,packet}.h "$b/usr/src/%name-%version-kd/include/";
install -d "$b""%_defaultdocdir";
cp -av doc "$b""%_defaultdocdir"/%name;
install -d "$b""/usr/sbin";
ln -s /etc/init.d/rpld "$b""/usr/sbin/rcrpld";
chown -R root:root "$b";

%clean
b="$RPM_BUILD_ROOT";
[ "$b" != "/" -a -d "$b" ] && rm -Rfv "$b";

%files
%defattr(-,root,root)
%config /etc/rpld.conf
/etc/init.d/rpld
/usr/bin/ttyreplay
/usr/sbin/rcrpld
/usr/sbin/rplctl
/usr/sbin/rpld
/usr/share/locale/ar_IQ/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/de/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/es/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/fr/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/it/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/nb/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/nl/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/sv/LC_MESSAGES/ttyrpld.mo
/usr/src/%name-%version-kd
%docdir %_defaultdocdir/%name
%_defaultdocdir/%name

#------------------------------------------------------------------------------
%post
echo "*** Please do not forget to PATCH the Kernel and compile the RPLDEV"
echo "*** kernel module if you have not done so yet for your Kernel.";

#==[ End of file ]=============================================================
