#~~syntax:makefile
#==============================================================================
# ttyrpld - TTY replay daemon
#   Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
#   -- License restrictions apply (GPL v2)
#
#   This file is part of ttyrpld.
#   ttyrpld is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by
#   the Free Software Foundation; however ONLY version 2 of the License.
#
#   ttyrpld is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program kit; if not, write to:
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   -- For details, see the file named "LICENSE.GPL2"
#==============================================================================

DEBUG    := 0

CC       := gcc
CXX      := g++
CFLAGS   := -D_LARGEFILE_SOURCE=1 -D_LARGE_FILES -D_FILE_OFFSET_BITS=64 \
            -D_REENTRANT -DPIC -Iinclude -Wall -Waggregate-return \
            -Wmissing-declarations -Wmissing-prototypes -Wredundant-decls \
            -Wshadow -Wstrict-prototypes -Winline -fPIC -pipe
CXXFLAGS := -D_LARGEFILE_SOURCE=1 -D_LARGE_FILES -D_FILE_OFFSET_BITS=64 \
            -D_REENTRANT -DPIC -Iinclude -Wall -Wmissing-prototypes \
            -Wredundant-decls -Wstrict-prototypes -fPIC -pipe
AS       := gcc # as
ASFLAGS  :=
LD       := gcc # ld
LDXX     := g++ # ld
LDFLAGS  :=
SOFLAGS  := -shared
AR       := ar
ARFLAGS  :=

ifeq (${DEBUG},1)
  CFLAGS   += -ggdb3
  CXXFLAGS += -ggdb3
  ASFLAGS  += -ggdb3
  STRIP    := @true
else
  CFLAGS   += -O2 -finline-functions -fomit-frame-pointer
  CXXFLAGS += -O2 -finline-functions -fomit-frame-pointer
  ASFLAGS  += -O2 -finline-functions -fomit-frame-pointer
  STRIP    := strip
endif
ifeq (${PROF},1)
  CFLAGS   += -pg -fprofile-arcs -ftest-coverage -fno-omit-frame-pointer
  CXXFLAGS += -pg -fprofile-arcs -ftest-coverage -fno-omit-frame-pointer
  ASFLAGS  += -pg -fprofile-arcs -ftest-coverage -fno-omit-frame-pointer
  LDFLAGS  += -pg
  STRIP    := @true
endif

ifeq (${V},)
  CC    := @${CC}
  CXX   := @${CXX}
  AS    := @${AS}
  LD    := @${LD}
  LDXX  := @${LDXX}
  AR    := @${AR}
  STRIP := @${STRIP}

  VECHO_DEP = @echo "  DEP   " $@
  VECHO_CC  = @echo "  CC    " $@
  VECHO_CXX = @echo "  CXX   " $@
  VECHO_AS  = @echo "  AS    " $@
  VECHO_LD  = @echo "  LD    " $@
  VECHO_AR  = @echo "  AR    " $@
endif

#==============================================================================
