/*=============================================================================
ttyrpld - TTY replay daemon
include/global.h - Shared definitions for user-space apps
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  -- For details, see the file named "LICENSE.GPL2"
=============================================================================*/
#ifndef TTYRPLD_GLOBAL_H
#define TTYRPLD_GLOBAL_H 1

#include <sys/types.h>
#include <locale.h>
#include <libintl.h>
#include "rpl_endian.h"
#include "rpl_stdint.h"

#ifndef O_BINARY
#    define O_BINARY 0
#endif
#define _(s) gettext(s)

#define MAXFNLEN 256
#define TTYRPLD_VERSION "2.01"
#if defined(__FreeBSD__) || defined(__OpenBSD__)
#    define D_IOCTL(fd, cmd, eax) (ioctl((fd), (cmd), &(eax)) == 0)
#else
#    define D_IOCTL(fd, cmd, eax) ((eax = ioctl((fd), (cmd))) >= 0)
#endif

extern int count_args(const char **);
extern void load_locale(const char *);
extern ssize_t read_wait(int, void *, size_t);
extern off_t G_skip(int, off_t, int);
extern void swab_be(void *, size_t);

inline static unsigned int min_uint(unsigned int a, unsigned int b) {
    return a < b ? a : b;
}

#endif // TTYRPLD_GLOBAL_H

//=============================================================================
