/*=============================================================================
ttyrpld - TTY replay daemon
include/rpl_ioctl.h - IOCTL numbers for RPLDEV
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  -- For details, see the file named "LICENSE.GPL2"
=============================================================================*/
#ifndef RPL_IOCTL_H
#define RPL_IOCTL_H 1

#if defined(__linux__) && defined(__KERNEL__)
#    include <linux/ioctl.h>
#    include <linux/types.h>
#elif defined(__FreeBSD__) && defined(_KERNEL)
#    include <sys/ioccom.h>
#else // userspace
#    include <sys/types.h>
#    include <sys/ioctl.h>
#endif

enum {
    /* Some weird *BSD scheme makes me use IOWR, otherwise readin the pointer
    within kernel space does not seem to work. */
    RPL_IOC_MAGIC      = 0xB7,
    RPL_IOC_GETBUFSIZE = _IOWR(RPL_IOC_MAGIC, 1, size_t),
    RPL_IOC_GETRAVAIL  = _IOWR(RPL_IOC_MAGIC, 2, size_t),
    RPL_IOC_GETWAVAIL  = _IOWR(RPL_IOC_MAGIC, 3, size_t),
    RPL_IOC_IDENTIFY   = _IOWR(RPL_IOC_MAGIC, 4, size_t),
    RPL_IOC_SEEK       = _IOWR(RPL_IOC_MAGIC, 5, size_t),
    RPL_IOC_FLUSH      = _IOWR(RPL_IOC_MAGIC, 6, size_t),
    RPL_IOC__MAXNUM    = _IOWR(RPL_IOC_MAGIC, 7, size_t),
};

#endif // RPL_IOCTL_H

//=============================================================================
