/*=============================================================================
ttyrpld - TTY replay daemon
include/rpl_packet.h - Packet definitions for RPLD and RPLDEV
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  -- For details, see the file named "LICENSE.GPL2"
=============================================================================*/
#ifndef RPL_PACKET_H
#define RPL_PACKET_H 1

#define __PACKED __attribute__((packed))

#if defined(__linux__) && defined(__KERNEL__)
#    include <linux/time.h>
#    include <linux/types.h>
#elif (defined(__FreeBSD__) || defined(__OpenBSD__)) && defined(_KERNEL)
#    include <sys/time.h>
#    include <sys/types.h>
#else // userspace
#    include <sys/time.h>
#    include "rpl_stdint.h"
#endif

enum {
    EVT_NONE = 0,
    EVT_OPEN,
    EVT_READ,
    EVT_WRITE,
    EVT_IOCTL,
    EVT_CLOSE,
    EVT_INIT    = 'i',
    EVT_DEINIT  = 'd',
    EVT_ID_PROG = 240,
    EVT_ID_DEVPATH,
    EVT_max,
    MAGIC_SIG = 0xEE,
};

struct rpldev_packet {
    uint32_t dev;
    uint16_t size;
    uint8_t event, magic;
    struct timeval time;
} __PACKED;

struct rpldsk_packet {
    uint16_t size;
    uint8_t event, magic;
    struct timeval time;
} __PACKED;

#endif // RPL_PACKET_H

//=============================================================================
