#==============================================================================
# ttyrpld - TTY replay daemon
#   Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
#   -- License restrictions apply (GPL v2)
#
#   This file is part of ttyrpld.
#   ttyrpld is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by
#   the Free Software Foundation; however ONLY version 2 of the License.
#
#   ttyrpld is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program kit; if not, write to:
#   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#   Boston, MA 02111-1307, USA.
#
#   -- For details, see the file named "LICENSE.GPL2"
#==============================================================================
Name:    ttyrpld
Version: 2.01
Release: 1
Group:   System Environment/Daemons
URL:     http://ttyrpld.sourceforge.net/
Summary: ttyrpld kernel-based screen- and keylogger
License: GPL2
Source:  http://heanet.dl.sourceforge.net/sourceforge/ttyrpld/%name-%version.tbz2

BuildRoot:   %_tmppath/%name-%version-build
AutoReqProv: no
Prefix:      /usr
Requires:    libHX.so.0.5 libpopt.so.1 libpthread.so.0 libc.so.6 libdl.so.2

%description
ttyrpld is a Kernel-based keylogger and screenlogger for
Linux 2.x and FreeBSD 5.3 with a real-time and tail-follow log
analyzer. It supports most tty types, including vc, bsd and
unix98-style ptys (xterm/ssh), serial, isdn, etc. and things
you have never ever seen.

THIS PACKAGE DOES NOT CONTAIN COMPILED KERNEL FILES --
you will have to build the modified kernel and the rpldev
module yourself. Sources are provided in
%prefix/src/%name-%version-kd.
(Run `make -C %prefix/src/%name-%version-kd/linux-2.6`
after install, and also be sure to have the Kernel sources
installed properly!

Author:
-------
  Jan Engelhardt <jengelh [at] linux01 gwdg de>

%prep
%setup

%build
cd "$RPM_BUILD_DIR"/%name-%version/;
make EXT_CFLAGS="$RPM_OPT_FLAGS" DEBUG=0;

%install
b="$RPM_BUILD_ROOT";
[ "$b" != "/" -a -d "$b" ] && rm -Rfv "$b";
cd "$RPM_BUILD_DIR"/%name-%version/;

make ROOT="$b" PREFIX="%prefix" install;
install -d "$b/usr/src/%name-%version-kd/kpatch";
install -d "$b/usr/src/%name-%version-kd/include";
cp -av linux-2.[46] "$b/usr/src/%name-%version-kd/";
cp -av kpatch/linux* "$b/usr/src/%name-%version-kd/kpatch/";
cp -av include/rpl_{ioctl,packet}.h "$b/usr/src/%name-%version-kd/include/";
install -d "$b""%_defaultdocdir";
cp -av doc "$b""%_defaultdocdir"/%name;
install -d "$b""/usr/sbin";
ln -s /etc/init.d/rpld "$b""/usr/sbin/rcrpld";

%clean
b="$RPM_BUILD_ROOT";
[ "$b" != "/" -a -d "$b" ] && rm -Rfv "$b";

%files
%defattr(-,root,root)
%config /etc/rpld.conf
/etc/init.d/rpld
/usr/bin/ttyreplay
/usr/sbin/rcrpld
/usr/sbin/rplctl
/usr/sbin/rpld
/usr/share/locale/ar_IQ/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/de/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/es/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/fr/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/it/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/nb/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/nl/LC_MESSAGES/ttyrpld.mo
/usr/share/locale/sv/LC_MESSAGES/ttyrpld.mo
/usr/src/%name-%version-kd
%docdir %_defaultdocdir/%name
%_defaultdocdir/%name

%post
echo "*** Please do not forget to PATCH the Kernel and compile the RPLDEV"
echo "*** kernel module if you have not done so yet for your Kernel.";

#==============================================================================
