/*=============================================================================
ttyrpld - TTY replay daemon
include/dev.h - Supply file for dev_t encoding
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA

  -- For details, see the file named "LICENSE.GPL2"
=============================================================================*/
#ifndef RPL_DEV_H
#define RPL_DEV_H 1

#define K26_MINORBITS 20
#define K26_MINORMASK 0xFFFFF
#define K26_MAJOR(dev) (unsigned long)((dev) >> K26_MINORBITS)
#define K26_MINOR(dev) (unsigned long)((dev) & K26_MINORMASK)
#define K26_MKDEV(major, minor) \
    (((major) << K26_MINORBITS) | ((minor) & K26_MINORMASK))
#define KD26_PARTS(dev) K26_MAJOR(dev), K26_MINOR(dev)

#if defined(__FreeBSD__) || defined(__OpenBSD__)
// Another mix
#    define COMPAT_MAJOR(dev) \
        (unsigned long)(((dev) & 0xFF00) >> 8)
#    define COMPAT_MINOR(dev) \
        (unsigned long)(((dev) & 0xFF) | (((dev) & ~0xFFFF) >> 16))
#    define COMPAT_MKDEV(major, minor) \
        (unsigned long)(((minor) & 0xFF) | (((major) & 0xFF) << 8) | \
        (((minor) & ~0xFF) << 16))
#else
// Glibc uses an intermediate mixture to be 2.4-compatible
#    define COMPAT_MAJOR(dev) \
        (unsigned long)(((dev) & 0xFFF00) >> 8)
#    define COMPAT_MINOR(dev) \
        (unsigned long)(((dev) & 0xFF) | (((dev) & 0xFFF00000) >> 20))
#    define COMPAT_MKDEV(major, minor) \
        (unsigned long)(((minor) & 0xFF) | (((minor) & 0xFFF00) << 20) | \
        (((major) & 0xFFF) << 8))
#endif

#endif // RPL_DEV_H

//=============================================================================
