/*=============================================================================
ttyrpld - TTY replay daemon
include/pctrl.h
  Copyright © Jan Engelhardt <jengelh [at] linux01 gwdg de>, 2004 - 2005
  -- License restrictions apply (GPL v2)

  This file is part of ttyrpld.
  ttyrpld is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by
  the Free Software Foundation; however ONLY version 2 of the License.

  ttyrpld is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program kit; if not, write to:
  Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA

  -- For details, see the file named "LICENSE.GPL2"
=============================================================================*/
#ifndef TTYREPLAY_PCTRL_H
#define TTYREPLAY_PCTRL_H 1

#ifdef __cplusplus
extern "C" {
#endif

enum {
    PCTRL_NONE = 0,
    PCTRL_PREV,
    PCTRL_NEXT,
    PCTRL_EXIT,
    PCTRL_SKPACK,
    PCTRL_SKTIME,
};

struct pctrl_info {
    double factor;
    int sktype;
    long skval;
    unsigned char paused, brk, echo;
};

extern int pctrl_init(void);
extern void pctrl_exit(void);
extern void pctrl_activate(struct pctrl_info *);
extern void pctrl_deactivate(int);

#ifdef __cplusplus
} // extern "C"
#endif

#endif // TTYREPLAY_PCTRL_H

//=============================================================================
