/*
**
** private hack stuff
**
**---------------------------------------------------------------------------
** Copyright 2005 Christoph Oelckers
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
**
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote products
**    derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
** THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**---------------------------------------------------------------------------
**
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <time.h>

#undef GetCharWidth
#undef DrawText

#include "gi.h"
#include "gstrings.h"
#include "configfile.h"
#include "c_dispatch.h"
#include "c_console.h"
#include "d_gui.h"
#include "d_dehacked.h"
#include "g_game.h"
#include "m_png.h"
#include "m_menu.h"
#include "m_misc.h"
#include "doomerrors.h"
#include "w_wad.h"
#include "hu_stuff.h"
#include "p_local.h"
#include "p_setup.h"
#include "s_Sound.h"
#include "wi_stuff.h"
#include "sc_man.h"
#include "cmdlib.h"
#include "p_terrain.h"
#include "decallib.h"
#include "a_doomglobal.h"
#include "autosegs.h"
#include "i_cd.h"
#include "stats.h"
#include "a_sharedglobal.h"
#include "v_text.h"
#include "r_sky.h"

#include "gl/gl_functions.h"
#include "gl/gl_texture.h"

void Multi_Start();
static void ReadHighscoreList();

extern int totalgametime;
extern void (*gl_DebugHook)();
void (*Multi_HookSave)();

EXTERN_CVAR(Bool, vid_fps)
EXTERN_CVAR (Int, hudcolor_statnames)
CVAR (Bool, scoringflag, false, CVAR_NOSET)
CVAR (Int, hudcolor_statnames_scoring, CR_UNTRANSLATED, CVAR_ARCHIVE)		// For the letters before the stats
CVAR (Int, hudcolor_statnames_noscoring, CR_BRICK, CVAR_ARCHIVE)			// For the letters before the stats

#define LEVEL_NOMONSTERSCORE UCONST64(0x4000000000000000)
#define LEVEL_NOSCORE UCONST64(0x2000000000000000)

static int	levelscore;
static int	score;

//==========================================================================
//
//
//
//==========================================================================

AT_GAME_SET(Scoring)
{
	extern gameinfo_t RetailGameInfo;

	// make all Doom2 switches available for Doom1 maps!
	RetailGameInfo.maxSwitch = 3;

	// load the scoring info. Right now it's only the NOMONSTERSCORE flag
	int lump = Wads.CheckNumForName("SCORINFO");
	if (lump>=0)
	{
		try
		{
			SC_OpenLumpNum(lump, "SCORINFO");
			while (SC_GetString())
			{
				if (SC_Compare("MAP"))
				{
					SC_MustGetString();
					level_info_t * level = FindLevelInfo(sc_String);
					SC_MustGetStringName("{");
					while (!SC_CheckString("}"))
					{
						SC_MustGetString();
						if (SC_Compare("NOMONSTERSCORE"))
						{
							level->flags|=LEVEL_NOMONSTERSCORE;
						}
						if (SC_Compare("NOSCORE"))
						{
							level->flags|=LEVEL_NOSCORE;
						}
					}
				}
			}
		}
		catch (CRecoverableError & err)
		{
			// Just print a message and ignore the rest of the lump
			SC_Close();
			Printf("Parsing of SCORINFO failed: %s\n", err.GetMessage());
		}
	}

	// Cheat ourselves into the level startup procedure
	Multi_HookSave = gl_DebugHook;
	gl_DebugHook = Multi_Start;
	ReadHighscoreList();
}


//==========================================================================
//
// Start game launcher
//
//==========================================================================

CCMD(switch)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;

	memset(&si,0,sizeof(si));
	if (CreateProcess(NULL,"DLaunch.exe",NULL,NULL,TRUE,0,NULL,NULL,&si,&pi))
	{
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
		exit(0);
	}
}

// ====================================================================
//
//
// High scores
//
//
// ====================================================================

struct Score
{
	int score;
	short skill;
	short playerclass;
	char name[12];
	int timeneeded;
};

struct TenScores
{
	Score scores[10];
	char * ep_name;
	char * ep_header;
};

TArray<TenScores> hl;

// ====================================================================
//
//
// ====================================================================
static void ReadHighscoreList()
{
	static int done=0;
	int j;
	TenScores ep_entry;



	if (!done) try
	{
		SC_OpenFile("DOOMSCOR.DAT");

		while (SC_GetString())
		{
			memset(&ep_entry, 0, sizeof(ep_entry));
			ep_entry.ep_header = copystring(sc_String);
			SC_MustGetString();
			ep_entry.ep_name = copystring(sc_String);

			SC_MustGetStringName("{");
			j=0;
			while (!SC_CheckString("}"))
			{
				SC_GetString();
				SC_GetString();
				strncpy(ep_entry.scores[j].name, sc_String, 12);
				SC_MustGetNumber();
				ep_entry.scores[j].score=sc_Number;

				int h,m,s;
				SC_MustGetString();
				sscanf(sc_String, "%d:%d:%d", &h, &m, &s);
				ep_entry.scores[j].timeneeded= ((((h*60)+m)*60)+s)*TICRATE;

				SC_MustGetNumber();
				ep_entry.scores[j].skill=sc_Number;
				j++;
			}
			hl.Push(ep_entry);
		}
		done=1;
		SC_Close();
	}
	catch(CRecoverableError & )
	{
	}
}

// ====================================================================
//
//
// ====================================================================
static void SaveHighscoreList()
{
	int j;

	FILE * f = fopen("DOOMSCOR.DAT", "wt");
	if (f==NULL) return;

	for(int i=0;i<hl.Size ();i++)
	{
		TenScores & el = hl[i];

		fprintf(f, "%s \"%s\"\n{\n", el.ep_header, el.ep_name);
		for(j=0;j<10;j++)
		{
			if (el.scores[j].score>0)
			{
				fprintf(f,"\t%2i. %10s %7d %02d:%02d:%02d %i\n",
					j+1, el.scores[j].name, el.scores[j].score, 
					el.scores[j].timeneeded/(60*60*TICRATE),
					(el.scores[j].timeneeded%(60*60*TICRATE))/(60*TICRATE),
					(el.scores[j].timeneeded%(60*TICRATE))/(TICRATE),
					el.scores[j].skill);
			}
		}
		fprintf(f,"}\n\n");
	}
	fclose(f);
}

// ====================================================================
//
//
//
// ====================================================================
static void DrawHighscoreList(TenScores & el)
{
	static char *classid[]={ ""," F"," C"," M"};
	int i;

	Printf(	"\n\35\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36"
			"\36\36\36\36\36\36\36\36\36\36\36\36\37\n\n"
			"High Scores for\n"
			"%s:\n\n",
			el.ep_name);

	for (i=0;i<10;i++)
	{
		char * col = i==0? TEXTCOLOR_BLUE : TEXTCOLOR_YELLOW;

		Printf("%s%2i. %10s %7d %02d:%02d:%02d %i\n",
			col, i+1, el.scores[i].name, el.scores[i].score, 
			el.scores[i].timeneeded/(60*60*TICRATE),
			(el.scores[i].timeneeded%(60*60*TICRATE))/(60*TICRATE),
			(el.scores[i].timeneeded%(60*TICRATE))/(TICRATE),
			el.scores[i].skill);//classid[el.scores[i].playerclass]);
	}
}


CCMD(showscore)
{
	if (argv.argc()>1)
	{
		const char * startlevel = argv[1];
		for(int i=0;i<hl.Size();i++)
		{
			size_t strl = strlen(startlevel);
			if (!strnicmp(startlevel, hl[i].ep_header, strl)) 
			{
				if (!hl[i].ep_name)
				{
					char * p = (char*)strchr(startlevel, '.');
					if (p)
					{
						*p=0;
						int l=Wads.CheckNumForName(p+1);
						if (l>=0)
						{
							char base[256];
							l=Wads.GetLumpFile(l);
							const char * w = Wads.GetWadName(l);
							ExtractFileBase(w, base);
							if (!stricmp(base, startlevel))
							{
								extern oldmenuitem_t EpisodeMenu[];

								for(int j=0;j<8;j++)
								{
									if (EpisodeMenu[j].name && EpisodeMenu[j].fulltext && !stricmp(EpisodeMaps[j], p+1))
									{
										hl[i].ep_name = copystring(EpisodeMenu[j].name);
										SaveHighscoreList();
										break;
									}
								}
							}
						}
						*p='.';
					}
				}
				//if (!hl[i].ep_name) hl[i].ep_name = "";
				DrawHighscoreList(hl[i]);
			}
		}
	}
}




// ====================================================================
//
//
// ====================================================================
static void HighscoreEntry(const char * section, const char * startmap, int score)
{
	struct Score s;
	int i;
	time_t clock;
	struct tm *lt;
	TenScores * ts = NULL;

	time (&clock);
	lt = localtime (&clock);

	for(i=0;i<hl.Size();i++)
	{
		if (!stricmp(section, hl[i].ep_header)) 
		{
			ts = &hl[i];
			break;
		}
	}
	if (!ts) 
	{
		// Create a new highscore list for this episode
		TenScores newts;

		memset(&newts, 0, sizeof(newts));
		newts.ep_header=copystring(section);

		hl.Push(newts);
		ts = &hl[hl.Size()-1];
	}

	if (!ts->ep_name)
	{
		ts->ep_name = "(unknown)";
		for(int j=0;j<8;j++)
		{
			if (EpisodeMenu[j].name && EpisodeMenu[j].fulltext && !stricmp(EpisodeMaps[j], startmap))
			{
				ts->ep_name = copystring(EpisodeMenu[j].name);
				break;
			}
		}
	}

	if (lt != NULL)
		sprintf(s.name,"%02d.%02d.%04d",lt->tm_mday, lt->tm_mon+1, lt->tm_year+1900);
	else
		strcpy(s.name,"00.00.0000");

	s.skill=gameskill;
	s.score=score;
	s.timeneeded=totalgametime;

	for(i=9;i>=0;i--)
	{
		if (score<ts->scores[i].score || (score==ts->scores[i].score && totalgametime>=ts->scores[i].timeneeded)) 
		{
			break;
		}
	}
	i++;
	if (i>9) return;

	memmove(&ts->scores[i+1],&ts->scores[i],sizeof(struct Score)*(9-i));
	ts->scores[i]=s;
	SaveHighscoreList();
}



//==========================================================================
//
// Scorer
//
//==========================================================================

class AScorer : public AInventory
{
	DECLARE_CLASS(AScorer, AInventory)

	struct OneLevel
	{
		int totalkills, killcount;
		int totalsecrets, secretcount;
		char levelname[9];
		bool nomonsterscore;
		bool noscore;
	};

	TArray<OneLevel> LevelData;
	char * startlevel;

public:
	void BeginPlay();
	void PostBeginPlay();
	void Tick();
	void Serialize(FArchive & arc);
};

IMPLEMENT_STATELESS_ACTOR(AScorer, Any, -1, -1)
	PROP_Flags (MF_NOBLOCKMAP|MF_NOSECTOR)
	PROP_Inventory_FlagsSet (IF_UNDROPPABLE)
END_DEFAULTS

void AScorer::BeginPlay()
{
	Super::BeginPlay();
	ChangeStatNum(MAX_STATNUM);
}

void AScorer::PostBeginPlay()
{
	// Todo: Only spawn when this map is the first in an episode
	startlevel = copystring(level.mapname);

	AActor * player = players[0].mo;

	if (player->FindInventory<AScorer>())
	{
		Destroy();
		return;
	}
	if (!TryPickup(player))
	{
		Destroy();
	}
	Printf("Scoring enabled\n");
}

void AScorer::Tick()
{
	// The scorer must always be the last thinker in the list!
	if (Succ->Succ != NULL)
	{
		ChangeStatNum(MAX_STATNUM);
		return;
	}
	if (!(level.flags&(LEVEL_NOMONSTERSCORE|LEVEL_NOSCORE)))
	{
		if (hudcolor_statnames!=hudcolor_statnames_scoring) hudcolor_statnames=hudcolor_statnames_scoring;
	}
	else
	{
		if (hudcolor_statnames!=hudcolor_statnames_noscoring) hudcolor_statnames=hudcolor_statnames_noscoring;
	}

	if (gameaction==ga_completed)
	{
		int i;
		for(i=0;i<LevelData.Size();i++)
		{
			if (!stricmp(LevelData[i].levelname, level.mapname)) break;
		}
		if (i==LevelData.Size())
		{
			LevelData.Reserve(1);
			strcpy(LevelData[i].levelname, level.mapname);
			LevelData[i].nomonsterscore=!!(level.flags&LEVEL_NOMONSTERSCORE);
			LevelData[i].noscore=!!(level.flags&LEVEL_NOSCORE);
		}
		LevelData[i].totalkills = level.total_monsters;
		LevelData[i].killcount = level.killed_monsters;
		LevelData[i].totalsecrets = level.total_secrets;
		LevelData[i].secretcount = level.found_secrets;

		score = levelscore = 0;
		for(i=0;i<LevelData.Size();i++)
		{
			if (!LevelData[i].noscore)
			{
				float killpct= LevelData[i].totalkills? (float)LevelData[i].killcount/LevelData[i].totalkills : 1.0f;
				float secretpct= LevelData[i].totalsecrets? (float)LevelData[i].secretcount/LevelData[i].totalsecrets : 1.0f;
				if (LevelData[i].nomonsterscore) killpct=1.0f;

				static int skillmult[]={4000, 7000, 8500, 10000, 12000};
				int mul = skillmult[gameskill];
				// beware of roundoff errors!
				int thislevelscore=((int)(0.5f + 0.05f * mul) + 			// base score for level
									(int)(0.5f + killpct * 0.75f * mul) + 	// kill score
									(int)(0.5f + secretpct * 0.2f * mul) );	// secret score

				if (level.clusterflags & CLUSTER_HUB)
				{
					level_info_t * li = FindLevelInfo (LevelData[i].levelname);
					if (li->cluster == level.cluster) levelscore += thislevelscore;
				}
				else
				{
					if (!stricmp(LevelData[i].levelname, level.mapname)) levelscore += thislevelscore;
				}
				score += thislevelscore;
			}
		}

		if (!strncmp(level.nextmap, "enDSeQ", 6)) 
		{
			char name1[256];
			char section[100];
			int lump = Wads.CheckNumForName(startlevel);
			int wad = Wads.GetLumpFile(lump);
			const char * name = Wads.GetWadName(wad);
			strcpy(name1,name);
			char * n=strchr(name1,':');
			if (n) *n=0;
			ExtractFileBase(name1, section);
			strcat(section, ".");
			strcat(section, startlevel);
			strupr(section);
			HighscoreEntry(section, startlevel, score);
			// We're done so get rid of the scorer.
			Destroy();
		}
		FStat::SelectStat("score");
		vid_fps=0;
		level.flags&=~LEVEL_NOINTERMISSION;
	}
}

void AScorer::Serialize(FArchive & ar)
{
	Super::Serialize(ar);

	int i = LevelData.Size();

	ar << i << startlevel;

	if (ar.IsLoading()) LevelData.Resize(i);
	for(i=0;i<LevelData.Size();i++)
	{
		ar  << LevelData[i].totalkills 
			<< LevelData[i].killcount  
			<< LevelData[i].totalsecrets
			<< LevelData[i].secretcount
			<< LevelData[i].nomonsterscore;
		if (SaveVersion>=306)
			ar << LevelData[i].noscore;
		else 
			LevelData[i].noscore=false;

		if (ar.IsStoring()) ar.WriteName(LevelData[i].levelname);
		else strcpy(LevelData[i].levelname, ar.ReadName());
	}
}

void Multi_Start()
{
	if (players[0].mo && !deathmatch && !multiplayer && scoringflag)
	{
		if (!players[0].mo->FindInventory<AScorer>())
		{
			Spawn<AScorer>(0,0,0);
		}
	}
	if (Multi_HookSave) Multi_HookSave();
}

//==========================================================================
//
// show scoring stats
//
//==========================================================================

ADD_STAT(score, out)
{
	if (gamestate == GS_INTERMISSION)
	{
		sprintf(out,"Level score: %6d, Total score: %06d", levelscore, score);
	}
	else
	{
		*out=0;
	}
}




//============================================================================
//
// Stuff
//
//============================================================================


//============================================================================
//
//
//
//============================================================================
CCMD(secret)
{
	int lump=Wads.CheckNumForName("SECRETS");

	if (lump>=0)
	{
		char * secrets;
		char * p;
		int seclen=Wads.LumpLength(lump);

		p=secrets=new char[seclen+5];
		Wads.ReadLump(lump,secrets);
		secrets[seclen]='\r';
		secrets[seclen+1]='\n';
		secrets[seclen+2]='\r';
		secrets[seclen+3]='\n';
		secrets[seclen+4]=0;

		size_t lm=strlen(level.mapname);

		while (p<secrets+seclen)
		{
			const char * pp=(const char*)memchr(p,'\n',seclen-(p-secrets));
			int ll;

			if (!pp) 
			{
				goto out;
			}

			ll=pp-p;
			if (ll>=lm && !strnicmp(p,level.mapname,lm))
			{
				while (*p!='\n' && *p!='\r')
				{
					if (isspace(*p))
					{
						const char * q=p;
						while (*q && isspace(*q))
						{
							if (*q=='\n' || *q=='\r') goto out;
							q++;
						}
					}
					size_t ln=strcspn(p,"\r\n");
					Printf("%.*s\n",ln,p);
					p+=ll+1;
					pp=(const char *)memchr(p,'\n',seclen-(p-secrets));
					if (!pp) ll=strlen(p)-1;
					else ll=pp-p;
				}
				break;
			}
			p+=ll+1;
		}
out:
		delete secrets;
	}
}


//-----------------------------------------------------------------------------
//
// Manipulate the definitions to suit my needs ;)
//
//-----------------------------------------------------------------------------

static void SetNoBright(const char * type, bool nobright, bool all=false)
{
	const TypeInfo * ti = TypeInfo::FindType(type);
	if (ti && ti->ActorInfo && ti->ActorInfo->OwnedStates)
	{
		for(int i=0;i<ti->ActorInfo->NumOwnedStates;i++)
		{
			if (all || !GetDefaultByType(ti)->DeathState || &ti->ActorInfo->OwnedStates[i] < GetDefaultByType(ti)->DeathState)
			{
				if (nobright) ti->ActorInfo->OwnedStates[i].Frame &= ~SF_FULLBRIGHT;
				else ti->ActorInfo->OwnedStates[i].Frame |= SF_FULLBRIGHT;
			}
		}
	}
}

// Yet another hack in a long line of lousy hacks to get direct access to private data in the textures
class FAccessTexture : public FTexture
{
public:
	int SourceLump;
};

void (*Init_HookSave)();
void Init_Start();


AT_GAME_SET(Private)
{
	static const char * nobrightset[] ={
		"Arachnotron", "Cacodemon", "Fatso", "ShotgunGuy", "ChaingunGuy", "WolfensteinSS", "Revenant",
		"ScriptedMarine", "SpiderMastermind", "Berserk", "IceGuy", "MageBoss", "Crusader", "Inquisitor",
		"Programmer", "Reaver", "Sentinel", "StrifeBishop", "Templar", NULL };
	
	static const char * countitemset[] = {
		"ArtiBlastRadius", "ArtiBoostArmor", "ArtiPoisonBag", "ArtiHealingRadius", "ArtiBoostMana",
		"ArtiSpeedBoots", "ArtiDarkServant", "ArtiTeleportOther", "Coin", "Gold10", "Gold25", "Gold50",
		"MetalArmor", "LeatherArmor", "MedPatch", "MedicalKit", "SurgeryKit", "StrifeMap", "ShadowArmor",
		"EnvironmentalSuit", "Targeter", "Scanner", NULL };
	

	GetDefault<ABulletPuff>()->flags3|=MF3_DONTSPLASH;
	GetDefault<ABlood>()->flags3|=MF3_DONTSPLASH;
	GetDefaultByName("Stalker")->height=32*FRACUNIT;
	GetDefaultByName("BloodSplatter")->flags3|=MF3_DONTSPLASH;
	GetDefaultByName("AxeBlood")->flags3|=MF3_DONTSPLASH;
	GetDefaultByName("RevenantTracer")->RenderStyle=STYLE_Normal;
	for(int i=0; nobrightset[i]; i++) SetNoBright(nobrightset[i], true);
	SetNoBright("HealthBonus", false, true);

	for(int i=0; countitemset[i]; i++) GetDefaultByName(countitemset[i])->flags|=MF_COUNTITEM;

	AActor * ai;

	ai=GetDefaultByName("Soulsphere");
	ai->RenderStyle = STYLE_Translucent;
	ai->alpha = FRACUNIT/2;
	ai=GetDefaultByName("InvulnerabilitySphere");
	ai->RenderStyle = STYLE_Translucent;
	ai->alpha = FRACUNIT/2;
	ai=GetDefaultByName("Megasphere");
	ai->RenderStyle = STYLE_Translucent;
	ai->alpha = FRACUNIT*7/10;

	// Ironlich
	SetNoBright("HeadFX1", false, true);
	SetNoBright("HeadFX2", false, true);
	SetNoBright("HeadFX3", false, true);
	ai=GetDefaultByName("HeadFX1");
	ai->RenderStyle = STYLE_Add;
	ai=GetDefaultByName("HeadFX2");
	ai->RenderStyle = STYLE_Add;
	ai=GetDefaultByName("HeadFX3");
	ai->RenderStyle = STYLE_Add;

	Init_HookSave = gl_DebugHook;
	gl_DebugHook = Init_Start;
}

//-----------------------------------------------------------------------------
//
// Adjust sprite offsets for GL rendering
//
//-----------------------------------------------------------------------------

void Init_Start()
{
	static bool done=false;
	char name[30];

	if (Init_HookSave) Init_HookSave();
	if (done) return;
	done=true;

	sprintf(name, "%s.sprofs", GameNames[gameinfo.gametype]);
	int lump = Wads.CheckNumForFullName(name);
	if (lump>=0)
	{
		SC_OpenLumpNum(lump, name);
		FGLTexture::FlushAll();
		while (SC_GetString())
		{
			int x,y;
			int texno = TexMan.CheckForTexture(sc_String, FTexture::TEX_Sprite);
			SC_GetNumber();
			x=sc_Number;
			SC_GetNumber();
			y=sc_Number;

			if (texno>0)
			{
				FAccessTexture * tex = static_cast<FAccessTexture*>(TexMan[texno]);
				// This is dirty programming so a crash might happen in rare circumstances!
				try
				{
					// We only want to change texture offsets for sprites in the IWAD!
					if (tex->SourceLump>=0 && tex->SourceLump<Wads.GetNumLumps())
					{
						int wadno = Wads.GetLumpFile(tex->SourceLump);
						if (wadno==FWadCollection::IWAD_FILENUM)
						{
							tex->GetWidth();	// force initialization of the texture
							/*
							Printf("Changing sprite offset of %s from (%d,%d) to (%d,%d)\n",
								tex->Name, tex->LeftOffset, tex->TopOffset, x, y);
							*/
							tex->LeftOffset=x;
							tex->TopOffset=y;
							if (tex->gltex)
							{
								delete tex->gltex;
								tex->gltex=NULL;
							}

						}
					}
				}
				catch(...)
				{
				}
			}
		}
		SC_Close();
	}
}


//-----------------------------------------------------------------------------
//
// Some map testing commands
//
//-----------------------------------------------------------------------------
BOOL CheckCheatmode ();


//-----------------------------------------------------------------------------
//
//
//
//-----------------------------------------------------------------------------
CCMD(linetarget)
{
	if (CheckCheatmode ()) return;
	P_AimLineAttack(players[consoleplayer].mo,players[consoleplayer].mo->angle,MISSILERANGE, 0);
	if (linetarget)
	{
		Printf("Target=%s, Health=%d, Spawnhealth=%d\n",linetarget->GetName(),linetarget->health,linetarget->GetDefault()->health);
	}
	else Printf("No target found\n");
}

//-----------------------------------------------------------------------------
//
//
//
//-----------------------------------------------------------------------------
CCMD(monster)
{
	AActor * mo;

	if (CheckCheatmode ()) return;
	TThinkerIterator<AActor> it;

	while (mo=it.Next())
	{
		if (mo->flags3&MF3_ISMONSTER && !(mo->flags&MF_CORPSE) && !(mo->flags&MF_FRIENDLY))
		{
			Printf ("%s at (%d,%d,%d)\n",mo->GetName(),mo->x>>16,mo->y>>16,mo->z>>16);
		}
	}
}

//-----------------------------------------------------------------------------
//
//
//
//-----------------------------------------------------------------------------
CCMD(items)
{
	AActor * mo;

	if (CheckCheatmode ()) return;
	TThinkerIterator<AActor> it;

	while (mo=it.Next())
	{
		if (mo->IsKindOf(RUNTIME_CLASS(AInventory)) && mo->flags%MF_SPECIAL)
		{
			Printf ("%s at (%d,%d,%d)\n",mo->GetName(),mo->x>>16,mo->y>>16,mo->z>>16);
		}
	}
}

//-----------------------------------------------------------------------------
//
//
//
//-----------------------------------------------------------------------------
CCMD(nextmap)
{
	char * next=NULL;
	
	if (*level.secretmap) next = level.secretmap;
	else if (*level.nextmap) next = level.nextmap;
	if (next && !strncmp(next, "enDSeQ", 6)) next=NULL;

	if (next)
	{
		G_InitNew(next, false);
	}
	else
	{
		Printf("no next map!\n");
	}
}

CCMD(endlevel)
{
	if (argv.argc()<2 || strtol(argv[1], NULL, 0)==0) G_ExitLevel(0, false);
	else G_SecretExitLevel(0);
}


CCMD(playertid)
{
	if (argv.argc()>1)
	{
		players[0].mo->RemoveFromHash();
		players[0].mo->tid = atoi(argv[1]);
		players[0].mo->AddToHash();
		Printf("Player tid changed to %s\n", argv[1]);
	}
	else
	{
		Printf("Player tid is %d\n", players[0].mo->tid);
	}
}

CCMD(changesky)
{
	const char *sky1name;

	if (argv.argc()<2) return;

	sky1name = argv[1];
	if (sky1name[0] != 0)
	{
		strncpy (level.skypic1, sky1name, 8);
		sky1texture = TexMan.GetTexture (sky1name, FTexture::TEX_Wall, FTextureManager::TEXMAN_Overridable);
	}
	R_InitSkyMap ();
	sky1pos = sky2pos = 0;
}