#define HLSL_SOURCE_CODE 0
#define SHADER_ASSEMBLY_CODE 0

// A paletted texture shader ------------------------------------------------

#if HLSL_SOURCE_CODE
sampler2D Image : register(s0);
sampler1D Palette : register(s1);
float4 PaletteMod : register(c2);

float4 main (float2 texCoord : TEXCOORD0, float4 Flash : COLOR0, float4 InvFlash : COLOR1) : COLOR
{
	float index = tex2D (Image, texCoord).x;
	index = index * PaletteMod.x + PaletteMod.y;
	float4 rgb = tex1D (Palette, index);
	return Flash + rgb * InvFlash;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.15.779.0000
//
//   fxc paltex.ps /Tps_1_4 /LD /VnPalTexShader14Def /Fhpaltex.h
//
//
// Parameters:
//
//   sampler2D Image;
//   sampler1D Palette;
//   float4 PaletteMod;
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   PaletteMod   c2       1
//   Image        s0       1
//   Palette      s1       1
//

    ps_1_4
    texld r0, t0
    mad r0.xy, r0.x, c2.x, c2.y
    phase
    texld r1, r0
    mad r0, r1, v1, v0

// approximately 4 instruction slots used (2 texture, 2 arithmetic)
#endif

const DWORD PalTexShader14Def[] =
{
    0xffff0104, 0x0039fffe, 0x42415443, 0x0000001c, 0x000000ab, 0xffff0104,
    0x00000003, 0x0000001c, 0x00000100, 0x000000a4, 0x00000058, 0x00000003,
    0x00000001, 0x00000060, 0x00000000, 0x00000070, 0x00010003, 0x00000001,
    0x00000078, 0x00000000, 0x00000088, 0x00020002, 0x00020001, 0x00000094,
    0x00000000, 0x67616d49, 0xabab0065, 0x000c0004, 0x00010001, 0x00000001,
    0x00000000, 0x656c6150, 0x00657474, 0x000b0004, 0x00010001, 0x00000001,
    0x00000000, 0x656c6150, 0x4d657474, 0xab00646f, 0x00030001, 0x00040001,
    0x00000001, 0x00000000, 0x315f7370, 0x4d00345f, 0x6f726369, 0x74666f73,
    0x29522820, 0x44334420, 0x53203958, 0x65646168, 0x6f432072, 0x6c69706d,
    0x39207265, 0x2e35312e, 0x2e393737, 0x30303030, 0xababab00, 0x00000042,
    0x800f0000, 0xb0e40000, 0x00000004, 0x80030000, 0x80000000, 0xa0000002,
    0xa0550002, 0x0000fffd, 0x00000042, 0x800f0001, 0x80e40000, 0x00000004,
    0x800f0000, 0x80e40001, 0x90e40001, 0x90e40000, 0x0000ffff
};

#if SHADER_ASSEMBLY_CODE
    ps_2_0
    dcl t0.xy
    dcl v0
    dcl v1
    dcl_2d s0
    dcl_2d s1
    texld r0, t0, s0
    mad r0.xy, r0.x, c2.x, c2.y
    texld r0, r0, s1
    mov r1, v1
    mad r0, r0, r1, v0
    mov oC0, r0

// approximately 6 instruction slots used (2 texture, 4 arithmetic)
#endif

const DWORD PalTexShader20Def[] =
{
    0xffff0200, 0x0039fffe, 0x42415443, 0x0000001c, 0x000000ab, 0xffff0200,
    0x00000003, 0x0000001c, 0x00000100, 0x000000a4, 0x00000058, 0x00000003,
    0x00000001, 0x00000060, 0x00000000, 0x00000070, 0x00010003, 0x00000001,
    0x00000078, 0x00000000, 0x00000088, 0x00020002, 0x00020001, 0x00000094,
    0x00000000, 0x67616d49, 0xabab0065, 0x000c0004, 0x00010001, 0x00000001,
    0x00000000, 0x656c6150, 0x00657474, 0x000b0004, 0x00010001, 0x00000001,
    0x00000000, 0x656c6150, 0x4d657474, 0xab00646f, 0x00030001, 0x00040001,
    0x00000001, 0x00000000, 0x325f7370, 0x4d00305f, 0x6f726369, 0x74666f73,
    0x29522820, 0x44334420, 0x53203958, 0x65646168, 0x6f432072, 0x6c69706d,
    0x39207265, 0x2e35312e, 0x2e393737, 0x30303030, 0xababab00, 0x0200001f,
    0x80000000, 0xb0030000, 0x0200001f, 0x80000000, 0x900f0000, 0x0200001f,
    0x80000000, 0x900f0001, 0x0200001f, 0x90000000, 0xa00f0800, 0x0200001f,
    0x90000000, 0xa00f0801, 0x03000042, 0x800f0000, 0xb0e40000, 0xa0e40800,
    0x04000004, 0x80030000, 0x80000000, 0xa0000002, 0xa0550002, 0x03000042,
    0x800f0000, 0x80e40000, 0xa0e40801, 0x02000001, 0x800f0001, 0x90e40001,
    0x04000004, 0x800f0000, 0x80e40000, 0x80e40001, 0x90e40000, 0x02000001,
    0x800f0800, 0x80e40000, 0x0000ffff
};

// A paletted texture shader that does bilinear filtering -------------------

#if HLSL_SOURCE_CODE
sampler2D Image : register(s0);
sampler2D Palette : register(s1);
float4 Flash : register(c0);
float4 InvFlash : register(c1);
float4 PaletteMod : register(c2);

//#define texture_size_x 512.0f
//#define texture_size_y 256.0f
//#define texel_size_x 1.0f / 512.0f
//#define texel_size_y 1.0f / 256.0f

// texture_size_x, texture_size_y, 0, texel_size_x
float4 size_a : register(c3);

// 0, texel_size_y, texel_size_y, texel_size_x
float4 size_b : register(c4);

float4 main (float2 texCoord : TEXCOORD0) : COLOR
{
	float2 f = frac (texCoord.xy * size_a/*float2(texture_size_x, texture_size_y)*/);

	float4 t00 = tex2D(Image, texCoord);
	float4 t10 = tex2D(Image, texCoord + size_a.wz/*float2(texel_size_x, 0)*/);

	t00.x = t00.x * PaletteMod.x + PaletteMod.y;
	t10.x = t10.x * PaletteMod.x + PaletteMod.y;

	float4 c00 = tex2D(Palette, t00);
	float4 c10 = tex2D(Palette, t10);

	float4 cA = lerp(c00, c10, f.x);

	float4 t01 = tex2D(Image, texCoord + size_b.xy/*float2(0, texel_size_y)*/);
	float4 t11 = tex2D(Image, texCoord + size_b.wz/*float2(texel_size_x, texel_size_y)*/);

	t01.x = t01.x * PaletteMod.x + PaletteMod.y;
	t11.x = t11.x * PaletteMod.x + PaletteMod.y;

	float4 c01 = tex2D(Palette, t01);
	float4 c11 = tex2D(Palette, t11);

	float4 cB = lerp(c01, c11, f.x);

	return Flash + lerp(cA, cB, f.y) * InvFlash;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) HLSL Shader Compiler 9.19.949.2111
//
//   fxc paltex_bilinear.ps /Tps_2_0 /VnPalTexBilinearDef /Fhpaltex_bilinea
//
//
// Parameters:
//
//   float4 Flash;
//   sampler2D Image;
//   float4 InvFlash;
//   sampler2D Palette;
//   float4 PaletteMod;
//   float4 size_a;
//   float4 size_b;
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   Flash        c0       1
//   InvFlash     c1       1
//   PaletteMod   c2       1
//   size_a       c3       1
//   size_b       c4       1
//   Image        s0       1
//   Palette      s1       1
//

    ps_2_0
    dcl t0.xy
    dcl_2d s0
    dcl_2d s1
    add r0.xy, t0, c4
    add r1.xy, t0, c4.wzyx
    add r2.xy, t0, c3.wzyx
    texld r0, r0, s0
    texld r1, r1, s0
    texld r2, r2, s0
    texld r3, t0, s0
    mad r0.x, r0.x, c2.x, c2.y
    mad r1.x, r1.x, c2.x, c2.y
    mad r2.x, r2.x, c2.x, c2.y
    mad r3.x, r3.x, c2.x, c2.y
    texld r0, r0, s1
    texld r1, r1, s1
    texld r2, r2, s1
    texld r3, r3, s1
    mul r4.xy, t0, c3
    frc r4.xy, r4
    lrp r5, r4.x, r1, r0
    lrp r0, r4.x, r2, r3
    lrp r1, r4.y, r5, r0
    mov r0, c1
    mad r0, r1, r0, c0
    mov oC0, r0

// approximately 23 instruction slots used (8 texture, 15 arithmetic)
#endif

const DWORD PalTexBilinearDef[] =
{
    0xffff0200, 0x0050fffe, 0x42415443, 0x0000001c, 0x00000109, 0xffff0200,
    0x00000007, 0x0000001c, 0x20000100, 0x00000102, 0x000000a8, 0x00000002,
    0x00020001, 0x000000b0, 0x00000000, 0x000000c0, 0x00000003, 0x00020001,
    0x000000c8, 0x00000000, 0x000000d8, 0x00010002, 0x00060001, 0x000000b0,
    0x00000000, 0x000000e1, 0x00010003, 0x00060001, 0x000000c8, 0x00000000,
    0x000000e9, 0x00020002, 0x000a0001, 0x000000b0, 0x00000000, 0x000000f4,
    0x00030002, 0x000e0001, 0x000000b0, 0x00000000, 0x000000fb, 0x00040002,
    0x00120001, 0x000000b0, 0x00000000, 0x73616c46, 0xabab0068, 0x00030001,
    0x00040001, 0x00000001, 0x00000000, 0x67616d49, 0xabab0065, 0x000c0004,
    0x00010001, 0x00000001, 0x00000000, 0x46766e49, 0x6873616c, 0x6c615000,
    0x65747465, 0x6c615000, 0x65747465, 0x00646f4d, 0x657a6973, 0x7300615f,
    0x5f657a69, 0x73700062, 0x305f325f, 0x63694d00, 0x6f736f72, 0x28207466,
    0x48202952, 0x204c534c, 0x64616853, 0x43207265, 0x69706d6f, 0x2072656c,
    0x39312e39, 0x3934392e, 0x3131322e, 0xabab0031, 0x0200001f, 0x80000000,
    0xb0030000, 0x0200001f, 0x90000000, 0xa00f0800, 0x0200001f, 0x90000000,
    0xa00f0801, 0x03000002, 0x80030000, 0xb0e40000, 0xa0e40004, 0x03000002,
    0x80030001, 0xb0e40000, 0xa01b0004, 0x03000002, 0x80030002, 0xb0e40000,
    0xa01b0003, 0x03000042, 0x800f0000, 0x80e40000, 0xa0e40800, 0x03000042,
    0x800f0001, 0x80e40001, 0xa0e40800, 0x03000042, 0x800f0002, 0x80e40002,
    0xa0e40800, 0x03000042, 0x800f0003, 0xb0e40000, 0xa0e40800, 0x04000004,
    0x80010000, 0x80000000, 0xa0000002, 0xa0550002, 0x04000004, 0x80010001,
    0x80000001, 0xa0000002, 0xa0550002, 0x04000004, 0x80010002, 0x80000002,
    0xa0000002, 0xa0550002, 0x04000004, 0x80010003, 0x80000003, 0xa0000002,
    0xa0550002, 0x03000042, 0x800f0000, 0x80e40000, 0xa0e40801, 0x03000042,
    0x800f0001, 0x80e40001, 0xa0e40801, 0x03000042, 0x800f0002, 0x80e40002,
    0xa0e40801, 0x03000042, 0x800f0003, 0x80e40003, 0xa0e40801, 0x03000005,
    0x80030004, 0xb0e40000, 0xa0e40003, 0x02000013, 0x80030004, 0x80e40004,
    0x04000012, 0x800f0005, 0x80000004, 0x80e40001, 0x80e40000, 0x04000012,
    0x800f0000, 0x80000004, 0x80e40002, 0x80e40003, 0x04000012, 0x800f0001,
    0x80550004, 0x80e40005, 0x80e40000, 0x02000001, 0x800f0000, 0xa0e40001,
    0x04000004, 0x800f0000, 0x80e40001, 0x80e40000, 0xa0e40000, 0x02000001,
    0x800f0800, 0x80e40000, 0x0000ffff
};

// A shader that doesn't look up colors from a palette. ---------------------
// Can be used for RGB textures.

#if HLSL_SOURCE_CODE
sampler2D Image : register(s0);

float4 main (float2 texCoord : TEXCOORD0, float4 Flash : COLOR0, float4 InvFlash : COLOR1) : COLOR
{
  float4 index = tex2D (Image, texCoord);
  return Flash + index * InvFlash;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.15.779.0000
//
//   fxc plain.ps /Tps_1_1 /LD /VnPlainShaderDef /Fhplain.h
//
//
// Parameters:
//
//   sampler2D Image;
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   Image        s0       1
//

    ps_1_1
    tex t0
    mad r0, t0, v1, v0

// approximately 2 instruction slots used (1 texture, 1 arithmetic)
#endif

const DWORD PlainShaderDef[] =
{
    0xffff0101, 0x0022fffe, 0x42415443, 0x0000001c, 0x0000004f, 0xffff0101,
    0x00000001, 0x0000001c, 0x00000100, 0x00000048, 0x00000030, 0x00000003,
    0x00000001, 0x00000038, 0x00000000, 0x67616d49, 0xabab0065, 0x000c0004,
    0x00010001, 0x00000001, 0x00000000, 0x315f7370, 0x4d00315f, 0x6f726369,
    0x74666f73, 0x29522820, 0x44334420, 0x53203958, 0x65646168, 0x6f432072,
    0x6c69706d, 0x39207265, 0x2e35312e, 0x2e393737, 0x30303030, 0xababab00,
    0x00000042, 0xb00f0000, 0x00000004, 0x800f0000, 0xb0e40000, 0x90e40001,
    0x90e40000, 0x0000ffff
};

// A shader that uses vertex color and texture alpha ------------------------

#if HLSL_SOURCE_CODE
sampler2D Image : register(s0);

float4 main (float2 texCoord : TEXCOORD0, float4 StencilColor : COLOR1) : COLOR
{
  float4 color = tex2D (Image, texCoord);
  color.rgb = StencilColor.rgb;
  return color;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.15.779.0000
//
//   fxc plainstencil.ps /Tps_1_1 /LD /VnPlainStencilDef /Fhplainstencil.h
//
//
// Parameters:
//
//   sampler2D Image;
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   Image        s0       1
//

    ps_1_1
    tex t0
    mov r0.xyz, v1
  + mov r0.w, t0.w

// approximately 2 instruction slots used (1 texture, 1 arithmetic)
#endif

const DWORD PlainStencilDef[] =
{
    0xffff0101, 0x0022fffe, 0x42415443, 0x0000001c, 0x0000004f, 0xffff0101,
    0x00000001, 0x0000001c, 0x00000100, 0x00000048, 0x00000030, 0x00000003,
    0x00000001, 0x00000038, 0x00000000, 0x67616d49, 0xabab0065, 0x000c0004,
    0x00010001, 0x00000001, 0x00000000, 0x315f7370, 0x4d00315f, 0x6f726369,
    0x74666f73, 0x29522820, 0x44334420, 0x53203958, 0x65646168, 0x6f432072,
    0x6c69706d, 0x39207265, 0x2e35312e, 0x2e393737, 0x30303030, 0xababab00,
    0x00000042, 0xb00f0000, 0x00000001, 0x80070000, 0x90e40001, 0x40000001,
    0x80080000, 0xb0ff0000, 0x0000ffff
};

// A shader that just returns the first color component from the vertex -----

#if HLSL_SOURCE_CODE
float4 main (float4 color : COLOR0) : COLOR
{
  return color;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.15.779.0000
//
//   fxc coloronlyshader.ps /Tps_1_1 /LD /VnColorOnlyDef /Fhcoloronly.h
//
    ps_1_1
    mov r0, v0

// approximately 1 instruction slot used
#endif

const DWORD ColorOnlyDef[] =
{
    0xffff0101, 0x0017fffe, 0x42415443, 0x0000001c, 0x00000023, 0xffff0101,
    0x00000000, 0x00000000, 0x00000100, 0x0000001c, 0x315f7370, 0x4d00315f,
    0x6f726369, 0x74666f73, 0x29522820, 0x44334420, 0x53203958, 0x65646168,
    0x6f432072, 0x6c69706d, 0x39207265, 0x2e35312e, 0x2e393737, 0x30303030,
    0xababab00, 0x00000001, 0x800f0000, 0x90e40000, 0x0000ffff
};

// A shader that just corrects gamma for windowed mode ----------------------

#if HLSL_SOURCE_CODE
sampler2D Image : register(s0);
float4 Gamma : register(c7);

float4 main (float2 texCoord : TEXCOORD0) : COLOR
{
  float4 color = tex2D (Image, texCoord);
  color.xyz = pow(color.xyz, Gamma.xyz);
  return color;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) HLSL Shader Compiler 9.19.949.2111
//
//   fxc gammafixer.ps /Tps_2_0 /VnGammaFixerDef /Fhgammafixer.h
//
//
// Parameters:
//
//   float4 Gamma;
//   sampler2D Image;
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   Gamma        c7       1
//   Image        s0       1
//

    ps_2_0
    dcl t0.xy
    dcl_2d s0
    texld r0, t0, s0
    log r1.x, r0.x
    log r1.y, r0.y
    log r1.z, r0.z
    mul r1.xyz, r1, c7
    exp r0.x, r1.x
    exp r0.y, r1.y
    exp r0.z, r1.z
    mov oC0, r0

// approximately 9 instruction slots used (1 texture, 8 arithmetic)
#endif

const DWORD GammaFixerDef[] =
{
    0xffff0200, 0x002cfffe, 0x42415443, 0x0000001c, 0x0000007b, 0xffff0200,
    0x00000002, 0x0000001c, 0x20000100, 0x00000074, 0x00000044, 0x00070002,
    0x001e0001, 0x0000004c, 0x00000000, 0x0000005c, 0x00000003, 0x00020001,
    0x00000064, 0x00000000, 0x6d6d6147, 0xabab0061, 0x00030001, 0x00040001,
    0x00000001, 0x00000000, 0x67616d49, 0xabab0065, 0x000c0004, 0x00010001,
    0x00000001, 0x00000000, 0x325f7370, 0x4d00305f, 0x6f726369, 0x74666f73,
    0x29522820, 0x534c4820, 0x6853204c, 0x72656461, 0x6d6f4320, 0x656c6970,
    0x2e392072, 0x392e3931, 0x322e3934, 0x00313131, 0x0200001f, 0x80000000,
    0xb0030000, 0x0200001f, 0x90000000, 0xa00f0800, 0x03000042, 0x800f0000,
    0xb0e40000, 0xa0e40800, 0x0200000f, 0x80010001, 0x80000000, 0x0200000f,
    0x80020001, 0x80550000, 0x0200000f, 0x80040001, 0x80aa0000, 0x03000005,
    0x80070001, 0x80e40001, 0xa0e40007, 0x0200000e, 0x80010000, 0x80000001,
    0x0200000e, 0x80020000, 0x80550001, 0x0200000e, 0x80040000, 0x80aa0001,
    0x02000001, 0x800f0800, 0x80e40000, 0x0000ffff
};

// The shader used by the burn effect screen wipe ---------------------------

#if HLSL_SOURCE_CODE
sampler2D NewScreen : register(s0);
sampler2D Burn : register(s1);

float4 main (float2 coord[2] : TEXCOORD0) : COLOR
{
	float4 color = tex2D(NewScreen, coord[0]);
	float4 alpha = tex2D(Burn, coord[1]);
	color.a = alpha.r * 2;
	return color;
}
#elif SHADER_ASSEMBLY_CODE
//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.15.779.0000
//
//   fxc burn.ps /Tps_1_4 /VnBurnShaderDef /Fhburn.h /LD
//
//
// Parameters:
//
//   sampler2D Burn;
//   sampler2D NewScreen;
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   NewScreen    s0       1
//   Burn         s1       1
//

    ps_1_4
    texld r0, t0
    texld r1, t1
    add r0.w, r1.x, r1.x
  + mov r0.xyz, r0

// approximately 3 instruction slots used (2 texture, 1 arithmetic)
#endif

const DWORD BurnShaderDef[] =
{
    0xffff0104, 0x0029fffe, 0x42415443, 0x0000001c, 0x0000006d, 0xffff0104,
    0x00000002, 0x0000001c, 0x00000100, 0x00000066, 0x00000044, 0x00010003,
    0x00000001, 0x0000004c, 0x00000000, 0x0000005c, 0x00000003, 0x00000001,
    0x0000004c, 0x00000000, 0x6e727542, 0xababab00, 0x000c0004, 0x00010001,
    0x00000001, 0x00000000, 0x5377654e, 0x65657263, 0x7370006e, 0x345f315f,
    0x63694d00, 0x6f736f72, 0x28207466, 0x44202952, 0x39584433, 0x61685320,
    0x20726564, 0x706d6f43, 0x72656c69, 0x312e3920, 0x37372e35, 0x30302e39,
    0xab003030, 0x00000042, 0x800f0000, 0xb0e40000, 0x00000042, 0x800f0001,
    0xb0e40001, 0x00000002, 0x80080000, 0x80000001, 0x80000001, 0x40000001,
    0x80070000, 0x80e40000, 0x0000ffff
};
