/* Generated by re2c 0.10.5 */
#line 1 "scanner.re"
/* $Id: scanner.re,v 1.42 2006/04/17 00:18:45 helly Exp $ */
#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <sstream>
#include "scanner.h"
#include "parser.h"
#include "y.tab.h"
#include "globals.h"
#include "dfa.h"

extern YYSTYPE yylval;

#ifndef MAX
#define MAX(a,b) (((a)>(b))?(a):(b))
#endif

#define	BSIZE	8192

#define	YYCTYPE		char
#define	YYCURSOR	cursor
#define	YYLIMIT		lim
#define	YYMARKER	ptr
#define	YYFILL(n)	{cursor = fill(cursor);}

#define	RETURN(i)	{cur = cursor; return i;}

namespace re2c
{

Scanner::Scanner(const char *fn, std::istream& i, std::ostream& o)
	: in(i)
	, out(o)
	, bot(NULL), tok(NULL), ptr(NULL), cur(NULL), pos(NULL), lim(NULL)
	, top(NULL), eof(NULL), tchar(0), tline(0), cline(1), iscfg(0), filename(fn)
{
    ;
}

char *Scanner::fill(char *cursor)
{
	if(!eof)
	{
		uint cnt = tok - bot;
		if(cnt)
		{
			memcpy(bot, tok, lim - tok);
			tok = bot;
			ptr -= cnt;
			cursor -= cnt;
			pos -= cnt;
			lim -= cnt;
		}
		if((top - lim) < BSIZE)
		{
			char *buf = new char[(lim - bot) + BSIZE];
			memcpy(buf, tok, lim - tok);
			tok = buf;
			ptr = &buf[ptr - bot];
			cursor = &buf[cursor - bot];
			pos = &buf[pos - bot];
			lim = &buf[lim - bot];
			top = &lim[BSIZE];
			delete [] bot;
			bot = buf;
		}
		in.read(lim, BSIZE);
		if ((cnt = in.gcount()) != BSIZE )
		{
			eof = &lim[cnt]; *eof++ = '\0';
		}
		lim += cnt;
	}
	return cursor;
}

#line 95 "scanner.re"


int Scanner::echo()
{
    char *cursor = cur;
    bool ignore_eoc = false;
    int  ignore_cnt = 0;

    if (eof && cursor == eof) // Catch EOF
	{
    	return 0;
	}

    tok = cursor;
echo:

#line 97 "scanner.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;

	if((YYLIMIT - YYCURSOR) < 16) YYFILL(16);
	yych = *YYCURSOR;
	if(yych <= ')') {
		if(yych <= 0x00) goto yy7;
		if(yych == 0x0A) goto yy5;
		goto yy9;
	} else {
		if(yych <= '*') goto yy4;
		if(yych != '/') goto yy9;
	}
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == '*') goto yy16;
yy3:
#line 184 "scanner.re"
	{
					goto echo;
				}
#line 120 "scanner.cc"
yy4:
	yych = *++YYCURSOR;
	if(yych == '/') goto yy10;
	goto yy3;
yy5:
	++YYCURSOR;
#line 167 "scanner.re"
	{
					if (ignore_eoc) {
						ignore_cnt++;
					} else {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					}
					tok = pos = cursor; cline++;
				  	goto echo;
				}
#line 137 "scanner.cc"
yy7:
	++YYCURSOR;
#line 176 "scanner.re"
	{
					if (!ignore_eoc) {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok) - 1); // -1 so we don't write out the \0
					}
					if(cursor == eof) {
						RETURN(0);
					}
				}
#line 149 "scanner.cc"
yy9:
	yych = *++YYCURSOR;
	goto yy3;
yy10:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A) goto yy14;
	if(yych == 0x0D) goto yy12;
yy11:
#line 154 "scanner.re"
	{
					if (ignore_eoc) {
						if (ignore_cnt) {
							out << "\n" << sourceFileInfo;
						}
						ignore_eoc = false;
						ignore_cnt = 0;
					} else {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					}
					tok = pos = cursor;
					goto echo;
				}
#line 173 "scanner.cc"
yy12:
	yych = *++YYCURSOR;
	if(yych == 0x0A) goto yy14;
yy13:
	YYCURSOR = YYMARKER;
	if(yyaccept <= 0) {
		goto yy3;
	} else {
		goto yy11;
	}
yy14:
	++YYCURSOR;
#line 140 "scanner.re"
	{
					cline++;
					if (ignore_eoc) {
						if (ignore_cnt) {
							out << sourceFileInfo;
						}
						ignore_eoc = false;
						ignore_cnt = 0;
					} else {
						out.write((const char*)(tok), (const char*)(cursor) - (const char*)(tok));
					}
					tok = pos = cursor;
					goto echo;
				}
#line 201 "scanner.cc"
yy16:
	yych = *++YYCURSOR;
	if(yych != '!') goto yy13;
	yych = *++YYCURSOR;
	switch(yych){
	case 'g':	goto yy19;
	case 'i':	goto yy18;
	case 'm':	goto yy20;
	case 'r':	goto yy21;
	default:	goto yy13;
	}
yy18:
	yych = *++YYCURSOR;
	if(yych == 'g') goto yy47;
	goto yy13;
yy19:
	yych = *++YYCURSOR;
	if(yych == 'e') goto yy34;
	goto yy13;
yy20:
	yych = *++YYCURSOR;
	if(yych == 'a') goto yy26;
	goto yy13;
yy21:
	yych = *++YYCURSOR;
	if(yych != 'e') goto yy13;
	yych = *++YYCURSOR;
	if(yych != '2') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'c') goto yy13;
	++YYCURSOR;
#line 111 "scanner.re"
	{
					if (bUsedYYMaxFill && bSinglePass) {
						fatal("found scanner block after YYMAXFILL declaration");
					}
					out.write((const char*)(tok), (const char*)(&cursor[-7]) - (const char*)(tok));
					tok = cursor;
					RETURN(1);
				}
#line 242 "scanner.cc"
yy26:
	yych = *++YYCURSOR;
	if(yych != 'x') goto yy13;
	yych = *++YYCURSOR;
	if(yych != ':') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'r') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'e') goto yy13;
	yych = *++YYCURSOR;
	if(yych != '2') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'c') goto yy13;
	++YYCURSOR;
#line 119 "scanner.re"
	{
					if (bUsedYYMaxFill) {
						fatal("cannot generate YYMAXFILL twice");
					}
					out << "#define YYMAXFILL " << maxFill << std::endl;
					tok = pos = cursor;
					ignore_eoc = true;
					bUsedYYMaxFill = true;
					goto echo;
				}
#line 268 "scanner.cc"
yy34:
	yych = *++YYCURSOR;
	if(yych != 't') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 's') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 't') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'a') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 't') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'e') goto yy13;
	yych = *++YYCURSOR;
	if(yych != ':') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'r') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'e') goto yy13;
	yych = *++YYCURSOR;
	if(yych != '2') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'c') goto yy13;
	++YYCURSOR;
#line 129 "scanner.re"
	{
					tok = pos = cursor;
					genGetState(out, topIndent, 0);
					ignore_eoc = true;
					goto echo;
				}
#line 300 "scanner.cc"
yy47:
	yych = *++YYCURSOR;
	if(yych != 'n') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'o') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'r') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'e') goto yy13;
	yych = *++YYCURSOR;
	if(yych != ':') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'r') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'e') goto yy13;
	yych = *++YYCURSOR;
	if(yych != '2') goto yy13;
	yych = *++YYCURSOR;
	if(yych != 'c') goto yy13;
	++YYCURSOR;
#line 135 "scanner.re"
	{
					tok = pos = cursor;
					ignore_eoc = true;
					goto echo;
				}
#line 327 "scanner.cc"
}
#line 187 "scanner.re"

}


int Scanner::scan()
{
    char *cursor = cur;
    uint depth;

scan:
    tchar = cursor - pos;
    tline = cline;
    tok = cursor;
	if (iscfg == 1)
	{
		goto config;
	}
	else if (iscfg == 2)
	{
   		goto value;
    }

#line 352 "scanner.cc"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if(yych <= '/') {
		if(yych <= '!') {
			if(yych <= 0x0C) {
				if(yych <= 0x08) goto yy85;
				if(yych <= 0x09) goto yy79;
				if(yych <= 0x0A) goto yy81;
				goto yy85;
			} else {
				if(yych <= 0x0D) goto yy83;
				if(yych == ' ') goto yy79;
				goto yy85;
			}
		} else {
			if(yych <= ')') {
				if(yych <= '"') goto yy66;
				if(yych <= '&') goto yy85;
				if(yych <= '\'') goto yy68;
				goto yy72;
			} else {
				if(yych <= '+') {
					if(yych <= '*') goto yy64;
					goto yy73;
				} else {
					if(yych <= '-') goto yy85;
					if(yych <= '.') goto yy77;
					goto yy62;
				}
			}
		}
	} else {
		if(yych <= 'Z') {
			if(yych <= '=') {
				if(yych == ';') goto yy72;
				if(yych <= '<') goto yy85;
				goto yy72;
			} else {
				if(yych == '?') goto yy73;
				if(yych <= '@') goto yy85;
				goto yy76;
			}
		} else {
			if(yych <= 'q') {
				if(yych <= '[') goto yy70;
				if(yych <= '\\') goto yy72;
				if(yych <= '`') goto yy85;
				goto yy76;
			} else {
				if(yych <= 'z') {
					if(yych <= 'r') goto yy74;
					goto yy76;
				} else {
					if(yych <= '{') goto yy60;
					if(yych <= '|') goto yy72;
					goto yy85;
				}
			}
		}
	}
yy60:
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/') {
		if(yych == ',') goto yy126;
	} else {
		if(yych <= '0') goto yy123;
		if(yych <= '9') goto yy124;
	}
yy61:
#line 209 "scanner.re"
	{ depth = 1;
				  goto code;
				}
#line 430 "scanner.cc"
yy62:
	++YYCURSOR;
	if((yych = *YYCURSOR) == '*') goto yy121;
yy63:
#line 239 "scanner.re"
	{ RETURN(*tok); }
#line 437 "scanner.cc"
yy64:
	++YYCURSOR;
	if((yych = *YYCURSOR) == '/') goto yy119;
yy65:
#line 241 "scanner.re"
	{ yylval.op = *tok;
				  RETURN(CLOSE); }
#line 445 "scanner.cc"
yy66:
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != 0x0A) goto yy115;
yy67:
#line 226 "scanner.re"
	{ fatal("unterminated string constant (missing \")"); }
#line 453 "scanner.cc"
yy68:
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != 0x0A) goto yy110;
yy69:
#line 227 "scanner.re"
	{ fatal("unterminated string constant (missing ')"); }
#line 461 "scanner.cc"
yy70:
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A) goto yy71;
	if(yych == '^') goto yy101;
	goto yy100;
yy71:
#line 237 "scanner.re"
	{ fatal("unterminated range (missing ])"); }
#line 471 "scanner.cc"
yy72:
	yych = *++YYCURSOR;
	goto yy63;
yy73:
	yych = *++YYCURSOR;
	goto yy65;
yy74:
	++YYCURSOR;
	if((yych = *YYCURSOR) == 'e') goto yy91;
	goto yy90;
yy75:
#line 268 "scanner.re"
	{ cur = cursor;
				  yylval.symbol = Symbol::find(token());
				  return ID; }
#line 487 "scanner.cc"
yy76:
	yych = *++YYCURSOR;
	goto yy90;
yy77:
	++YYCURSOR;
#line 272 "scanner.re"
	{ cur = cursor;
				  yylval.regexp = mkDot();
				  return RANGE;
				}
#line 498 "scanner.cc"
yy79:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy88;
yy80:
#line 277 "scanner.re"
	{ goto scan; }
#line 506 "scanner.cc"
yy81:
	++YYCURSOR;
yy82:
#line 279 "scanner.re"
	{ if(cursor == eof) RETURN(0);
				  pos = cursor; cline++;
				  goto scan;
	    			}
#line 515 "scanner.cc"
yy83:
	++YYCURSOR;
	if((yych = *YYCURSOR) == 0x0A) goto yy86;
yy84:
#line 284 "scanner.re"
	{ std::ostringstream msg;
				  msg << "unexpected character: ";
				  prtChOrHex(msg, *tok);
				  fatal(msg.str().c_str());
				  goto scan;
				}
#line 527 "scanner.cc"
yy85:
	yych = *++YYCURSOR;
	goto yy84;
yy86:
	yych = *++YYCURSOR;
	goto yy82;
yy87:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy88:
	if(yych == 0x09) goto yy87;
	if(yych == ' ') goto yy87;
	goto yy80;
yy89:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy90:
	if(yych <= '@') {
		if(yych <= '/') goto yy75;
		if(yych <= '9') goto yy89;
		goto yy75;
	} else {
		if(yych <= 'Z') goto yy89;
		if(yych <= '`') goto yy75;
		if(yych <= 'z') goto yy89;
		goto yy75;
	}
yy91:
	yych = *++YYCURSOR;
	if(yych != '2') goto yy90;
	yych = *++YYCURSOR;
	if(yych != 'c') goto yy90;
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych != ':') goto yy90;
yy94:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '@') goto yy95;
	if(yych <= 'Z') goto yy96;
	if(yych <= '`') goto yy95;
	if(yych <= 'z') goto yy96;
yy95:
	YYCURSOR = YYMARKER;
	if(yyaccept <= 3) {
		if(yyaccept <= 1) {
			if(yyaccept <= 0) {
				goto yy61;
			} else {
				goto yy67;
			}
		} else {
			if(yyaccept <= 2) {
				goto yy69;
			} else {
				goto yy71;
			}
		}
	} else {
		if(yyaccept <= 5) {
			if(yyaccept <= 4) {
				goto yy75;
			} else {
				goto yy98;
			}
		} else {
			goto yy127;
		}
	}
yy96:
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 'Z') {
		if(yych <= '9') {
			if(yych >= '0') goto yy96;
		} else {
			if(yych <= ':') goto yy94;
			if(yych >= 'A') goto yy96;
		}
	} else {
		if(yych <= '_') {
			if(yych >= '_') goto yy96;
		} else {
			if(yych <= '`') goto yy98;
			if(yych <= 'z') goto yy96;
		}
	}
yy98:
#line 261 "scanner.re"
	{ cur = cursor;
				  tok+= 5; /* skip "re2c:" */
				  iscfg = 1;
				  yylval.str = new Str(token());
				  return CONFIG;
				}
#line 628 "scanner.cc"
yy99:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy100:
	if(yych <= '[') {
		if(yych == 0x0A) goto yy95;
		goto yy99;
	} else {
		if(yych <= '\\') goto yy103;
		if(yych <= ']') goto yy104;
		goto yy99;
	}
yy101:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '[') {
		if(yych == 0x0A) goto yy95;
		goto yy101;
	} else {
		if(yych <= '\\') goto yy106;
		if(yych <= ']') goto yy107;
		goto yy101;
	}
yy103:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy95;
	goto yy99;
yy104:
	++YYCURSOR;
#line 233 "scanner.re"
	{ cur = cursor;
				  yylval.regexp = ranToRE(token());
				  return RANGE; }
#line 666 "scanner.cc"
yy106:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy95;
	goto yy101;
yy107:
	++YYCURSOR;
#line 229 "scanner.re"
	{ cur = cursor;
				  yylval.regexp = invToRE(token());
				  return RANGE; }
#line 679 "scanner.cc"
yy109:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy110:
	if(yych <= '&') {
		if(yych == 0x0A) goto yy95;
		goto yy109;
	} else {
		if(yych <= '\'') goto yy112;
		if(yych != '\\') goto yy109;
	}
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy95;
	goto yy109;
yy112:
	++YYCURSOR;
#line 222 "scanner.re"
	{ cur = cursor;
				  yylval.regexp = strToCaseInsensitiveRE(token());
				  return STRING; }
#line 703 "scanner.cc"
yy114:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy115:
	if(yych <= '!') {
		if(yych == 0x0A) goto yy95;
		goto yy114;
	} else {
		if(yych <= '"') goto yy117;
		if(yych != '\\') goto yy114;
	}
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy95;
	goto yy114;
yy117:
	++YYCURSOR;
#line 218 "scanner.re"
	{ cur = cursor;
				  yylval.regexp = strToRE(token());
				  return STRING; }
#line 727 "scanner.cc"
yy119:
	++YYCURSOR;
#line 215 "scanner.re"
	{ tok = cursor;
				  RETURN(0); }
#line 733 "scanner.cc"
yy121:
	++YYCURSOR;
#line 212 "scanner.re"
	{ depth = 1;
				  goto comment; }
#line 739 "scanner.cc"
yy123:
	yych = *++YYCURSOR;
	if(yych == ',') goto yy137;
	goto yy125;
yy124:
	++YYCURSOR;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
yy125:
	if(yych <= '/') {
		if(yych == ',') goto yy130;
		goto yy95;
	} else {
		if(yych <= '9') goto yy124;
		if(yych == '}') goto yy128;
		goto yy95;
	}
yy126:
	++YYCURSOR;
yy127:
#line 259 "scanner.re"
	{ fatal("illegal closure form, use '{n}', '{n,}', '{n,m}' where n and m are numbers"); }
#line 762 "scanner.cc"
yy128:
	++YYCURSOR;
#line 247 "scanner.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = atoi((char *)tok+1);
				  RETURN(CLOSESIZE); }
#line 769 "scanner.cc"
yy130:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/') goto yy127;
	if(yych <= '9') goto yy133;
	if(yych != '}') goto yy127;
	++YYCURSOR;
#line 255 "scanner.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = -1;
				  RETURN(CLOSESIZE); }
#line 781 "scanner.cc"
yy133:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '/') goto yy95;
	if(yych <= '9') goto yy133;
	if(yych != '}') goto yy95;
	++YYCURSOR;
#line 251 "scanner.re"
	{ yylval.extop.minsize = atoi((char *)tok+1);
				  yylval.extop.maxsize = MAX(yylval.extop.minsize,atoi(strchr((char *)tok, ',')+1));
				  RETURN(CLOSESIZE); }
#line 794 "scanner.cc"
yy137:
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= '/') goto yy127;
	if(yych <= '9') goto yy133;
	if(yych != '}') goto yy127;
	++YYCURSOR;
#line 244 "scanner.re"
	{ yylval.op = '*';
				  RETURN(CLOSE); }
#line 805 "scanner.cc"
}
#line 290 "scanner.re"


code:

#line 812 "scanner.cc"
{
	YYCTYPE yych;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '&') {
		if(yych <= 0x0A) {
			if(yych <= 0x09) goto yy148;
			goto yy146;
		} else {
			if(yych == '"') goto yy150;
			goto yy148;
		}
	} else {
		if(yych <= '{') {
			if(yych <= '\'') goto yy151;
			if(yych <= 'z') goto yy148;
			goto yy144;
		} else {
			if(yych != '}') goto yy148;
		}
	}
	++YYCURSOR;
#line 294 "scanner.re"
	{ if(--depth == 0){
					cur = cursor;
					yylval.token = new Token(token(), tline);
					return CODE;
				  }
				  goto code; }
#line 842 "scanner.cc"
yy144:
	++YYCURSOR;
#line 300 "scanner.re"
	{ ++depth;
				  goto code; }
#line 848 "scanner.cc"
yy146:
	++YYCURSOR;
#line 302 "scanner.re"
	{ if(cursor == eof) fatal("missing '}'");
				  pos = cursor; cline++;
				  goto code;
				}
#line 856 "scanner.cc"
yy148:
	++YYCURSOR;
yy149:
#line 306 "scanner.re"
	{ goto code; }
#line 862 "scanner.cc"
yy150:
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A) goto yy149;
	goto yy157;
yy151:
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych == 0x0A) goto yy149;
	goto yy153;
yy152:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy153:
	if(yych <= '&') {
		if(yych != 0x0A) goto yy152;
	} else {
		if(yych <= '\'') goto yy148;
		if(yych == '\\') goto yy155;
		goto yy152;
	}
yy154:
	YYCURSOR = YYMARKER;
	goto yy149;
yy155:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy154;
	goto yy152;
yy156:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy157:
	if(yych <= '!') {
		if(yych == 0x0A) goto yy154;
		goto yy156;
	} else {
		if(yych <= '"') goto yy148;
		if(yych != '\\') goto yy156;
	}
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy154;
	goto yy156;
}
#line 307 "scanner.re"


comment:

#line 915 "scanner.cc"
{
	YYCTYPE yych;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= ')') {
		if(yych == 0x0A) goto yy164;
		goto yy166;
	} else {
		if(yych <= '*') goto yy161;
		if(yych == '/') goto yy163;
		goto yy166;
	}
yy161:
	++YYCURSOR;
	if((yych = *YYCURSOR) == '/') goto yy169;
yy162:
#line 322 "scanner.re"
	{ if(cursor == eof) RETURN(0);
				  goto comment; }
#line 935 "scanner.cc"
yy163:
	yych = *++YYCURSOR;
	if(yych == '*') goto yy167;
	goto yy162;
yy164:
	++YYCURSOR;
#line 318 "scanner.re"
	{ if(cursor == eof) RETURN(0);
				  tok = pos = cursor; cline++;
				  goto comment;
				}
#line 947 "scanner.cc"
yy166:
	yych = *++YYCURSOR;
	goto yy162;
yy167:
	++YYCURSOR;
#line 315 "scanner.re"
	{ ++depth;
				  fatal("ambiguous /* found");
				  goto comment; }
#line 957 "scanner.cc"
yy169:
	++YYCURSOR;
#line 311 "scanner.re"
	{ if(--depth == 0)
					goto scan;
				    else
					goto comment; }
#line 965 "scanner.cc"
}
#line 324 "scanner.re"


config:

#line 972 "scanner.cc"
{
	YYCTYPE yych;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= 0x1F) {
		if(yych != 0x09) goto yy177;
	} else {
		if(yych <= ' ') goto yy173;
		if(yych == '=') goto yy175;
		goto yy177;
	}
yy173:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy182;
yy174:
#line 328 "scanner.re"
	{ goto config; }
#line 991 "scanner.cc"
yy175:
	++YYCURSOR;
	yych = *YYCURSOR;
	goto yy180;
yy176:
#line 329 "scanner.re"
	{ iscfg = 2;
				  cur = cursor;
				  RETURN('='); 
				}
#line 1002 "scanner.cc"
yy177:
	++YYCURSOR;
#line 333 "scanner.re"
	{ fatal("missing '='"); }
#line 1007 "scanner.cc"
yy179:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy180:
	if(yych == 0x09) goto yy179;
	if(yych == ' ') goto yy179;
	goto yy176;
yy181:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy182:
	if(yych == 0x09) goto yy181;
	if(yych == ' ') goto yy181;
	goto yy174;
}
#line 334 "scanner.re"


value:

#line 1030 "scanner.cc"
{
	YYCTYPE yych;
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych <= '&') {
		if(yych <= 0x0D) {
			if(yych <= 0x08) goto yy191;
			if(yych <= 0x0A) goto yy185;
			if(yych <= 0x0C) goto yy191;
		} else {
			if(yych <= ' ') {
				if(yych <= 0x1F) goto yy191;
			} else {
				if(yych == '"') goto yy193;
				goto yy191;
			}
		}
	} else {
		if(yych <= '/') {
			if(yych <= '\'') goto yy195;
			if(yych == '-') goto yy188;
			goto yy191;
		} else {
			if(yych <= '9') {
				if(yych <= '0') goto yy186;
				goto yy189;
			} else {
				if(yych != ';') goto yy191;
			}
		}
	}
yy185:
#line 343 "scanner.re"
	{ cur = cursor;
				  yylval.str = new Str(token());
				  iscfg = 0;
				  return VALUE;
				}
#line 1069 "scanner.cc"
yy186:
	++YYCURSOR;
	if((yych = *YYCURSOR) <= 0x0D) {
		if(yych <= 0x08) goto yy191;
		if(yych <= 0x0A) goto yy187;
		if(yych <= 0x0C) goto yy191;
	} else {
		if(yych <= ' ') {
			if(yych <= 0x1F) goto yy191;
		} else {
			if(yych != ';') goto yy191;
		}
	}
yy187:
#line 338 "scanner.re"
	{ cur = cursor;
				  yylval.number = atoi(token().to_string().c_str());
				  iscfg = 0;
				  return NUMBER;
				}
#line 1090 "scanner.cc"
yy188:
	yych = *++YYCURSOR;
	if(yych <= '0') goto yy192;
	if(yych >= ':') goto yy192;
yy189:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 0x1F) {
		if(yych <= 0x0A) {
			if(yych >= 0x09) goto yy187;
		} else {
			if(yych == 0x0D) goto yy187;
		}
	} else {
		if(yych <= '9') {
			if(yych <= ' ') goto yy187;
			if(yych >= '0') goto yy189;
		} else {
			if(yych == ';') goto yy187;
		}
	}
yy191:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy192:
	if(yych <= 0x0D) {
		if(yych <= 0x08) goto yy191;
		if(yych <= 0x0A) goto yy185;
		if(yych <= 0x0C) goto yy191;
		goto yy185;
	} else {
		if(yych <= ' ') {
			if(yych <= 0x1F) goto yy191;
			goto yy185;
		} else {
			if(yych == ';') goto yy185;
			goto yy191;
		}
	}
yy193:
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= ' ') {
		if(yych <= 0x0A) {
			if(yych <= 0x08) goto yy193;
			if(yych <= 0x09) goto yy203;
			goto yy185;
		} else {
			if(yych == 0x0D) goto yy203;
			if(yych <= 0x1F) goto yy193;
			goto yy203;
		}
	} else {
		if(yych <= ':') {
			if(yych == '"') goto yy191;
			goto yy193;
		} else {
			if(yych <= ';') goto yy203;
			if(yych == '\\') goto yy205;
			goto yy193;
		}
	}
yy195:
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= ' ') {
		if(yych <= 0x0A) {
			if(yych <= 0x08) goto yy195;
			if(yych >= 0x0A) goto yy185;
		} else {
			if(yych == 0x0D) goto yy197;
			if(yych <= 0x1F) goto yy195;
		}
	} else {
		if(yych <= ':') {
			if(yych == '\'') goto yy191;
			goto yy195;
		} else {
			if(yych <= ';') goto yy197;
			if(yych == '\\') goto yy200;
			goto yy195;
		}
	}
yy197:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '&') {
		if(yych != 0x0A) goto yy197;
	} else {
		if(yych <= '\'') goto yy201;
		if(yych == '\\') goto yy202;
		goto yy197;
	}
yy199:
	YYCURSOR = YYMARKER;
	goto yy185;
yy200:
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 0x0D) {
		if(yych <= 0x09) {
			if(yych <= 0x08) goto yy195;
			goto yy197;
		} else {
			if(yych <= 0x0A) goto yy185;
			if(yych <= 0x0C) goto yy195;
			goto yy197;
		}
	} else {
		if(yych <= ' ') {
			if(yych <= 0x1F) goto yy195;
			goto yy197;
		} else {
			if(yych == ';') goto yy197;
			goto yy195;
		}
	}
yy201:
	yych = *++YYCURSOR;
	goto yy185;
yy202:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy199;
	goto yy197;
yy203:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= '!') {
		if(yych == 0x0A) goto yy199;
		goto yy203;
	} else {
		if(yych <= '"') goto yy201;
		if(yych == '\\') goto yy206;
		goto yy203;
	}
yy205:
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych <= 0x0D) {
		if(yych <= 0x09) {
			if(yych <= 0x08) goto yy193;
			goto yy203;
		} else {
			if(yych <= 0x0A) goto yy185;
			if(yych <= 0x0C) goto yy193;
			goto yy203;
		}
	} else {
		if(yych <= ' ') {
			if(yych <= 0x1F) goto yy193;
			goto yy203;
		} else {
			if(yych == ';') goto yy203;
			goto yy193;
		}
	}
yy206:
	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yych == 0x0A) goto yy199;
	goto yy203;
}
#line 348 "scanner.re"

}

void Scanner::fatal(uint ofs, const char *msg) const
{
	out.flush();
#ifdef _MSC_VER
	std::cerr << filename << "(" << tline << "): error : "
		<< "column " << (tchar + ofs + 1) << ": "
		<< msg << std::endl;
#else
	std::cerr << "re2c: error: "
		<< "line " << tline << ", column " << (tchar + ofs + 1) << ": "
		<< msg << std::endl;
#endif
   	exit(1);
}

} // end namespace re2c

