/*
** i_music.h
**
**---------------------------------------------------------------------------
** Copyright 1998-2006 Randy Heit
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
**
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote products
**    derived from this software without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
** INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
** THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**---------------------------------------------------------------------------
**
*/

#ifndef __I_MUSIC_H__
#define __I_MUSIC_H__

#include "doomdef.h"

class FileReader;

//
//	MUSIC I/O
//
void I_InitMusic ();
void I_ShutdownMusic ();
void I_BuildMIDIMenuList (struct value_t **values, float *numValues);
void I_UpdateMusic ();

// Volume.
void I_SetMusicVolume (float volume);

// PAUSE game handling.
void I_PauseSong (void *handle);
void I_ResumeSong (void *handle);

// Registers a song handle to song data.
class MusInfo;
MusInfo *I_RegisterSong (const char *file, BYTE *musiccache, int offset, int length, int device);
MusInfo *I_RegisterCDSong (int track, int cdid = 0);
MusInfo *I_RegisterURLSong (const char *url);

// Called by anything that wishes to start music.
//	Plays a song, and when the song is done,
//	starts playing it again in an endless loop.
void I_PlaySong (void *handle, int looping, float relative_vol=1.f, int subsong=0);

// Stops a song.
void I_StopSong (void *handle);

// See above (register), then think backwards
void I_UnRegisterSong (void *handle);

// Set the current order (position) for a MOD
bool I_SetSongPosition (void *handle, int order);

// Is the song still playing?
bool I_QrySongPlaying (void *handle);

// The base music class. Everything is derived from this --------------------

class MusInfo
{
public:
	MusInfo ();
	virtual ~MusInfo ();
	virtual void MusicVolumeChanged();		// snd_musicvolume changed
	virtual void TimidityVolumeChanged();	// timidity_mastervolume changed
	virtual void Play (bool looping, int subsong) = 0;
	virtual void Pause () = 0;
	virtual void Resume () = 0;
	virtual void Stop () = 0;
	virtual bool IsPlaying () = 0;
	virtual bool IsMIDI () const = 0;
	virtual bool IsValid () const = 0;
	virtual bool SetPosition (unsigned int ms);
	virtual bool SetSubsong (int subsong);
	virtual void Update();
	virtual FString GetStats();
	virtual MusInfo *GetOPLDumper(const char *filename);
	virtual MusInfo *GetWaveDumper(const char *filename, int rate);

	enum EState
	{
		STATE_Stopped,
		STATE_Playing,
		STATE_Paused
	} m_Status;
	bool m_Looping;
	bool m_NotStartedYet;	// Song has been created but not yet played
};


#endif //__I_MUSIC_H__
